/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class FridaListMemoryRegionsCommand
extends AbstractFridaCommand<Void> {
    private FridaProcess process;
    private List<FridaMemoryRegionInfo> regions = new ArrayList<FridaMemoryRegionInfo>();

    public FridaListMemoryRegionsCommand(FridaManagerImpl manager, FridaProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_ranges", "result = Process.enumerateRanges('---');");
        for (FridaMemoryRegionInfo region : this.regions) {
            this.manager.addMemoryRegionIfAbsent(this.process, region);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaMemoryRegionInfo region = new FridaMemoryRegionInfo(this.process);
        JsonObject memDetails = element.getAsJsonObject();
        region.setRangeAddress(memDetails.get("base").getAsString());
        region.setRangeSize(memDetails.get("size").getAsLong());
        region.setProtection(memDetails.get("protection").getAsString());
        JsonObject memFile = (JsonObject)memDetails.get("file");
        if (memFile != null) {
            region.setFilePath(memFile.get("path").getAsString());
            region.setFileOffset(memFile.get("offset").getAsLong());
            region.setFileSize(memFile.get("size").getAsLong());
        }
        this.regions.add(region);
    }
}

