/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.NumericUtilities;
import java.nio.ByteBuffer;

public abstract class AbstractFridaReadCommand
extends AbstractFridaCommand<AddressSetView> {
    protected final Address addr;
    protected final ByteBuffer buf;
    protected final int len;

    protected AbstractFridaReadCommand(FridaManagerImpl manager, Address addr, ByteBuffer buf, int len) {
        super(manager);
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    public AddressSetView complete(FridaPendingCommand<?> pending) {
        return new AddressSet(this.addr, this.addr.add((long)(this.len - 1)));
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        String payload = element.getAsString();
        String[] lines = payload.split("\n");
        int n = 0;
        for (String l : lines) {
            String[] split = l.split("  ");
            byte[] bytes = NumericUtilities.convertStringToBytes((String)split[1]);
            for (int i = 0; i < 16; ++i) {
                this.buf.put(n + i, bytes[i]);
            }
            n += 16;
        }
    }
}

