/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.apache.commons.lang3.StringUtils;

public class TextFieldLinker {
    protected final List<LinkedField> linkedFields = new ArrayList<LinkedField>();
    protected JTextField lastField;
    protected LinkerState state;
    private boolean haveFocus;
    protected AtomicInteger mute = new AtomicInteger(0);
    protected final List<FocusListener> focusListeners = new ArrayList<FocusListener>();

    private int clamp(int min, int val, int max) {
        return Math.max(min, Math.min(val, max));
    }

    protected void instrument() {
        this.state = new LinkerState();
        for (LinkedField lf : this.linkedFields) {
            lf.registerListener();
        }
    }

    protected void dispose() {
        for (LinkedField lf : this.linkedFields) {
            lf.unregisterListener();
        }
    }

    public void linkField(JTextField field, String exp, String sep) {
        Pattern pat = Pattern.compile(exp);
        this.linkField(field, pat, sep);
    }

    public void linkField(JTextField field, Pattern pat, String sep) {
        this.checkLast();
        if (!pat.matcher(sep).matches()) {
            throw new IllegalArgumentException(pat + " must accept " + sep);
        }
        this.linkedFields.add(new LinkedField(field, pat, sep, this.linkedFields.size()));
    }

    public void linkLastField(JTextField field) {
        this.checkLast();
        this.linkedFields.add(new LinkedField(field, null, null, this.linkedFields.size()));
        this.lastField = field;
        this.instrument();
    }

    protected void checkLast() {
        if (this.lastField != null) {
            throw new IllegalStateException("last field has already been linked");
        }
    }

    protected int findField(Component field) {
        for (int i = 0; i < this.linkedFields.size(); ++i) {
            if (this.linkedFields.get((int)i).field != field) continue;
            return i;
        }
        return -1;
    }

    protected JTextField buildField(int i) {
        return new JTextField();
    }

    protected void syncStateLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextFieldLinker.this.doSyncState();
            }
        });
    }

    public void clear() {
        this.state.reset();
        this.syncStateLater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSyncState() {
        this.mute.incrementAndGet();
        try {
            for (int i = 0; i < this.linkedFields.size(); ++i) {
                LinkedField lf = this.linkedFields.get(i);
                FieldState fs = this.state.fieldStates.get(i);
                if (!fs.text.equals(lf.field.getText())) {
                    lf.field.setText(fs.text);
                }
                if (fs.caret == lf.field.getCaretPosition()) continue;
                lf.field.setCaretPosition(fs.clampedCaret());
            }
            if (this.haveFocus) {
                this.linkedFields.get((int)this.state.whichFocus).field.grabFocus();
            }
        }
        finally {
            this.mute.decrementAndGet();
        }
    }

    public String getText() {
        return this.state.getText();
    }

    public void setText(String text) {
        LinkerState old = this.state.copy();
        this.state.setText(text);
        if (!old.equals(this.state)) {
            this.syncStateLater();
        }
    }

    public void setFont(Font font) {
        for (LinkedField lf : this.linkedFields) {
            lf.field.setFont(font);
        }
    }

    public void setCaretPosition(int pos) throws BadLocationException {
        LinkerState old = this.state.copy();
        this.state.setGlobalCaret(pos);
        if (!old.equals(this.state)) {
            this.syncStateLater();
        }
    }

    public String getTextBeforeCursor(JTextField where) {
        int i = this.findField(where);
        if (i == -1) {
            throw new IllegalArgumentException("" + where);
        }
        return this.state.getTextBeforeCursor(i);
    }

    public JTextField getField(int i) {
        return this.linkedFields.get((int)i).field;
    }

    public JTextField getFocusedField() {
        return this.getField(this.state.whichFocus);
    }

    public int getNumFields() {
        return this.linkedFields.size();
    }

    public void setVisible(boolean visible) {
        for (LinkedField lf : this.linkedFields) {
            lf.field.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.linkedFields.stream().allMatch(lf -> lf.field.isVisible());
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListeners.add(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListeners.remove(listener);
    }

    protected void fireFocusListeners(FocusEvent ev) {
        switch (ev.getID()) {
            case 1004: {
                for (FocusListener listener : this.focusListeners) {
                    listener.focusGained(ev);
                }
                break;
            }
            case 1005: {
                for (FocusListener listener : this.focusListeners) {
                    listener.focusLost(ev);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("" + ev);
            }
        }
    }

    public static TextFieldLinker twoSpacedFields() {
        TextFieldLinker linker = new TextFieldLinker();
        linker.linkField(new JTextField(), "\\s+", " ");
        linker.linkLastField(new JTextField());
        return linker;
    }

    protected class LinkerState {
        int whichFocus;
        final List<FieldState> fieldStates = new ArrayList<FieldState>();
        FieldState lastState;

        protected LinkerState() {
            for (LinkedField lf : TextFieldLinker.this.linkedFields) {
                this.fieldStates.add(new FieldState());
            }
            this.lastState = this.fieldStates.get(this.fieldStates.size() - 1);
            this.reset();
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkerState)) {
                return false;
            }
            LinkerState that = (LinkerState)o;
            if (this.whichFocus != that.whichFocus) {
                return false;
            }
            return this.fieldStates.equals(that.fieldStates);
        }

        public LinkerState copy() {
            LinkerState cp = new LinkerState();
            cp.whichFocus = this.whichFocus;
            for (FieldState fs : this.fieldStates) {
                cp.fieldStates.add(fs.copy());
            }
            return cp;
        }

        public void reset() {
            this.whichFocus = 0;
            for (FieldState fs : this.fieldStates) {
                fs.text = "";
                fs.caret = 0;
            }
        }

        public String toString() {
            String textspart = StringUtils.join(this.fieldStates, (String)",");
            return "LinkerState(" + textspart + ",focus=" + this.whichFocus + ",global='" + this.getText() + "',globalC=" + this.getGlobalCaret() + ")";
        }

        public String getText() {
            return this.getText(-1);
        }

        public String getText(int omitSep) {
            int lastPopulated;
            for (lastPopulated = TextFieldLinker.this.linkedFields.size() - 1; lastPopulated >= 0 && this.fieldStates.get((int)lastPopulated).text.length() == 0; --lastPopulated) {
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i <= lastPopulated; ++i) {
                if (i > 0 && omitSep != i - 1) {
                    result.append(TextFieldLinker.this.linkedFields.get((int)(i - 1)).sep);
                }
                result.append(this.fieldStates.get((int)i).text);
            }
            return result.toString();
        }

        public int getGlobalCaret() {
            return this.getGlobalCaret(-1);
        }

        public int getGlobalCaret(int omitSep) {
            int caret = 0;
            for (int i = 0; i < this.whichFocus; ++i) {
                if (i > 0 && omitSep != i - 1) {
                    caret += TextFieldLinker.this.linkedFields.get((int)(i - 1)).sep.length();
                }
                caret += this.fieldStates.get((int)i).text.length();
            }
            if (this.whichFocus > 0 && omitSep != this.whichFocus - 1) {
                caret += TextFieldLinker.this.linkedFields.get((int)(this.whichFocus - 1)).sep.length();
            }
            FieldState fs = this.fieldStates.get(this.whichFocus);
            return caret += fs.clampedCaret();
        }

        public String getTextBeforeCursor(int field) {
            if (field == -1) {
                throw new IllegalArgumentException("" + field);
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < field; ++i) {
                if (i > 0) {
                    result.append(TextFieldLinker.this.linkedFields.get((int)(i - 1)).sep);
                }
                result.append(this.fieldStates.get((int)i).text);
            }
            if (field > 0) {
                result.append(TextFieldLinker.this.linkedFields.get((int)(field - 1)).sep);
            }
            FieldState fs = this.fieldStates.get(field);
            result.append(fs.text.substring(0, Math.min(fs.caret, fs.text.length())));
            return result.toString();
        }

        public boolean isAfterSep(int field) {
            return field > 0 && this.fieldStates.get((int)field).caret == 0;
        }

        public boolean isBeforeSep(int field) {
            if (field >= this.fieldStates.size() - 1) {
                return false;
            }
            FieldState fs = this.fieldStates.get(field);
            return fs.caret == fs.text.length();
        }

        public void navigateFieldLeft(int field) {
            this.whichFocus = field;
            FieldState fs = this.fieldStates.get(field);
            fs.caret = fs.text.length();
        }

        public void navigateFieldRight(int field) {
            this.whichFocus = field;
            this.fieldStates.get((int)field).caret = 0;
        }

        protected void removeSep(int sep) {
            int caretWOSep = this.getGlobalCaret(sep);
            String textWOSep = this.getText(sep);
            this.setText(textWOSep);
            if (this.whichFocus > sep) {
                try {
                    this.setGlobalCaret(caretWOSep);
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public int setText(String text) {
            int adj = 0;
            for (int i = 0; i < TextFieldLinker.this.linkedFields.size() - 1; ++i) {
                LinkedField lf = TextFieldLinker.this.linkedFields.get(i);
                FieldState fs = this.fieldStates.get(i);
                if (text.length() == 0) {
                    fs.text = "";
                    continue;
                }
                Matcher mat = lf.pat.matcher(text);
                if (mat.find(0)) {
                    fs.text = text.substring(0, mat.start());
                    text = text.substring(mat.end());
                    if (i >= this.whichFocus) continue;
                    adj += lf.sep.length() - mat.group().length();
                    continue;
                }
                fs.text = text;
                text = "";
            }
            this.lastState.text = text;
            return adj;
        }

        public void setGlobalCaret(int caret) throws BadLocationException {
            int globalCaret = caret;
            for (int i = 0; i < this.fieldStates.size(); ++i) {
                FieldState fs = this.fieldStates.get(i);
                if (i > 0) {
                    caret -= TextFieldLinker.this.linkedFields.get((int)(i - 1)).sep.length();
                }
                if (caret <= 0) {
                    this.whichFocus = i;
                    fs.caret = 0;
                    return;
                }
                if (caret <= fs.text.length()) {
                    this.whichFocus = i;
                    fs.caret = caret;
                    return;
                }
                caret -= fs.text.length();
            }
            throw new BadLocationException("caret position (" + globalCaret + ") too large", globalCaret);
        }

        public void reformat() {
            String text = this.getText();
            int globalCaret = this.getGlobalCaret();
            globalCaret += this.setText(text);
            try {
                this.setGlobalCaret(globalCaret);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected class LinkedField {
        protected final JTextField field;
        protected final Pattern pat;
        protected final String sep;
        protected final int index;
        protected DualFieldListener listener;

        protected LinkedField(JTextField field, Pattern pat, String sep, int index) {
            this.field = field;
            this.pat = pat;
            this.sep = sep;
            this.index = index;
        }

        protected void registerListener() {
            this.listener = new DualFieldListener(this);
            this.field.addCaretListener(this.listener);
            this.field.getDocument().addDocumentListener(this.listener);
            this.field.addKeyListener(this.listener);
            this.field.addFocusListener(this.listener);
        }

        public void unregisterListener() {
            this.field.removeCaretListener(this.listener);
            this.field.getDocument().removeDocumentListener(this.listener);
            this.field.removeKeyListener(this.listener);
            this.field.removeFocusListener(this.listener);
            this.listener = null;
        }
    }

    protected class FieldState {
        protected String text;
        protected int caret;

        protected FieldState() {
        }

        public String toString() {
            return "'" + this.text + "'c=" + this.caret;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldState)) {
                return false;
            }
            FieldState that = (FieldState)obj;
            if (!this.text.equals(that.text)) {
                return false;
            }
            return this.caret == that.caret;
        }

        protected FieldState copy() {
            FieldState cp = new FieldState();
            cp.text = this.text;
            cp.caret = this.caret;
            return cp;
        }

        public int clampedCaret() {
            return TextFieldLinker.this.clamp(0, this.caret, this.text.length());
        }
    }

    private class DualFieldListener
    extends KeyAdapter
    implements CaretListener,
    FocusListener,
    DocumentListener {
        private LinkedField linked;

        public DualFieldListener(LinkedField linked) {
            this.linked = linked;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (TextFieldLinker.this.mute.get() != 0) {
                return;
            }
            LinkerState old = TextFieldLinker.this.state.copy();
            TextFieldLinker.this.state.fieldStates.get((int)this.linked.index).caret = this.linked.field.getCaretPosition();
            TextFieldLinker.this.state.reformat();
            if (!old.equals(TextFieldLinker.this.state)) {
                TextFieldLinker.this.syncStateLater();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Caret caret = this.linked.field.getCaret();
            boolean sel = caret.getMark() != caret.getDot();
            switch (e.getKeyCode()) {
                case 8: {
                    if (sel || !TextFieldLinker.this.state.isAfterSep(this.linked.index)) break;
                    TextFieldLinker.this.state.removeSep(this.linked.index - 1);
                    e.consume();
                    break;
                }
                case 12: {
                    TextFieldLinker.this.clear();
                    break;
                }
                case 127: {
                    if (sel || !TextFieldLinker.this.state.isBeforeSep(this.linked.index)) break;
                    TextFieldLinker.this.state.removeSep(this.linked.index);
                    e.consume();
                    break;
                }
                case 37: 
                case 226: {
                    if (!TextFieldLinker.this.state.isAfterSep(this.linked.index)) break;
                    TextFieldLinker.this.state.navigateFieldLeft(this.linked.index - 1);
                    break;
                }
                case 39: 
                case 227: {
                    if (!TextFieldLinker.this.state.isBeforeSep(this.linked.index)) break;
                    TextFieldLinker.this.state.navigateFieldRight(this.linked.index + 1);
                    break;
                }
                default: {
                    return;
                }
            }
            TextFieldLinker.this.syncStateLater();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!TextFieldLinker.this.haveFocus) {
                TextFieldLinker.this.haveFocus = true;
                TextFieldLinker.this.fireFocusListeners(e);
            }
            TextFieldLinker.this.state.whichFocus = this.linked.index;
        }

        @Override
        public void focusLost(FocusEvent e) {
            int i = TextFieldLinker.this.findField(e.getOppositeComponent());
            if (i == -1 && TextFieldLinker.this.haveFocus) {
                TextFieldLinker.this.haveFocus = false;
                TextFieldLinker.this.fireFocusListeners(e);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (TextFieldLinker.this.mute.get() != 0) {
                return;
            }
            TextFieldLinker.this.state.fieldStates.get((int)this.linked.index).text = this.linked.field.getText();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (TextFieldLinker.this.mute.get() != 0) {
                return;
            }
            TextFieldLinker.this.state.fieldStates.get((int)this.linked.index).text = this.linked.field.getText();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

