/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.AddRemoveJob;
import docking.widgets.table.threaded.FilterJob;
import docking.widgets.table.threaded.LoadJob;
import docking.widgets.table.threaded.LoadSpecificDataJob;
import docking.widgets.table.threaded.SortJob;
import docking.widgets.table.threaded.TableData;
import docking.widgets.table.threaded.TableUpdateJob;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.concurrent.ConcurrentListenerSet;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.task.DummyCancellableTaskMonitor;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ThreadedTableModelUpdateMgr<T> {
    public static final int DELAY = 5000;
    public static final int MAX_DELAY = 1200000;
    static final int TOO_MANY_ADD_REMOVES = 3000;
    private ThreadedTableModel<T, ?> model;
    private SwingUpdateManager addRemoveUpdater;
    private TaskMonitor monitor;
    private ConcurrentListenerSet<ThreadedTableModelListener> listeners = new ConcurrentListenerSet();
    private TableUpdateJob<T> pendingJob;
    private TableUpdateJob<T> currentJob;
    private Thread thread;
    private List<AddRemoveListItem<T>> addRemoveWaitList = new ArrayList<AddRemoveListItem<T>>();
    private final int maxAddRemoveCount;
    private Runnable notifyPending;
    private Runnable notifyUpdating;
    private Runnable notifyDone;
    private Runnable notifyCancelled;
    private Runnable threadRunnable = new ThreadRunnable();

    ThreadedTableModelUpdateMgr(ThreadedTableModel<T, ?> threadedTableModel, TaskMonitor monitor) {
        this.model = threadedTableModel;
        this.monitor = this.validateMonitor(monitor);
        this.maxAddRemoveCount = 3000;
        SystemUtilities.assertTrue((boolean)this.monitor.isCancelEnabled(), (String)"In order for this update manager to work correctly the given task monitor must be cancel enabled (e.g., you cannot use the TaskMonitor.DUMMY, as that is not cancelleable)");
        this.addRemoveUpdater = new SwingUpdateManager(5000, 1200000, () -> this.processAddRemoveItems());
        this.notifyPending = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadPending();
            }
        };
        this.notifyUpdating = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingStarted();
            }
        };
        this.notifyDone = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingFinished(false);
            }
        };
        this.notifyCancelled = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingFinished(true);
            }
        };
    }

    private TaskMonitor validateMonitor(TaskMonitor clientMonitor) {
        if (clientMonitor != null && clientMonitor.isCancelEnabled()) {
            return clientMonitor;
        }
        return new DummyCancellableTaskMonitor();
    }

    Object getSynchronizingLock() {
        return this.addRemoveUpdater;
    }

    private int getMaxAddRemoveCount() {
        int n = this.model.getRowCount();
        int cuttoff = (int)((double)n * 0.1);
        return Math.max(this.maxAddRemoveCount, cuttoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllJobs() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.addRemoveUpdater.stop();
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.pendingJob = null;
            this.addRemoveWaitList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.cancelAllJobs();
            this.runJob(new LoadJob<T>(this.model, this.monitor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadSpecificData(List<T> data) {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.cancelAllJobs();
            TableData<T> tableData = TableData.createFullDataset(data);
            this.runJob(new LoadSpecificDataJob<T>(this.model, this.monitor, tableData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sort(TableSortingContext<T> sortingContext, boolean forceSort) {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            if (this.currentJob != null && this.pendingJob == null && this.currentJob.requestSort(sortingContext, forceSort)) {
                return;
            }
            if (this.pendingJob != null && this.pendingJob.requestSort(sortingContext, forceSort)) {
                return;
            }
            this.runJob(new SortJob<T>(this.model, this.monitor, sortingContext, forceSort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filter() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            if (this.currentJob != null && this.pendingJob == null && this.currentJob.requestFilter()) {
                return;
            }
            if (this.pendingJob != null && this.pendingJob.requestFilter()) {
                return;
            }
            this.runJob(new FilterJob<T>(this.model, this.monitor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRemove(AddRemoveListItem<T> item) {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            if (this.pendingJob != null) {
                this.pendingJob.addRemove(item, this.getMaxAddRemoveCount());
                this.addRemoveUpdater.updateLater();
                return;
            }
            if (this.addRemoveWaitList.isEmpty() && this.thread == null) {
                Swing.runLater((Runnable)this.notifyPending);
            }
            this.addRemoveWaitList.add(item);
            this.addRemoveUpdater.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddRemoveItems() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            if (this.addRemoveWaitList.isEmpty()) {
                return;
            }
            if (this.addRemoveWaitList.size() > this.getMaxAddRemoveCount()) {
                this.reload();
                return;
            }
            this.runJob(new AddRemoveJob<T>(this.model, this.addRemoveWaitList, this.monitor));
            this.addRemoveWaitList = new ArrayList<AddRemoveListItem<T>>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBusy() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            return this.thread != null || this.pendingJob != null || this.addRemoveUpdater.isBusy() || !this.addRemoveWaitList.isEmpty();
        }
    }

    void setUpdateDelay(int updateDelayMillis, int maxUpdateDelayMillis) {
        this.addRemoveUpdater.dispose();
        this.addRemoveUpdater = new SwingUpdateManager(updateDelayMillis, maxUpdateDelayMillis, () -> this.processAddRemoveItems());
    }

    void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    TaskMonitor getTaskMonitor() {
        return this.monitor;
    }

    void addThreadedTableListener(ThreadedTableModelListener listener) {
        this.listeners.add((Object)listener);
    }

    void removeThreadedTableListener(ThreadedTableModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.listeners.clear();
            this.monitor.cancel();
            this.monitor = new PermantentlyCancelledMonitor();
            this.cancelAllJobs();
            this.addRemoveUpdater.dispose();
        }
    }

    public void updateNow() {
        this.addRemoveUpdater.updateNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob(TableUpdateJob<T> job) {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.pendingJob = Objects.requireNonNull(job);
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(this.threadRunnable, "Threaded Table Model Update Manager: " + this.model.getName());
            this.thread.start();
            Swing.runLater((Runnable)this.notifyUpdating);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableUpdateJob<T> getNextJob() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            this.currentJob = this.pendingJob;
            this.pendingJob = null;
            if (this.currentJob == null) {
                this.jobDone();
            }
            return this.currentJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobDone() {
        SwingUpdateManager swingUpdateManager = this.addRemoveUpdater;
        synchronized (swingUpdateManager) {
            boolean isCancelled = this.monitor.isCancelled();
            if (isCancelled) {
                Swing.runLater((Runnable)this.notifyCancelled);
            } else {
                Swing.runLater((Runnable)this.notifyDone);
            }
            this.thread = null;
            if (!this.addRemoveWaitList.isEmpty()) {
                Swing.runLater((Runnable)this.notifyPending);
            }
        }
    }

    private class ThreadRunnable
    implements Runnable {
        private ThreadRunnable() {
        }

        @Override
        public void run() {
            TableUpdateJob job = ThreadedTableModelUpdateMgr.this.getNextJob();
            while (job != null) {
                ThreadedTableModelUpdateMgr.this.monitor.clearCancelled();
                job.run();
                job = ThreadedTableModelUpdateMgr.this.getNextJob();
            }
        }
    }

    private class PermantentlyCancelledMonitor
    extends TaskMonitorAdapter {
        public PermantentlyCancelledMonitor() {
            this.setCancelEnabled(true);
            this.cancel();
        }

        public void clearCancelled() {
        }
    }
}

