/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.DialogComponentProvider;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterSaveManager;
import docking.widgets.table.constraint.dialog.ColumnFilterDialog;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class ColumnFilterArchiveDialog<R>
extends DialogComponentProvider {
    private ColumnFilterSaveManager<R> manager;
    private JLabel previewLabel;
    private JButton removeSelectedFiltersButton;
    private ColumnBasedTableFilter<R> selectedColumnFilter = null;
    private JList<ColumnBasedTableFilter<R>> jList;
    private ColumnFilterDialog<R> filterDialog;

    protected ColumnFilterArchiveDialog(ColumnFilterDialog<R> filterDialog, ColumnFilterSaveManager<R> manager, String tableName) {
        super(ColumnFilterArchiveDialog.getDialogTitle(tableName), true, false, true, false);
        this.filterDialog = filterDialog;
        Objects.requireNonNull(manager, "ColumnFilterSaveManager must be non-null");
        this.manager = manager;
        this.addWorkPanel(this.buildComponent());
        this.addOKButton();
        this.addCancelButton();
        this.setOkButtonText("Load");
        this.okButton.setMnemonic('L');
        this.setOkEnabled(true);
        this.setPreferredSize(800, 300);
        this.setRememberSize(true);
    }

    private static String getDialogTitle(String tableName) {
        StringBuilder sb = new StringBuilder("Saved Table Column Filters");
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            sb.append(" for '").append(tableName).append("'");
        }
        return sb.toString();
    }

    private JComponent buildComponent() {
        JComponent component = this.buildFilterTable();
        component.setPreferredSize(new Dimension(100, 200));
        JSplitPane splitter = new JSplitPane(1, component, this.buildPreviewPanel());
        splitter.setResizeWeight(0.25);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)splitter, "Center");
        return panel;
    }

    ColumnBasedTableFilter<R> getSelectedColumnFilter() {
        return this.selectedColumnFilter;
    }

    @Override
    public void okCallback() {
        this.close();
    }

    @Override
    public void cancelCallback() {
        this.selectedColumnFilter = null;
        super.cancelCallback();
    }

    private JComponent buildFilterTable() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildFilterList(), "Center");
        panel.add((Component)this.buildActionPanel(), "South");
        return panel;
    }

    private JComponent buildFilterList() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(19, 0, 0, 5), "Filter Names"));
        this.jList = new JList();
        this.jList.setSelectionMode(0);
        this.jList.addListSelectionListener(e -> this.listSelectionChanged(this.jList.getSelectedValue()));
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ColumnFilterArchiveDialog.this.okCallback();
                }
            }
        });
        this.updateList();
        panel.add(new JScrollPane(this.jList));
        return panel;
    }

    private JComponent buildActionPanel() {
        Icon icon = Icons.DELETE_ICON;
        this.removeSelectedFiltersButton = new JButton("Remove", icon);
        this.removeSelectedFiltersButton.setEnabled(false);
        this.removeSelectedFiltersButton.addActionListener(e -> this.removeSelectedFilter());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.removeSelectedFiltersButton, "East");
        return panel;
    }

    private Component buildPreviewPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(19, 0, 26, 5), "Preview"));
        this.previewLabel = new GDHtmlLabel();
        this.previewLabel.setVerticalAlignment(1);
        panel.add(new JScrollPane(this.previewLabel));
        return panel;
    }

    private void updateList() {
        this.jList.setModel(new AbstractListModel<ColumnBasedTableFilter<R>>(){

            @Override
            public int getSize() {
                return ColumnFilterArchiveDialog.this.manager.getSavedFilters().size();
            }

            @Override
            public ColumnBasedTableFilter<R> getElementAt(int index) {
                return ColumnFilterArchiveDialog.this.manager.getSavedFilters().get(index);
            }
        });
    }

    private void listSelectionChanged(ColumnBasedTableFilter<R> selectedFilter) {
        this.selectedColumnFilter = selectedFilter;
        this.updatePreview();
        this.removeSelectedFiltersButton.setEnabled(selectedFilter != null);
        this.setOkEnabled(selectedFilter != null);
    }

    private void removeSelectedFilter() {
        ColumnBasedTableFilter<R> filter = this.selectedColumnFilter;
        this.manager.removeFilter(filter);
        this.manager.save();
        this.updateList();
        this.filterDialog.filterRemoved(filter);
    }

    private void updatePreview() {
        if (this.selectedColumnFilter != null) {
            this.previewLabel.setText(HTMLUtilities.wrapAsHTML((String)this.selectedColumnFilter.getHtmlRepresentation()));
        } else {
            this.previewLabel.setText("");
        }
    }
}

