/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DialogComponentProvider;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.VariableColumnTableModel;
import generic.theme.GColor;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SelectColumnsDialog
extends DialogComponentProvider {
    private static final Color BG_NON_DEFAULT = new GColor("color.fg.disabled");
    private static final String DISCOVERED_TABLE_COLUMN_NAME = "Non-default";
    private GTable ghidraTable;
    private final TableModel sourceTablemodel;
    private List<TableColumnWrapper> columnList;
    private Map<TableColumn, Boolean> visibilityMap = new HashMap<TableColumn, Boolean>();
    private final GTableColumnModel columnModel;

    public SelectColumnsDialog(GTableColumnModel columnModel, TableModel model) {
        super("Select Columns", true, true, true, false);
        this.columnModel = columnModel;
        this.sourceTablemodel = model;
        this.initialize();
        SelectColumnsModel tableModel = new SelectColumnsModel();
        this.ghidraTable = new GTable(tableModel);
        this.ghidraTable.setAutoResizeMode(3);
        this.ghidraTable.setAutoLookupColumn(1);
        TableColumn enabledColumn = this.ghidraTable.getColumnModel().getColumn(0);
        int enabledColumnWidth = 30;
        enabledColumn.setPreferredWidth(enabledColumnWidth);
        enabledColumn.setMaxWidth(enabledColumnWidth);
        enabledColumn.setCellRenderer(new ColumnSelectorBooleanRenderer());
        this.ghidraTable.getTableHeader().setReorderingAllowed(false);
        this.ghidraTable.setColumnHeaderPopupEnabled(false);
        for (int i = 1; i < this.ghidraTable.getColumnCount(); ++i) {
            this.ghidraTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnSelectorStringRenderer());
        }
        this.ghidraTable.setBorder(BorderFactory.createEtchedBorder());
        Dimension size = new Dimension(400, 500);
        this.setPreferredSize(size.width, size.height);
        this.setRememberSize(true);
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.ghidraTable);
        panel.add(scrollPane);
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("Tables/GhidraTableHeaders.html", "SelectColumns"));
    }

    private void initialize() {
        List<TableColumn> columns = this.columnModel.getAllColumns();
        this.columnList = new ArrayList<TableColumnWrapper>(columns.size());
        for (TableColumn column : columns) {
            this.visibilityMap.put(column, this.columnModel.isVisible(column));
            this.columnList.add(new TableColumnWrapper(this.sourceTablemodel, column));
        }
        Collections.sort(this.columnList, new ColumnComparator());
    }

    boolean isOK() {
        for (Boolean value : this.visibilityMap.values()) {
            if (!value.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void okCallback() {
        if (!this.isOK()) {
            this.setStatusText("No Columns selected!");
            return;
        }
        for (TableColumn column : this.visibilityMap.keySet()) {
            Boolean visible = this.visibilityMap.get(column);
            if (visible.booleanValue() == this.columnModel.isVisible(column)) continue;
            this.columnModel.setVisible(column, visible);
        }
        this.columnModel.forceSaveState();
        this.close();
    }

    private class SelectColumnsModel
    extends DefaultTableModel {
        private SelectColumnsModel() {
        }

        @Override
        public int getRowCount() {
            if (SelectColumnsDialog.this.columnList == null) {
                return 0;
            }
            return SelectColumnsDialog.this.columnList.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            TableColumnWrapper tableColumnWrapper = SelectColumnsDialog.this.columnList.get(row);
            TableColumn tableColumn = tableColumnWrapper.getTableColumn();
            if (column == 0) {
                return SelectColumnsDialog.this.visibilityMap.get(tableColumn);
            }
            if (column == 1) {
                return tableColumn.getHeaderValue();
            }
            if (column == 2) {
                if (tableColumnWrapper.isDefault()) {
                    return "Default";
                }
                return SelectColumnsDialog.DISCOVERED_TABLE_COLUMN_NAME;
            }
            return "<<unknown>>";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                TableColumnWrapper tableColumnWrapper = SelectColumnsDialog.this.columnList.get(row);
                SelectColumnsDialog.this.visibilityMap.put(tableColumnWrapper.getTableColumn(), (Boolean)aValue);
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 2) {
                return String.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Visible";
            }
            if (column == 1) {
                return "Column Name";
            }
            if (column == 2) {
                return "Is Default?";
            }
            return "<<unknown>>";
        }
    }

    private class ColumnSelectorBooleanRenderer
    extends GBooleanCellRenderer {
        private ColumnSelectorBooleanRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(data);
            int row = data.getRowViewIndex();
            boolean isSelected = data.isSelected();
            if (isSelected) {
                return c;
            }
            TableColumnWrapper tableColumnWrapper = SelectColumnsDialog.this.columnList.get(row);
            if (!tableColumnWrapper.isDefault()) {
                c.setBackground(BG_NON_DEFAULT);
                c.setOpaque(true);
            }
            String columnDescription = tableColumnWrapper.getColumnDescription();
            c.setToolTipText(columnDescription);
            return c;
        }
    }

    private class ColumnSelectorStringRenderer
    extends GTableCellRenderer {
        private ColumnSelectorStringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(data);
            int row = data.getRowViewIndex();
            boolean isSelected = data.isSelected();
            if (isSelected) {
                return c;
            }
            TableColumnWrapper tableColumnWrapper = SelectColumnsDialog.this.columnList.get(row);
            if (!tableColumnWrapper.isDefault()) {
                c.setBackground(BG_NON_DEFAULT);
                c.setOpaque(true);
            }
            String columnDescription = tableColumnWrapper.getColumnDescription();
            c.setToolTipText(columnDescription);
            return c;
        }
    }

    private class TableColumnWrapper {
        private final TableColumn column;
        private final TableModel model;

        TableColumnWrapper(TableModel model, TableColumn column) {
            this.model = model;
            this.column = column;
        }

        boolean isDefault() {
            VariableColumnTableModel variableModel = VariableColumnTableModel.from(this.model);
            if (variableModel == null) {
                return true;
            }
            int modelIndex = this.column.getModelIndex();
            return variableModel.isDefaultColumn(modelIndex);
        }

        String getColumnDescription() {
            VariableColumnTableModel variableModel = VariableColumnTableModel.from(this.model);
            if (variableModel == null) {
                return null;
            }
            int modelIndex = this.column.getModelIndex();
            return variableModel.getColumnDescription(modelIndex);
        }

        TableColumn getTableColumn() {
            return this.column;
        }
    }

    private class ColumnComparator
    implements Comparator<TableColumnWrapper> {
        private ColumnComparator() {
        }

        @Override
        public int compare(TableColumnWrapper wrapper1, TableColumnWrapper wrapper2) {
            boolean isDefault1 = wrapper1.isDefault();
            boolean isDefault2 = wrapper2.isDefault();
            TableColumn column1 = wrapper1.getTableColumn();
            TableColumn column2 = wrapper2.getTableColumn();
            if (isDefault1 == isDefault2) {
                String headerString1 = column1.getHeaderValue().toString();
                String headerString2 = column2.getHeaderValue().toString();
                return headerString1.compareTo(headerString2);
            }
            if (isDefault1) {
                return -1;
            }
            return 1;
        }
    }
}

