/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.DockingUtils;
import docking.widgets.filter.ClearFilterLabel;
import docking.widgets.filter.FilterListener;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utility.function.Callback;

public class FilterTextField
extends JPanel {
    private static final Integer BASE_COMPONENT_LAYER = 1;
    private static final Integer HOVER_COMPONENT_LAYER = 2;
    private static final long MINIMUM_TIME_BETWEEN_FLASHES_MS = 5000L;
    private static final int FLASH_FREQUENCY_MS = 250;
    private static Color FLASH_FOREGROUND_COLOR = new GColor("color.fg");
    private static Color FILTERED_BACKGROUND_COLOR = new GColor("color.bg.filterfield");
    private static Color FILTERED_FOREGROUND_COLOR = new GColor("color.fg.filterfield");
    static Color UNEDITABLE_BACKGROUND_COLOR = new GColor("color.bg.uneditable");
    private Color noFlashBgColor = GThemeDefaults.Colors.BACKGROUND;
    private Color noFlashFgColor = GThemeDefaults.Colors.FOREGROUND;
    private long lastFlashTime = 0L;
    private Timer flashTimer = new BackgroundFlashTimer();
    private boolean hasText;
    private JLayeredPane layeredPane;
    private JTextField textField = new JTextField();
    private ClearFilterLabel clearLabel = new ClearFilterLabel(this.textField);
    private Component focusComponent;
    private FocusListener flashFocusListener = new FlashFocusListener();
    private WeakSet<FilterListener> listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private WeakSet<Callback> enterListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();

    public FilterTextField(Component component) {
        this(component, 0);
    }

    public FilterTextField(Component component, int columns) {
        super(new BorderLayout());
        this.textField.setColumns(columns);
        this.textField.setBackground(this.noFlashBgColor);
        this.textField.setForeground(this.noFlashFgColor);
        this.setFocusComponent(component);
        this.textField.addKeyListener(new TraversalKeyListener(component));
        this.textField.getDocument().addDocumentListener(new FilterDocumentListener());
        this.textField.addActionListener(e -> this.notifyEnterPressed());
        this.layeredPane = new JLayeredPane(){

            @Override
            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                Dimension ps = FilterTextField.this.textField.getPreferredSize();
                ps.width += insets.left + insets.right;
                ps.height += insets.top + insets.bottom;
                return ps;
            }
        };
        this.layeredPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.layeredPane.add((Component)this.textField, BASE_COMPONENT_LAYER);
        this.layeredPane.add((Component)this.clearLabel, HOVER_COMPONENT_LAYER);
        this.clearLabel.setVisible(false);
        this.layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = FilterTextField.this.layeredPane.getSize();
                Insets insets = FilterTextField.this.layeredPane.getInsets();
                int x = insets.left;
                int y = insets.top;
                int width = preferredSize.width - insets.right - x;
                int height = preferredSize.height - (insets.top + insets.bottom);
                FilterTextField.this.textField.setBounds(x, y, width, height);
            }
        });
        this.add((Component)this.layeredPane, "North");
        DockingUtils.installUndoRedo(this.textField);
    }

    private void notifyEnterPressed() {
        this.enterListeners.forEach(l -> l.call());
    }

    public void setFocusComponent(Component component) {
        if (this.focusComponent != null) {
            this.focusComponent.removeFocusListener(this.flashFocusListener);
        }
        this.focusComponent = component;
        if (this.focusComponent != null) {
            this.focusComponent.addFocusListener(this.flashFocusListener);
        }
    }

    private void flashFilterBorder() {
        if (!this.hasText || !this.isEditable()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFlashTime < this.getMinimumTimeBetweenFlashes()) {
            return;
        }
        this.flashTimer.restart();
    }

    public void alert() {
        this.alert(false);
    }

    public void alert(boolean forceAlert) {
        if (forceAlert) {
            this.resetFocusFlashing();
        }
        this.flashFilterBorder();
    }

    private void stallFocusFlashing() {
        this.lastFlashTime = System.currentTimeMillis();
    }

    private void stopFocusFlashing() {
        this.flashTimer.stop();
    }

    private void resetFocusFlashing() {
        this.lastFlashTime = -this.getMinimumTimeBetweenFlashes();
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
        this.updateColor();
    }

    private void updateColor() {
        Color bgColor = UNEDITABLE_BACKGROUND_COLOR;
        Color fgColor = this.noFlashFgColor;
        if (this.isEditable() && this.isEnabled()) {
            bgColor = this.hasText ? FILTERED_BACKGROUND_COLOR : this.noFlashBgColor;
            fgColor = this.hasText ? FILTERED_FOREGROUND_COLOR : this.noFlashFgColor;
        }
        this.doSetBackground(bgColor);
        this.doSetForeground(fgColor);
    }

    private void contrastColors() {
        Color contrastBg = this.noFlashBgColor;
        Color contrastFg = FLASH_FOREGROUND_COLOR;
        if (this.textField.getBackground() == this.noFlashBgColor) {
            contrastBg = FILTERED_BACKGROUND_COLOR;
            contrastFg = FILTERED_FOREGROUND_COLOR;
        }
        this.doSetBackground(contrastBg);
        this.doSetForeground(contrastFg);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void addEnterListener(Callback callback) {
        this.enterListeners.add((Object)callback);
    }

    public void removeEnterListener(Callback callback) {
        this.enterListeners.remove((Object)callback);
    }

    public void addFilterListener(FilterListener l) {
        this.listeners.add((Object)l);
    }

    public void removeFilterListener(FilterListener l) {
        this.listeners.remove((Object)l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.updateField(this.textField.getText().length() > 0);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    private void fireFilterChanged(String text) {
        for (FilterListener l : this.listeners) {
            l.filterChanged(text);
        }
    }

    void doSetBackground(Color c) {
        this.textField.setBackground(c);
    }

    void doSetForeground(Color c) {
        this.textField.setForeground(c);
    }

    JLabel getClearLabel() {
        return this.clearLabel;
    }

    Timer getFlashTimer() {
        return this.flashTimer;
    }

    long getMinimumTimeBetweenFlashes() {
        return 5000L;
    }

    int getFlashFrequency() {
        return 250;
    }

    JTextField getTextField() {
        return this.textField;
    }

    private void updateField(boolean fireEvent) {
        String text = this.getText();
        this.hasText = text.length() > 0;
        this.updateFocusFlashing();
        this.updateColor();
        if (fireEvent) {
            this.fireFilterChanged(text);
        }
        boolean showFilterButton = this.hasText && this.textField.isEnabled();
        this.updateFilterButton(showFilterButton);
    }

    private void updateFocusFlashing() {
        if (this.hasText) {
            this.stallFocusFlashing();
        } else {
            this.stopFocusFlashing();
        }
    }

    private void updateFilterButton(boolean showFilter) {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            if (showFilter) {
                this.clearLabel.showFilterButton();
            } else {
                this.clearLabel.hideFilterButton();
            }
        });
    }

    private class BackgroundFlashTimer
    extends Timer
    implements ActionListener {
        private static final int MAX_FLASH_COUNT = 6;
        int flashCount;

        private BackgroundFlashTimer() {
            super(FilterTextField.this.getFlashFrequency(), null);
            this.flashCount = 0;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.flashCount < 6) {
                FilterTextField.this.contrastColors();
                ++this.flashCount;
            } else {
                this.stop();
                FilterTextField.this.stallFocusFlashing();
            }
        }

        @Override
        public void restart() {
            this.flashCount = 0;
            super.restart();
        }

        @Override
        public void stop() {
            super.stop();
            FilterTextField.this.updateColor();
            this.flashCount = 0;
        }
    }

    private class FlashFocusListener
    extends FocusAdapter {
        private FlashFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FilterTextField.this.flashFilterBorder();
        }
    }

    private class TraversalKeyListener
    implements KeyListener {
        private final Component component;

        private TraversalKeyListener(Component component) {
            this.component = component;
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                this.component.requestFocus();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class FilterDocumentListener
    implements DocumentListener {
        private FilterDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FilterTextField.this.updateField(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FilterTextField.this.updateField(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FilterTextField.this.updateField(true);
        }
    }
}

