/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingUtils;
import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import generic.util.WindowUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.text.Document;

public class ScrollableTextArea
extends JScrollPane {
    private PrivateTextArea textArea;

    public ScrollableTextArea() {
        this.textArea = new PrivateTextArea();
        this.initialize();
    }

    public ScrollableTextArea(String text) {
        this.textArea = new PrivateTextArea(text);
        this.initialize();
    }

    public ScrollableTextArea(int rows, int columns) {
        this.textArea = new PrivateTextArea(rows, columns);
        this.initialize();
    }

    public ScrollableTextArea(String text, int rows, int columns) {
        this.textArea = new PrivateTextArea(text, rows, columns);
        this.initialize();
    }

    public ScrollableTextArea(Document doc) {
        this.textArea = new PrivateTextArea(doc);
        this.initialize();
    }

    public ScrollableTextArea(Document doc, String text, int rows, int columns) {
        this.textArea = new PrivateTextArea(doc, text, rows, columns);
        this.initialize();
    }

    public void append(String text) {
        this.textArea.append(text);
    }

    public int getLineCount() {
        return this.textArea.getLineCount();
    }

    public int getTabSize() {
        return this.textArea.getTabSize();
    }

    public int getTextAreaHeight() {
        return this.textArea.getAreaHeight();
    }

    public int getTextVisibleHeight() {
        return this.textArea.getVisibleHeight();
    }

    public void insert(String text, int position) {
        this.textArea.insert(text, position);
    }

    public void replaceRange(String text, int start, int end) {
        this.textArea.replaceRange(text, start, end);
    }

    public void setCaretPosition(int position) {
        this.textArea.setCaretPosition(position);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getViewport().getPreferredSize();
    }

    public void scrollToBottom() {
        this.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void scrollToTop() {
        this.setCaretPosition(0);
    }

    public void setTabSize(int tabSize) {
        this.textArea.setTabSize(tabSize);
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.textArea.invalidate();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    private void initialize() {
        this.textArea.setLineWrap(true);
        this.setAutoscrolls(true);
        this.setViewportView(this.textArea);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuCopy = new JMenuItem("Copy");
        menuCopy.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        menuCopy.addActionListener(new CopyActionListener());
        menuCopy.setAccelerator(KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        popup.add(menuCopy);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private class PrivateTextArea
    extends JTextArea {
        private PrivateTextArea() {
        }

        private PrivateTextArea(String text) {
            super(text);
        }

        private PrivateTextArea(int rows, int columns) {
            super(rows, columns);
        }

        private PrivateTextArea(String text, int rows, int columns) {
            super(text, rows, columns);
        }

        private PrivateTextArea(Document doc) {
            super(doc);
        }

        private PrivateTextArea(Document doc, String text, int rows, int columns) {
            super(doc, text, rows, columns);
        }

        private int getAreaHeight() {
            return super.getRowHeight() * super.getLineCount();
        }

        private int getSingleRowHeight() {
            return super.getRowHeight();
        }

        private int getVisibleHeight() {
            return super.getRowHeight() * super.getRows();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension size = this.getPreferredSize();
            size.width += this.getScrollBarWidth();
            Rectangle screenBounds = WindowUtilities.getScreenBounds((Component)this);
            if (screenBounds == null) {
                return size;
            }
            size.width = Math.min(size.width, screenBounds.width);
            size.height = Math.min(size.height, screenBounds.height);
            return size;
        }

        private int getScrollBarWidth() {
            JScrollBar bar = ScrollableTextArea.this.getVerticalScrollBar();
            if (bar == null) {
                return 0;
            }
            return bar.getPreferredSize().width * 2;
        }
    }

    private class CopyActionListener
    implements ActionListener {
        private CopyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard systemClipboard = GClipboard.getSystemClipboard();
            String text = ScrollableTextArea.this.textArea.getText();
            StringTransferable transferable = new StringTransferable(text);
            systemClipboard.setContents(transferable, null);
        }
    }
}

