/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingMenuItem;
import docking.DockingWindowManager;
import docking.KeyBindingPrecedence;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuBarData;
import docking.action.MenuData;
import docking.action.PopupMenuData;
import docking.action.ToolBarData;
import docking.widgets.EmptyBorderButton;
import generic.theme.GIcon;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import resources.ResourceManager;
import utilities.util.reflection.ReflectionUtilities;

public abstract class DockingAction
implements DockingActionIf {
    private WeakSet<PropertyChangeListener> propertyListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private final String name;
    private final String owner;
    private String description = "";
    private String inceptionInformation;
    private boolean isEnabled = true;
    private KeyBindingType keyBindingType = KeyBindingType.INDIVIDUAL;
    private KeyBindingData defaultKeyBindingData;
    private KeyBindingData keyBindingData;
    private MenuBarData menuBarData;
    private PopupMenuData popupMenuData;
    private ToolBarData toolBarData;
    private Predicate<ActionContext> enabledPredicate;
    private Predicate<ActionContext> popupPredicate;
    private Predicate<ActionContext> validContextPredicate;
    private boolean shouldAddToAllWindows = false;
    private Class<? extends ActionContext> addToWindowWhenContextClass = null;
    private Class<? extends ActionContext> contextClass = ActionContext.class;
    private boolean supportsDefaultContext = false;

    public DockingAction(String name, String owner) {
        this.name = name;
        this.owner = owner;
        this.recordInception();
        HelpLocation location = new HelpLocation(owner, name, this.inceptionInformation);
        this.setHelpLocation(location);
    }

    public DockingAction(String name, String owner, KeyBindingType kbType) {
        this(name, owner);
        this.keyBindingType = Objects.requireNonNull(kbType);
    }

    public DockingAction(String name, String owner, boolean supportsKeyBindings) {
        this(name, owner);
        this.keyBindingType = supportsKeyBindings ? KeyBindingType.INDIVIDUAL : KeyBindingType.UNSUPPORTED;
    }

    protected KeyBindingType getPreferredKeyBindingType() {
        return KeyBindingType.INDIVIDUAL;
    }

    @Override
    public abstract void actionPerformed(ActionContext var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFullName() {
        return this.getName() + " (" + this.getOwner() + ")";
    }

    @Override
    public MenuData getMenuBarData() {
        return this.menuBarData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public MenuData getPopupMenuData() {
        return this.popupMenuData;
    }

    @Override
    public ToolBarData getToolBarData() {
        return this.toolBarData;
    }

    @Override
    public String getInceptionInformation() {
        return this.inceptionInformation;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        if (this.popupPredicate != null) {
            return this.popupPredicate.test(context);
        }
        return this.isEnabledForContext(context);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        if (this.enabledPredicate != null) {
            return this.enabledPredicate.test(context);
        }
        return this.isEnabled();
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        if (this.validContextPredicate != null) {
            return this.validContextPredicate.test(context);
        }
        return true;
    }

    @Override
    public final boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
        if (this.menuBarData == null && this.toolBarData == null) {
            return false;
        }
        if (this.shouldAddToAllWindows) {
            return true;
        }
        if (this.addToWindowWhenContextClass != null) {
            for (Class<?> class1 : contextTypes) {
                if (!this.addToWindowWhenContextClass.isAssignableFrom(class1)) continue;
                return true;
            }
            return false;
        }
        return isMainWindow;
    }

    public void setHelpLocation(HelpLocation location) {
        DockingWindowManager.getHelpService().registerHelp((Object)this, location);
    }

    public HelpLocation getHelpLocation() {
        return DockingWindowManager.getHelpService().getHelpLocation((Object)this);
    }

    public void markHelpUnnecessary() {
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (this.isEnabled == newValue) {
            return;
        }
        this.isEnabled = newValue;
        this.firePropertyChanged("enabled", !this.isEnabled, this.isEnabled);
    }

    @Override
    public final JButton createButton() {
        Icon icon;
        JButton button = this.doCreateButton();
        button.setName(this.getName());
        button.setFocusable(false);
        Icon icon2 = icon = this.toolBarData == null ? null : this.toolBarData.getIcon();
        if (icon == null) {
            icon = ResourceManager.getDefaultIcon();
        }
        button.setIcon(icon);
        String tt = this.getDescription();
        if (tt == null || tt.length() == 0) {
            tt = this.getName();
        }
        button.setToolTipText(tt);
        button.setEnabled(this.isEnabled());
        return button;
    }

    @Override
    public JMenuItem createMenuItem(boolean isPopup) {
        KeyStroke ks;
        MenuData menuData;
        JMenuItem menuItem = this.doCreateMenuItem();
        MenuData menuData2 = menuData = isPopup ? this.popupMenuData : this.menuBarData;
        if (menuData == null) {
            throw new AssertException("No menu data for menu type: " + (isPopup ? "Popup" : "Menubar"));
        }
        String text = menuData.getMenuItemName();
        String trimmed = StringUtilities.trimMiddle((String)text, (int)50);
        menuItem.setText(trimmed);
        menuItem.setIcon(menuData.getMenuIcon());
        menuItem.setMnemonic(menuData.getMnemonic());
        KeyStroke keyStroke = ks = this.keyBindingData == null ? null : this.keyBindingData.getKeyBinding();
        if (ks != null) {
            menuItem.setAccelerator(ks);
        }
        menuItem.setEnabled(this.isEnabled);
        return menuItem;
    }

    @Override
    public KeyBindingType getKeyBindingType() {
        return this.keyBindingType;
    }

    @Override
    public KeyStroke getKeyBinding() {
        return this.keyBindingData == null ? null : this.keyBindingData.getKeyBinding();
    }

    @Override
    public KeyBindingData getKeyBindingData() {
        return this.keyBindingData;
    }

    @Override
    public KeyBindingData getDefaultKeyBindingData() {
        return this.defaultKeyBindingData;
    }

    @Override
    public void setKeyBindingData(KeyBindingData newKeyBindingData) {
        if (!this.supportsKeyBinding(newKeyBindingData)) {
            return;
        }
        KeyBindingData oldData = this.keyBindingData;
        this.keyBindingData = KeyBindingData.validateKeyBindingData(newKeyBindingData);
        if (this.defaultKeyBindingData == null) {
            this.defaultKeyBindingData = this.keyBindingData;
        }
        this.firePropertyChanged("KeyBindings", oldData, this.keyBindingData);
    }

    private boolean supportsKeyBinding(KeyBindingData kbData) {
        KeyBindingType type = this.getKeyBindingType();
        if (type.supportsKeyBindings()) {
            return true;
        }
        KeyBindingPrecedence precedence = null;
        if (kbData != null) {
            precedence = kbData.getKeyBindingPrecedence();
        }
        if (precedence == KeyBindingPrecedence.ReservedActionsLevel) {
            return true;
        }
        Msg.error((Object)this, (Object)("Action does not support key bindings: " + this.getFullName()), (Throwable)new Throwable());
        return false;
    }

    @Override
    public void setUnvalidatedKeyBindingData(KeyBindingData newKeyBindingData) {
        KeyBindingData oldData = this.keyBindingData;
        this.keyBindingData = newKeyBindingData;
        this.firePropertyChanged("KeyBindings", oldData, this.keyBindingData);
    }

    @Override
    public Class<? extends ActionContext> getContextClass() {
        return this.contextClass;
    }

    @Override
    public boolean supportsDefaultContext() {
        return this.supportsDefaultContext;
    }

    @Override
    public void setContextClass(Class<? extends ActionContext> type, boolean supportsDefaultContext) {
        this.contextClass = type;
        this.supportsDefaultContext = supportsDefaultContext;
        this.validContextPredicate = ac -> this.contextClass.isInstance(ac);
    }

    public void setMenuBarData(MenuData newMenuData) {
        MenuBarData newDataCopy;
        MenuBarData oldData = this.menuBarData;
        this.menuBarData = newDataCopy = newMenuData == null ? null : new MenuBarData(this, newMenuData);
        this.firePropertyChanged("MenuBar", oldData, newDataCopy);
    }

    public void setPopupMenuData(MenuData newMenuData) {
        PopupMenuData newDataCopy;
        PopupMenuData oldData = this.popupMenuData;
        this.popupMenuData = newDataCopy = newMenuData == null ? null : new PopupMenuData(this, newMenuData);
        this.firePropertyChanged("PopupMenu", oldData, newDataCopy);
    }

    public void setToolBarData(ToolBarData newToolBarData) {
        ToolBarData newToolBarDataCopy;
        ToolBarData oldData = this.toolBarData;
        this.toolBarData = newToolBarDataCopy = newToolBarData == null ? null : new ToolBarData(this, newToolBarData.getIcon(), newToolBarData.getToolBarGroup(), newToolBarData.getToolBarSubGroup());
        this.firePropertyChanged("ToolBar", oldData, newToolBarDataCopy);
    }

    void createReservedKeyBinding(KeyStroke keyStroke) {
        KeyBindingData data = KeyBindingData.createReservedKeyBindingData(keyStroke);
        this.setKeyBindingData(data);
    }

    public void setDescription(String newDescription) {
        if (SystemUtilities.isEqual((Object)newDescription, (Object)this.description)) {
            return;
        }
        String oldDescription = this.description;
        this.description = newDescription;
        this.firePropertyChanged("description", oldDescription, newDescription);
    }

    @Override
    public void dispose() {
        this.propertyListeners.clear();
    }

    public String toString() {
        return this.getName() + "  (" + this.getOwner() + ")";
    }

    public String getHelpInfo() {
        String inception;
        KeyStroke keyStroke;
        String parentGroup;
        StringBuilder buffer = new StringBuilder();
        buffer.append("   ACTION:    ").append(this.getOwner()).append(" - ").append(this.getName());
        buffer.append('\n');
        if (this.menuBarData != null) {
            String iconId;
            String iconName;
            buffer.append("        MENU PATH:           ").append(this.menuBarData.getMenuPathAsString());
            buffer.append('\n');
            buffer.append("        MENU GROUP:        ").append(this.menuBarData.getMenuGroup());
            buffer.append('\n');
            parentGroup = this.menuBarData.getParentMenuGroup();
            if (parentGroup != null) {
                buffer.append("        PARENT GROUP:         ").append(parentGroup);
                buffer.append('\n');
            }
            if ((iconName = this.getIconName(this.menuBarData.getMenuIcon())) != null) {
                buffer.append("        MENU ICON:     ").append(iconName);
                buffer.append('\n');
            }
            if ((iconId = this.getIconId(this.menuBarData.getMenuIcon())) != null) {
                buffer.append("        MENU ICON ID:     ").append(iconId);
                buffer.append('\n');
            }
        }
        if (this.popupMenuData != null) {
            String iconId;
            String iconName;
            String menuSubGroup;
            buffer.append("        POPUP PATH:         ").append(this.popupMenuData.getMenuPathAsString());
            buffer.append('\n');
            buffer.append("        POPUP GROUP:      ").append(this.popupMenuData.getMenuGroup());
            buffer.append('\n');
            parentGroup = this.popupMenuData.getParentMenuGroup();
            if (parentGroup != null) {
                buffer.append("        PARENT GROUP:         ").append(parentGroup);
                buffer.append('\n');
            }
            if ((menuSubGroup = this.popupMenuData.getMenuSubGroup()) != MenuData.NO_SUBGROUP) {
                buffer.append("        POPUP SUB-GROUP:         ").append(menuSubGroup);
                buffer.append('\n');
            }
            if ((iconName = this.getIconName(this.popupMenuData.getMenuIcon())) != null) {
                buffer.append("        POPUP ICON:     ").append(iconName);
                buffer.append('\n');
            }
            if ((iconId = this.getIconId(this.popupMenuData.getMenuIcon())) != null) {
                buffer.append("        POPUP ICON ID:     ").append(iconId);
                buffer.append('\n');
            }
        }
        if (this.toolBarData != null) {
            String iconId;
            buffer.append("        TOOLBAR GROUP:  ").append(this.toolBarData.getToolBarGroup());
            buffer.append('\n');
            String iconName = this.getIconName(this.toolBarData.getIcon());
            if (iconName != null) {
                buffer.append("        TOOLBAR ICON:     ").append(iconName);
                buffer.append('\n');
            }
            if ((iconId = this.getIconId(this.toolBarData.getIcon())) != null) {
                buffer.append("        TOOLBAR ICON ID:     ").append(iconId);
                buffer.append('\n');
            }
        }
        if ((keyStroke = this.getKeyBinding()) != null) {
            buffer.append("        KEYBINDING:          ").append(keyStroke.toString());
            buffer.append('\n');
        }
        if ((inception = this.getInceptionInformation()) != null) {
            buffer.append("\n    \n");
            buffer.append("   CREATED AT: ").append(inception);
            buffer.append("\n    ");
        } else {
            Msg.debug((Object)this, (Object)"No inception info");
        }
        return buffer.toString();
    }

    private String getIconId(Icon icon) {
        if (icon instanceof GIcon) {
            GIcon gIcon = (GIcon)icon;
            return gIcon.getId();
        }
        return null;
    }

    private String getIconName(Icon icon) {
        if (icon == null) {
            return null;
        }
        String iconName = ResourceManager.getIconName((Icon)icon);
        if (iconName == null) {
            return null;
        }
        int index = iconName.lastIndexOf(47);
        if (index != -1) {
            return iconName.substring(index + 1);
        }
        return iconName;
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(event);
        }
    }

    public Object getHelpObject() {
        return this;
    }

    public void enabledWhen(Predicate<ActionContext> predicate) {
        this.enabledPredicate = predicate;
    }

    public void popupWhen(Predicate<ActionContext> predicate) {
        this.popupPredicate = predicate;
    }

    public void validContextWhen(Predicate<ActionContext> predicate) {
        this.validContextPredicate = predicate;
    }

    public void addToWindowWhen(Class<? extends ActionContext> addToWindowContextClass) {
        this.addToWindowWhenContextClass = addToWindowContextClass;
    }

    public void setAddToAllWindows(boolean b) {
        this.shouldAddToAllWindows = b;
    }

    protected JButton doCreateButton() {
        return new EmptyBorderButton();
    }

    protected JMenuItem doCreateMenuItem() {
        return new DockingMenuItem();
    }

    private void recordInception() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            this.inceptionInformation = "";
            return;
        }
        this.inceptionInformation = this.getInceptionFromTheFirstClassThatIsNotUsOrABuilder();
    }

    protected String getInceptionFromTheFirstClassThatIsNotUsOrABuilder() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{this.getClass()});
        StackTraceElement[] trace = ReflectionUtilities.filterStackTrace((StackTraceElement[])t.getStackTrace(), (String[])new String[]{"ActionBuilder"});
        String classInfo = trace[0].toString();
        return classInfo;
    }
}

