/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.VisualEdgeRenderer;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;

public class ArticulatedEdgeRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualEdgeRenderer<V, E> {
    @Override
    public Shape getEdgeShape(RenderContext<V, E> rc, Graph<V, E> graph, E e, float x1, float y1, float x2, float y2, boolean isLoop, Shape vertexShape) {
        if (isLoop) {
            return GraphViewerUtils.createEgdeLoopInGraphSpace(vertexShape, x1, y1);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        List<Point2D> articulations = e.getArticulationPoints();
        for (Point2D point : articulations) {
            double x = point.getX();
            double y = point.getY();
            Point2D.Double offsetPoint = new Point2D.Double(x, y);
            point = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)offsetPoint);
            x = point.getX();
            y = point.getY();
            path.lineTo(x, y);
        }
        path.lineTo(x2, y2);
        path.moveTo(x2, y2);
        path.closePath();
        return path;
    }
}

