/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphAbstractGraphMousePlugin;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public abstract class VisualGraphSatelliteAbstractGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualGraphAbstractGraphMousePlugin<V, E> {
    public VisualGraphSatelliteAbstractGraphMousePlugin() {
        this(1024);
    }

    public VisualGraphSatelliteAbstractGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
    }

    @Override
    protected boolean shouldShowCursor(MouseEvent e) {
        return false;
    }

    protected void moveMasterViewerToMousePoint(MouseEvent e) {
        VisualizationViewer satelliteViewer = (VisualizationViewer)e.getSource();
        Point pointInLayoutSpace = this.translateSatelliteViewPointToLayoutPoint(satelliteViewer, e.getPoint());
        VisualGraphViewUpdater updater = this.getViewUpdater(e);
        updater.centerLayoutSpacePointWithoutAnimation(pointInLayoutSpace);
    }

    protected boolean isInSatelliteLensArea(MouseEvent e) {
        SatelliteGraphViewer satelliteViewer = this.getSatelliteGraphViewer(e);
        VisualizationViewer viewMaster = ((SatelliteVisualizationViewer)satelliteViewer).getMaster();
        Shape lensInSatelliteViewSpace = this.getSatelliteLensInSatelliteViewSpace((VisualizationViewer<V, E>)satelliteViewer, (VisualizationViewer<V, E>)viewMaster);
        return lensInSatelliteViewSpace.contains(e.getPoint());
    }

    protected Shape getSatelliteLensInSatelliteViewSpace(VisualizationViewer<V, E> satelliteViewer, VisualizationViewer<V, E> viewMaster) {
        RenderContext renderContext = viewMaster.getRenderContext();
        MultiLayerTransformer masterMultiLayerTransformer = renderContext.getMultiLayerTransformer();
        Rectangle lens = viewMaster.getBounds();
        Shape lensInLayoutSpace = masterMultiLayerTransformer.inverseTransform((Shape)lens);
        MultiLayerTransformer satelliteMultiLayerTransformer = satelliteViewer.getRenderContext().getMultiLayerTransformer();
        Shape lenInSatelliteViewSpace = satelliteMultiLayerTransformer.transform(lensInLayoutSpace);
        return lenInSatelliteViewSpace;
    }

    protected Point translateSatelliteViewPointToLayoutPoint(VisualizationViewer<V, E> viewer, Point2D point) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        Point2D layoutPoint2D = multiLayerTransformer.inverseTransform(point);
        int x = (int)layoutPoint2D.getX();
        int y = (int)layoutPoint2D.getY();
        return new Point(x, y);
    }
}

