/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfLibraryRecord;
import ghidra.file.formats.omf.OmfArchiveFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

@FileSystemInfo(type="omf", description="OMF Archive", factory=OmfArchiveFileSystemFactory.class)
public class OmfArchiveFileSystem
extends AbstractFileSystem<OmfLibraryRecord.MemberHeader> {
    private ByteProvider provider;

    public OmfArchiveFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        super(fsFSRL, FileSystemService.getInstance());
        this.provider = provider;
    }

    public void mount(TaskMonitor monitor) throws IOException {
        monitor.setMessage("Opening OMF archive...");
        BinaryReader reader = OmfFileHeader.createReader((ByteProvider)this.provider);
        OmfLibraryRecord libraryRec = OmfLibraryRecord.parse((BinaryReader)reader, (TaskMonitor)monitor);
        ArrayList memberHeaders = libraryRec.getMemberHeaders();
        for (OmfLibraryRecord.MemberHeader member : memberHeaders) {
            String name = member.name;
            monitor.setMessage(name);
            this.fsIndex.storeFile(name, (long)this.fsIndex.getFileCount(), false, member.size, (Object)member);
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsIndex.clear();
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) {
        OmfLibraryRecord.MemberHeader member = (OmfLibraryRecord.MemberHeader)this.fsIndex.getMetadata(file);
        return member != null ? new ByteProviderWrapper(this.provider, member.payloadOffset, member.size, file.getFSRL()) : null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        OmfLibraryRecord.MemberHeader entry = (OmfLibraryRecord.MemberHeader)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.name);
            result.add(FileAttributeType.SIZE_ATTR, (Object)entry.size);
        }
        return result;
    }
}

