/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.file.formats.cart.CartInvalidCartException;
import ghidra.file.formats.cart.CartV1Constants;
import ghidra.file.formats.cart.CartV1StreamProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CartV1StreamDecompressor
extends CartV1StreamProcessor {
    private Inflater inflater = new Inflater(false);

    public CartV1StreamDecompressor(InputStream delegate) throws CartInvalidCartException {
        this(new PushbackInputStream(delegate, 2));
    }

    public CartV1StreamDecompressor(PushbackInputStream delegate) throws CartInvalidCartException {
        super(delegate);
        boolean validHeaderBytes = false;
        byte[] headerBytes = new byte[2];
        try {
            delegate.read(headerBytes, 0, 2);
            for (byte[] zlibBytes : CartV1Constants.ZLIB_HEADER_BYTES) {
                if (!Arrays.equals(headerBytes, zlibBytes)) continue;
                validHeaderBytes = true;
                break;
            }
            delegate.unread(headerBytes);
            if (!validHeaderBytes) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            throw new CartInvalidCartException("CaRT compression format error");
        }
    }

    @Override
    protected boolean readNextChunk() throws IOException {
        byte[] compressedBytes = new byte[65536];
        byte[] decompressedBytes = null;
        this.currentChunk = null;
        this.chunkPos = 0;
        if (this.inflater == null || this.inflater.finished()) {
            return false;
        }
        if (this.inflater.needsInput()) {
            int bytesRead = this.delegate.read(compressedBytes);
            if (bytesRead <= 0) {
                return false;
            }
            this.inflater.setInput(compressedBytes, 0, bytesRead);
        }
        try {
            decompressedBytes = new byte[65536];
            int bytesDecompressed = this.inflater.inflate(decompressedBytes);
            if (bytesDecompressed <= 0) {
                return false;
            }
            this.currentChunk = Arrays.copyOf(decompressedBytes, bytesDecompressed);
        }
        catch (DataFormatException e) {
            throw new IOException("CaRT decompression failed: " + e.getMessage());
        }
        return this.currentChunk != null && this.currentChunk.length > 0;
    }
}

