/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import generic.theme.GIcon;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import generic.theme.ThemeManager;
import ghidra.formats.gfilesystem.FSUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import resources.MultiIcon;

public class FileIconService {
    public static final Icon IMPORTED_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.imported");
    public static final Icon FILESYSTEM_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.filesystem");
    public static final Icon MISSING_PASSWORD_OVERLAY_ICON = new GIcon("icon.fsbrowser.file.overlay.missing.password");
    public static final Icon DEFAULT_ICON = new GIcon("icon.fsbrowser.file.extension.default");
    private static final String EXTENSION_ICON_PREFIX = "icon.fsbrowser.file.extension";
    private static final String SUBSTRING_ICON_PREFIX = "icon.fsbrowser.file.substring";
    private Map<String, Icon> substringToIconMap = new HashMap<String, Icon>();

    public static FileIconService getInstance() {
        return Singleton.INSTANCE;
    }

    private FileIconService() {
        this.createSubstringMap();
    }

    private void createSubstringMap() {
        GThemeValueMap values = ThemeManager.getInstance().getCurrentValues();
        List icons = values.getIcons();
        for (IconValue iconValue : icons) {
            String id = iconValue.getId();
            if (!id.startsWith(SUBSTRING_ICON_PREFIX)) continue;
            String substring = id.substring(SUBSTRING_ICON_PREFIX.length());
            this.substringToIconMap.put(substring, (Icon)new GIcon(id));
        }
    }

    public Icon getIcon(String fileName, List<Icon> overlays) {
        String iconId;
        String ext = FSUtilities.getExtension(fileName = fileName.toLowerCase(), 1);
        if (ext != null && Gui.hasIcon((String)(iconId = EXTENSION_ICON_PREFIX + ext))) {
            GIcon base = new GIcon(iconId);
            return this.buildIcon((Icon)base, overlays);
        }
        for (String substring : this.substringToIconMap.keySet()) {
            if (fileName.indexOf(substring) == -1) continue;
            return this.buildIcon(this.substringToIconMap.get(substring), overlays);
        }
        return this.buildIcon(DEFAULT_ICON, overlays);
    }

    private Icon buildIcon(Icon base, List<Icon> overlays) {
        if (overlays == null || overlays.isEmpty()) {
            return base;
        }
        MultiIcon multiIcon = new MultiIcon(base);
        for (Icon overlay : overlays) {
            if (overlay == null) continue;
            multiIcon.addIcon(overlay);
        }
        return multiIcon;
    }

    private static final class Singleton {
        private static final FileIconService INSTANCE = new FileIconService();

        private Singleton() {
        }
    }
}

