/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utilities.util.FileUtilities;

public abstract class AbstractFileExtractorTask
extends Task {
    protected GFileSystem fs;
    protected File rootOutputDirectory;
    private int totalFilesExportedCount;
    private int totalDirsExportedCount;
    private long totalBytesExportedCount;

    public AbstractFileExtractorTask(String title, boolean canCancel, boolean hasProgress, boolean isModal, File rootOutputDir) {
        super(title, canCancel, hasProgress, isModal);
        this.rootOutputDirectory = rootOutputDir;
    }

    protected void startExtract(GFileSystem fs, GFile srcDir, TaskMonitor monitor) throws CancelledException, IOException {
        this.fs = fs;
        if (srcDir == null) {
            srcDir = fs.lookup(null);
        }
        this.processDirectory(srcDir, this.rootOutputDirectory, monitor);
    }

    protected void processDirectory(GFile srcGFileDirectory, File destDirectory, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.isSpecialDirectory(srcGFileDirectory)) {
            return;
        }
        if (!FileUtilities.isPathContainedWithin((File)this.rootOutputDirectory, (File)destDirectory)) {
            String srcPath = srcGFileDirectory != null ? srcGFileDirectory.getPath() : "/";
            throw new IOException("Extracted directory " + srcPath + " [" + destDirectory + "] would be outside of root destination directory: " + this.rootOutputDirectory);
        }
        if (!destDirectory.isDirectory() && !destDirectory.mkdirs()) {
            throw new IOException("Failed to create destination directory " + destDirectory);
        }
        ++this.totalDirsExportedCount;
        for (GFile srcFile : this.fs.getListing(srcGFileDirectory)) {
            monitor.checkCancelled();
            String destFname = this.mapSourceFilenameToDest(srcFile);
            File destFSFile = new File(destDirectory, destFname);
            if (srcFile.isDirectory()) {
                this.processDirectory(srcFile, destFSFile, monitor);
                continue;
            }
            this.processFile(srcFile, destFSFile, monitor);
        }
    }

    protected void processFile(GFile srcFile, File destFSFile, TaskMonitor monitor) throws IOException, CancelledException {
        block4: {
            try {
                if (!FileUtilities.isPathContainedWithin((File)this.rootOutputDirectory, (File)destFSFile)) {
                    throw new IOException("Extracted file " + srcFile.getPath() + " [" + destFSFile + "] would be outside of root destination directory: " + this.rootOutputDirectory);
                }
                this.extractFile(srcFile, destFSFile.getCanonicalFile(), monitor);
            }
            catch (CancelledException | IOCancelledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.handleUnexpectedException(srcFile, e)) break block4;
                throw e;
            }
        }
    }

    protected String mapSourceFilenameToDest(GFile srcFile) throws IOException {
        return FSUtilities.getSafeFilename(srcFile.getName());
    }

    protected boolean handleUnexpectedException(GFile file, Exception e) {
        return false;
    }

    private boolean isSpecialDirectory(GFile directory) {
        if (directory == null) {
            return false;
        }
        switch (directory.getName()) {
            case "\u0000\u0000\u0000\u0000HFS+ Private Data": 
            case ".HFS+ Private Directory Data\r": {
                return true;
            }
        }
        return false;
    }

    protected void extractFile(GFile srcFile, File outputFile, TaskMonitor monitor) throws CancelledException {
        block14: {
            monitor.setMessage(srcFile.getName());
            try (InputStream in = this.getSourceFileInputStream(srcFile, monitor);){
                if (in == null) break block14;
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    long bytesCopied = FileUtilities.copyStreamToStream((InputStream)in, (OutputStream)out, (TaskMonitor)monitor);
                    if (srcFile.getLength() != -1L && bytesCopied != srcFile.getLength()) {
                        throw new IOException("Failed to copy the correct number of bytes from " + srcFile.getFSRL() + " to " + outputFile + ".  Expected " + srcFile.getLength() + ", bytes copied " + bytesCopied);
                    }
                    this.totalBytesExportedCount += bytesCopied;
                    ++this.totalFilesExportedCount;
                }
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Error when copying file " + srcFile.getFSRL() + " to " + outputFile), (Throwable)e);
            }
        }
    }

    protected InputStream getSourceFileInputStream(GFile file, TaskMonitor monitor) throws CancelledException, IOException {
        return this.fs.getInputStream(file, monitor);
    }

    public int getTotalFilesExportedCount() {
        return this.totalFilesExportedCount;
    }

    public int getTotalDirsExportedCount() {
        return this.totalDirsExportedCount;
    }

    public long getTotalBytesExportedCount() {
        return this.totalBytesExportedCount;
    }
}

