/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.widgets.values.AbstractValue;
import docking.widgets.values.ValuesMapParseException;
import ghidra.features.base.values.AbstractProjectBrowserPanel;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import javax.swing.JComponent;

public class ProjectFileValue
extends AbstractValue<DomainFile> {
    private ProjectFileBrowserPanel domainFilePanel;
    private String startingPath;
    private Project project;
    private Class<? extends DomainObject> projectFileClass;

    public ProjectFileValue(String name) {
        this(name, AppInfo.getActiveProject(), null, DomainObject.class);
    }

    public ProjectFileValue(String name, Class<? extends DomainObject> projectFileClass) {
        this(name, AppInfo.getActiveProject(), null, projectFileClass);
    }

    public ProjectFileValue(String name, String startingPath) {
        this(name, AppInfo.getActiveProject(), startingPath, DomainObject.class);
    }

    public ProjectFileValue(String name, Project project, String startingPath, Class<? extends DomainObject> projectFileClass) {
        super(name, null);
        this.project = project;
        this.startingPath = startingPath;
        this.projectFileClass = projectFileClass;
    }

    public JComponent getComponent() {
        if (this.domainFilePanel == null) {
            this.domainFilePanel = new ProjectFileBrowserPanel(this.project, this.getName(), this.startingPath, this.projectFileClass);
        }
        return this.domainFilePanel;
    }

    protected void updateValueFromComponent() throws ValuesMapParseException {
        if (this.domainFilePanel != null) {
            DomainFile domainFile = this.domainFilePanel.getDomainFile();
            if (domainFile == null) {
                String text = this.domainFilePanel.getText();
                if (text.isBlank()) {
                    this.setValue(null);
                    return;
                }
                throw new ValuesMapParseException(this.getName(), "Project File", "No file found for \"" + text + "\"");
            }
            Class domainObjectClass = domainFile.getDomainObjectClass();
            if (!this.projectFileClass.isAssignableFrom(domainObjectClass)) {
                throw new ValuesMapParseException(this.getName(), "Project File", "Selected path is not a " + this.projectFileClass.getSimpleName());
            }
            this.setValue(domainFile);
        }
    }

    protected void updateComponentFromValue() {
        if (this.domainFilePanel != null) {
            this.domainFilePanel.setDomainFile((DomainFile)this.getValue());
        }
    }

    protected DomainFile fromString(String valueString) {
        DomainFile df = this.parseDomainFile(valueString);
        if (df == null) {
            throw new IllegalArgumentException("Can't find domain file: " + valueString);
        }
        Class domainObjectClass = df.getDomainObjectClass();
        if (!this.projectFileClass.isAssignableFrom(domainObjectClass)) {
            throw new IllegalArgumentException("Specified file path is not a " + this.projectFileClass.getSimpleName());
        }
        return df;
    }

    private DomainFile parseDomainFile(String val) {
        Project activeProject;
        if (!((String)val).isEmpty() && ((String)val).charAt(0) != '/') {
            val = "/" + (String)val;
        }
        if ((activeProject = AppInfo.getActiveProject()) == null) {
            throw new IllegalStateException("No Active Project!");
        }
        DomainFile df = activeProject.getProjectData().getFile((String)val);
        if (df != null) {
            return df;
        }
        return null;
    }

    protected String toString(DomainFile v) {
        return v.getPathname();
    }

    class ProjectFileBrowserPanel
    extends AbstractProjectBrowserPanel {
        ProjectFileBrowserPanel(Project project, String name, String startPath, Class<? extends DomainObject> projectFileClass) {
            super(0, project, name, startPath);
            this.filter = df -> projectFileClass.isAssignableFrom(df.getDomainObjectClass());
        }

        void setDomainFile(DomainFile value) {
            String text = value == null ? "" : value.getPathname();
            this.textField.setText(text);
        }

        @Override
        protected void intializeCurrentValue(DataTreeDialog dialog) {
            DomainFile current = this.getDomainFile();
            if (current != null) {
                dialog.selectDomainFile(current);
                dialog.setNameText(current.getName());
            }
        }

        @Override
        protected String getSelectedPath(DataTreeDialog dialog) {
            return dialog.getDomainFile().getPathname();
        }

        DomainFile getDomainFile() {
            String text = this.textField.getText().trim();
            if (text.isBlank()) {
                return null;
            }
            return ProjectFileBrowserPanel.parseDomainFile(this.project, text);
        }
    }
}

