/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.FunctionPurgeAnalysisCmd;
import ghidra.app.cmd.function.FunctionRenameOption;
import ghidra.app.cmd.function.FunctionStackAnalysisCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.cparser.C.CParserUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.xml.DtParser;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

class FunctionsXmlMgr {
    public static final String LIB_BOOKMARK_CATEGORY = "Library Identification";
    public static final String FID_BOOKMARK_CATEGORY = "Function ID Analyzer";
    private static final Set<String> LIBRARY_BOOKMARK_CATEGORY_STRINGS = new HashSet<String>();
    private Program program;
    private Listing listing;
    private DtParser dtParser;
    private AddressFactory factory;
    private MessageLog log;

    FunctionsXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.listing = program.getListing();
        this.factory = program.getAddressFactory();
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(XmlPullParser parser, boolean overwriteConflicts, boolean ignoreStackFrames, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        XmlElement element = parser.start(new String[]{"FUNCTIONS"});
        AddressSet functions = new AddressSet();
        DataTypeManager dataManager = this.listing.getDataTypeManager();
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        try {
            this.dtParser = new DtParser(dataManager);
            while (parser.peek().isStart()) {
                monitor.checkCancelled();
                XmlElement functionElement = parser.start(new String[]{"FUNCTION"});
                String entryPointStr = functionElement.getAttribute("ENTRY_POINT");
                if (entryPointStr == null) {
                    throw new RuntimeException("No entry point provided.");
                }
                Address entryPoint = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)entryPointStr);
                if (entryPoint == null) {
                    throw new AddressFormatException("Incompatible Function Entry Point Address: " + entryPointStr);
                }
                try {
                    boolean isLibFunc;
                    SymbolPath namespacePath = null;
                    String name = functionElement.getAttribute("NAME");
                    if (name != null) {
                        SymbolPath symbolPath = new SymbolPath(name);
                        name = symbolPath.getName();
                        namespacePath = symbolPath.getParent();
                    }
                    AddressSet body = new AddressSet(entryPoint, entryPoint);
                    if (functionElement.hasAttribute("LIBRARY_FUNCTION") && (isLibFunc = XmlUtilities.parseBoolean((String)functionElement.getAttribute("LIBRARY_FUNCTION")))) {
                        BookmarkManager bm = this.program.getBookmarkManager();
                        BookmarkType bt = bm.getBookmarkType("IMPORTED");
                        if (bt == null) {
                            GIcon icon = new GIcon("icon.base.util.xml.functions.bookmark");
                            bt = bm.defineType("IMPORTED", (Icon)icon, (Color)GThemeDefaults.Colors.Palette.DARK_GRAY, 0);
                        }
                        bm.setBookmark(entryPoint, "IMPORTED", LIB_BOOKMARK_CATEGORY, "Library function");
                    }
                    DataType returnType = this.readReturnType(parser, name);
                    this.readAddressRange(parser, body);
                    CreateFunctionCmd cmd = new CreateFunctionCmd(null, entryPoint, (AddressSetView)body, SourceType.USER_DEFINED);
                    if (!cmd.applyTo((DomainObject)this.program)) {
                        Msg.error((Object)this, (Object)("Failed to create function at " + entryPoint + ": " + cmd.getStatusMsg()));
                        parser.discardSubTree(functionElement);
                        continue;
                    }
                    Function func = cmd.getFunction();
                    if (name != null && !SymbolUtilities.isReservedDynamicLabelName((String)name, (AddressFactory)this.program.getAddressFactory())) {
                        try {
                            Symbol symbol = func.getSymbol();
                            Namespace namespace = NamespaceUtils.getFunctionNamespaceAt((Program)this.program, (SymbolPath)namespacePath, (Address)entryPoint);
                            if (namespace == null) {
                                namespace = this.program.getGlobalNamespace();
                            }
                            symbol.setNameAndNamespace(name, namespace, SourceType.USER_DEFINED);
                        }
                        catch (DuplicateNameException symbol) {
                            // empty catch block
                        }
                    }
                    String regularComment = this.getElementText(parser, "REGULAR_CMT");
                    func.setComment(regularComment);
                    String repeatableComment = this.getElementText(parser, "REPEATABLE_CMT");
                    func.setRepeatableComment(repeatableComment);
                    String typeInfoComment = this.getElementText(parser, "TYPEINFO_CMT");
                    ArrayList<Variable> stackParams = new ArrayList<Variable>();
                    ArrayList<Variable> stackVariables = new ArrayList<Variable>();
                    if (!ignoreStackFrames) {
                        this.readStackFrame(parser, func, overwriteConflicts, stackVariables, stackParams);
                    } else {
                        while (parser.peek().isStart() && parser.peek().getName().equals("STACK_FRAME")) {
                            parser.discardSubTree("STACK_FRAME");
                        }
                    }
                    ArrayList<Variable> registerParams = new ArrayList<Variable>();
                    this.readRegisterVars(parser, func, registerParams);
                    if (typeInfoComment == null) {
                        if (returnType != null) {
                            func.setReturnType(returnType, SourceType.IMPORTED);
                        }
                        func.setCustomVariableStorage(true);
                        try {
                            ArrayList<Variable> allParams = new ArrayList<Variable>();
                            allParams.addAll(registerParams);
                            allParams.addAll(stackParams);
                            func.replaceParameters(allParams, Function.FunctionUpdateType.CUSTOM_STORAGE, true, SourceType.IMPORTED);
                        }
                        catch (DuplicateNameException e) {
                            this.log.appendMsg("Could not set name of a parameter in function: " + FunctionsXmlMgr.funcDesc(func) + ": " + e.getMessage());
                        }
                        catch (InvalidInputException iie) {
                            this.log.appendMsg("Bad parameter definition in function: " + FunctionsXmlMgr.funcDesc(func) + ": " + iie.getMessage());
                        }
                    } else {
                        this.tryToParseTypeInfoComment(monitor, func, typeInfoComment);
                    }
                    this.addLocalVars(func, stackVariables, overwriteConflicts);
                    functions.addRange(entryPoint, entryPoint);
                    parser.end(functionElement);
                }
                catch (Exception e) {
                    parser.discardSubTree(functionElement);
                    this.log.appendException((Throwable)e);
                }
            }
        }
        finally {
            builtInMgr.close();
            this.dtParser = null;
        }
        parser.end(element);
        FunctionPurgeAnalysisCmd purgeAnalysisCmd = new FunctionPurgeAnalysisCmd((AddressSetView)functions);
        purgeAnalysisCmd.applyTo((DomainObject)this.program, monitor);
        FunctionStackAnalysisCmd stackAnalysisCmd = new FunctionStackAnalysisCmd((AddressSetView)functions, true);
        stackAnalysisCmd.applyTo((DomainObject)this.program, monitor);
    }

    private void tryToParseTypeInfoComment(TaskMonitor monitor, Function func, String typeInfoComment) {
        try {
            FunctionDefinitionDataType funcDef = CParserUtils.parseSignature(null, this.program, typeInfoComment, false);
            if (funcDef == null) {
                this.log.appendMsg("Unable to parse function definition: " + typeInfoComment);
                return;
            }
            ApplyFunctionSignatureCmd afsCmd = new ApplyFunctionSignatureCmd(func.getEntryPoint(), (FunctionSignature)funcDef, SourceType.IMPORTED, false, false, DataTypeConflictHandler.DEFAULT_HANDLER, FunctionRenameOption.RENAME_IF_DEFAULT);
            if (!afsCmd.applyTo((DomainObject)this.program, monitor)) {
                this.log.appendMsg("Failed to update function " + FunctionsXmlMgr.funcDesc(func) + " with signature \"" + typeInfoComment + "\"");
            }
        }
        catch (Throwable pe) {
            this.log.appendMsg("Unable to parse function definition: " + typeInfoComment);
        }
    }

    private void addLocalVars(Function function, List<Variable> variables, boolean overwriteConflicts) throws InvalidInputException {
        for (Variable v : variables) {
            VariableUtilities.checkVariableConflict((Function)function, (Variable)v, (VariableStorage)v.getVariableStorage(), (boolean)overwriteConflicts);
            try {
                String name = v.getName();
                boolean isDefaultVariableName = name == null || SymbolUtilities.getDefaultLocalName((Program)this.program, (int)v.getStackOffset(), (int)0).equals(name);
                SourceType sourceType = isDefaultVariableName ? SourceType.DEFAULT : SourceType.USER_DEFINED;
                function.addLocalVariable(v, sourceType);
            }
            catch (DuplicateNameException e) {
                this.log.appendMsg("Could not add local variable to function " + FunctionsXmlMgr.funcDesc(function) + ": " + v.getName() + ": " + e.getMessage());
            }
        }
    }

    private static String funcDesc(Function func) {
        return func.getName() + "[" + func.getEntryPoint().toString() + "]";
    }

    private DataType findDataType(XmlElement element) {
        String dtName = element.getAttribute("DATATYPE");
        if (dtName == null) {
            return DataType.DEFAULT;
        }
        CategoryPath cp = new CategoryPath(element.getAttribute("DATATYPE_NAMESPACE"));
        int size = element.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)element.getAttribute("SIZE")) : -1;
        return this.dtParser.parseDataType(dtName, cp, size);
    }

    private String getElementText(XmlPullParser parser, String expectedElementName) {
        String result = null;
        XmlElement element = parser.peek();
        if (element.getName().equals(expectedElementName)) {
            element = parser.next();
            element = parser.next();
            result = element.getText();
        }
        return result;
    }

    private DataType readReturnType(XmlPullParser parser, String funcName) {
        XmlElement element = parser.peek();
        if (element.getName().equals("RETURN_TYPE")) {
            element = parser.next();
            DataType dt = this.findDataType(element);
            if (dt == null) {
                this.log.appendMsg("Unable to locate return type [" + element.getAttribute("DATATYPE") + "] for function [" + funcName + "]");
            }
            element = parser.next();
            return dt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAddressRange(XmlPullParser parser, AddressSet set) throws AddressFormatException, AddressOutOfBoundsException {
        XmlElement element = parser.peek();
        while (element.getName().equals("ADDRESS_RANGE")) {
            element = parser.next();
            String startStr = element.getAttribute("START");
            String endStr = element.getAttribute("END");
            Address start = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)startStr);
            Address end = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)endStr);
            try {
                if (start == null || end == null) {
                    throw new AddressFormatException("Incompatible Function Address Range: [" + startStr + "," + endStr + "]");
                }
                set.addRange(start, end);
            }
            finally {
                element = parser.next();
            }
            element = parser.peek();
        }
    }

    private void readStackFrame(XmlPullParser parser, Function func, boolean overwriteConflicts, List<Variable> stackVariables, List<Variable> stackParams) {
        XmlElement element = parser.peek();
        if (element.getName().equals("STACK_FRAME")) {
            element = parser.next();
            StackFrame frame = func.getStackFrame();
            if (element.hasAttribute("LOCAL_VAR_SIZE")) {
                frame.setLocalSize(XmlUtilities.parseInt((String)element.getAttribute("LOCAL_VAR_SIZE")));
            }
            if (element.hasAttribute("RETURN_ADDR_SIZE")) {
                frame.setReturnAddressOffset(XmlUtilities.parseInt((String)element.getAttribute("RETURN_ADDR_SIZE")));
            }
            if (element.hasAttribute("BYTES_PURGED")) {
                func.setStackPurgeSize(XmlUtilities.parseInt((String)element.getAttribute("BYTES_PURGED")));
            }
            this.readStackVariables(parser, func, overwriteConflicts, stackVariables, stackParams);
            element = parser.next();
        }
    }

    private void readStackVariables(XmlPullParser parser, Function function, boolean overwriteConflicts, List<Variable> stackVariables, List<Variable> stackParams) {
        XmlElement element = parser.peek();
        while (element.getName().equals("STACK_VAR")) {
            String name;
            element = parser.next();
            String stackPtrStringValue = element.getAttribute("STACK_PTR_OFFSET");
            if (stackPtrStringValue == null) {
                stackPtrStringValue = element.getAttribute("OFFSET");
            }
            int offset = stackPtrStringValue == null ? 0 : XmlUtilities.parseInt((String)stackPtrStringValue);
            String sizeStringValue = element.getAttribute("SIZE");
            int size = 1;
            if (stackPtrStringValue != null) {
                size = XmlUtilities.parseInt((String)sizeStringValue);
            }
            boolean isParameter = function.getStackFrame().isParameterOffset(offset);
            String originalName = element.getAttribute("NAME");
            DataType dt = this.findDataType(element);
            if (dt == null) {
                dt = Undefined.getUndefinedDataType((int)size);
            }
            if ((name = originalName) != null) {
                name = this.getUniqueVarName(function, name, offset);
            }
            try {
                String regularComment = this.getElementText(parser, "REGULAR_CMT");
                LocalVariableImpl var = new LocalVariableImpl(name, dt, offset, this.program);
                VariableUtilities.checkVariableConflict((Function)function, (Variable)var, (VariableStorage)var.getVariableStorage(), (boolean)overwriteConflicts);
                if (isParameter) {
                    var = new ParameterImpl(name, dt, offset, this.program);
                    stackParams.add((Variable)var);
                } else {
                    var = new LocalVariableImpl(name, dt, offset, this.program);
                    stackVariables.add((Variable)var);
                }
                var.setComment(regularComment);
            }
            catch (InvalidInputException e) {
                this.log.appendException((Throwable)e);
            }
            element = parser.peek();
            this.getElementText(parser, "REPEATABLE_CMT");
            element = parser.next();
            element = parser.peek();
        }
    }

    private String getUniqueVarName(Function function, String name, int offset) {
        Variable v;
        Symbol s = this.program.getSymbolTable().getVariableSymbol(name, function);
        if (s == null) {
            return name;
        }
        SymbolType st = s.getSymbolType();
        if ((st == SymbolType.LOCAL_VAR || st == SymbolType.PARAMETER) && (v = (Variable)s.getObject()).isStackVariable() && offset == v.getStackOffset()) {
            return name;
        }
        return name + "_" + offset;
    }

    private void readRegisterVars(XmlPullParser parser, Function func, List<Variable> registerParams) {
        XmlElement element = parser.peek();
        while (element.getName().equals("REGISTER_VAR")) {
            element = parser.next();
            try {
                String name = element.getAttribute("NAME");
                String registerName = element.getAttribute("REGISTER");
                DataType dt = this.findDataType(element);
                String comment = this.getElementText(parser, "REGULAR_CMT");
                ProgramContext context = this.program.getProgramContext();
                Register register = context.getRegister(registerName);
                if (dt != null && dt.getLength() > register.getMinimumByteSize()) {
                    this.log.appendMsg("Data type [" + element.getAttribute("DATATYPE") + "] too large for register [" + registerName + "]");
                    dt = null;
                }
                ParameterImpl registerParam = new ParameterImpl(name, dt, register, this.program);
                registerParam.setComment(comment);
                registerParams.add((Variable)registerParam);
            }
            catch (InvalidInputException e) {
                this.log.appendException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.log.appendException((Throwable)e);
            }
            element = parser.next();
            element = parser.peek();
        }
    }

    void write(XmlWriter writer, AddressSetView addrs, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing FUNCTIONS ...");
        writer.startElement("FUNCTIONS");
        FunctionIterator fIter = this.listing.getFunctions(addrs, true);
        while (fIter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Function func = (Function)fIter.next();
            this.writeFunction(writer, func);
        }
        writer.endElement("FUNCTIONS");
    }

    private void writeFunction(XmlWriter writer, Function func) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("ENTRY_POINT", XmlProgramUtilities.toString((Address)func.getEntryPoint()));
        attrs.addAttribute("NAME", this.getName(func));
        attrs.addAttribute("LIBRARY_FUNCTION", this.isLibrary(func) ? "y" : "n");
        writer.startElement("FUNCTION", attrs);
        this.writeReturnType(writer, func);
        this.writeAddressRange(writer, func);
        this.writeRegularComment(writer, func.getComment());
        this.writeRepeatableComment(writer, func.getRepeatableComment());
        if (func.getSignatureSource() != SourceType.DEFAULT) {
            this.writeTypeInfoComment(writer, func);
        }
        this.writeStackFrame(writer, func);
        this.writeRegisterVars(writer, func);
        writer.endElement("FUNCTION");
    }

    private void writeTypeInfoComment(XmlWriter writer, Function func) {
        writer.writeElement("TYPEINFO_CMT", null, func.getPrototypeString(true, true));
    }

    private boolean isLibrary(Function func) {
        Bookmark[] bookmarks;
        BookmarkManager bm = this.program.getBookmarkManager();
        for (Bookmark b : bookmarks = bm.getBookmarks(func.getEntryPoint())) {
            if (!LIBRARY_BOOKMARK_CATEGORY_STRINGS.contains(b.getCategory())) continue;
            return true;
        }
        return false;
    }

    private String getName(Function function) {
        StringBuffer nameBuff = new StringBuffer(function.getName());
        for (Namespace ns = function.getParentNamespace(); ns != this.program.getGlobalNamespace(); ns = ns.getParentNamespace()) {
            nameBuff.insert(0, ns.getName() + "::");
        }
        return nameBuff.toString();
    }

    private void writeReturnType(XmlWriter writer, Function func) {
        DataType rt = func.getReturnType();
        if (rt != null && rt != DataType.DEFAULT) {
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("DATATYPE", rt.getDisplayName());
            attrs.addAttribute("DATATYPE_NAMESPACE", rt.getCategoryPath().getPath());
            attrs.addAttribute("SIZE", rt.getLength(), true);
            writer.writeElement("RETURN_TYPE", attrs);
        }
    }

    private void writeAddressRange(XmlWriter writer, Function func) {
        AddressSetView body = func.getBody();
        AddressRangeIterator iter = body.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("START", XmlProgramUtilities.toString((Address)range.getMinAddress()));
            attrs.addAttribute("END", XmlProgramUtilities.toString((Address)range.getMaxAddress()));
            writer.writeElement("ADDRESS_RANGE", attrs);
        }
    }

    private void writeRegularComment(XmlWriter writer, String comment) {
        if (comment != null && comment.length() > 0) {
            writer.writeElement("REGULAR_CMT", null, comment);
        }
    }

    private void writeRepeatableComment(XmlWriter writer, String comment) {
        if (comment != null && comment.length() > 0) {
            writer.writeElement("REPEATABLE_CMT", null, comment);
        }
    }

    private void writeStackFrame(XmlWriter writer, Function func) {
        Variable[] vars;
        StackFrame frame = func.getStackFrame();
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("LOCAL_VAR_SIZE", frame.getLocalSize(), true);
        attrs.addAttribute("PARAM_OFFSET", frame.getParameterOffset(), true);
        attrs.addAttribute("RETURN_ADDR_SIZE", frame.getReturnAddressOffset(), true);
        int size = func.getStackPurgeSize();
        if (size != Integer.MAX_VALUE && size != 0x7FFFFFFE) {
            attrs.addAttribute("BYTES_PURGED", size);
        }
        writer.startElement("STACK_FRAME", attrs);
        for (Variable var : vars = frame.getStackVariables()) {
            this.writeStackVariable(writer, var);
        }
        writer.endElement("STACK_FRAME");
    }

    private void writeStackVariable(XmlWriter writer, Variable var) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("STACK_PTR_OFFSET", var.getStackOffset(), true);
        attrs.addAttribute("NAME", var.getName());
        DataType dt = var.getDataType();
        attrs.addAttribute("DATATYPE", dt.getDisplayName());
        attrs.addAttribute("DATATYPE_NAMESPACE", dt.getCategoryPath().getPath());
        attrs.addAttribute("SIZE", var.getLength(), true);
        String comment = var.getComment();
        if (comment == null || comment.length() == 0) {
            writer.writeElement("STACK_VAR", attrs);
        } else {
            writer.startElement("STACK_VAR", attrs);
            this.writeRegularComment(writer, comment);
            writer.endElement("STACK_VAR");
        }
    }

    private void writeRegisterVars(XmlWriter writer, Function func) {
        Parameter[] regs;
        for (Parameter reg : regs = this.getRegisterParameters(func)) {
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", reg.getName());
            attrs.addAttribute("REGISTER", reg.getRegister().getName());
            attrs.addAttribute("DATATYPE", reg.getDataType().getDisplayName());
            attrs.addAttribute("DATATYPE_NAMESPACE", reg.getDataType().getCategoryPath().getPath());
            String comment = reg.getComment();
            if (comment == null || comment.length() == 0) {
                writer.writeElement("REGISTER_VAR", attrs);
                continue;
            }
            writer.startElement("REGISTER_VAR", attrs);
            this.writeRegularComment(writer, comment);
            writer.endElement("REGISTER_VAR");
        }
    }

    private Parameter[] getRegisterParameters(Function function) {
        Parameter[] params;
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter param : params = function.getParameters()) {
            if (!param.isRegisterVariable()) continue;
            list.add(param);
        }
        Parameter[] r = new Parameter[list.size()];
        return list.toArray(r);
    }

    static {
        LIBRARY_BOOKMARK_CATEGORY_STRINGS.add(LIB_BOOKMARK_CATEGORY);
        LIBRARY_BOOKMARK_CATEGORY_STRINGS.add(FID_BOOKMARK_CATEGORY);
    }
}

