/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.LayoutLockedFieldPanelCoordinator;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.util.viewer.listingpanel.DualListingFieldPanelCoordinator;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;

public class ListingComparisonFieldPanelCoordinator
extends LayoutLockedFieldPanelCoordinator
implements DualListingFieldPanelCoordinator {
    private ListingCodeComparisonPanel dualListingPanel;
    private ListingAddressCorrelation addressCorrelation;
    private Address[] lockLineAddresses = new Address[2];

    public ListingComparisonFieldPanelCoordinator(ListingCodeComparisonPanel dualListingPanel) {
        super(new FieldPanel[]{dualListingPanel.getLeftPanel().getFieldPanel(), dualListingPanel.getRightPanel().getFieldPanel()});
        this.dualListingPanel = dualListingPanel;
    }

    public void setCorrelation(ListingAddressCorrelation addressCorrelation) {
        this.addressCorrelation = addressCorrelation;
        this.resetLockedLines();
    }

    @Override
    public void leftLocationChanged(ProgramLocation leftLocation) {
        if (this.addressCorrelation == null) {
            return;
        }
        Address leftAddress = leftLocation.getAddress();
        if (leftAddress == null) {
            return;
        }
        Address rightAddress = this.addressCorrelation.getAddressInSecond(leftAddress);
        if (rightAddress == null) {
            return;
        }
        this.setLockedAddresses(leftAddress, rightAddress);
        FieldPanel fp = this.dualListingPanel.getLeftPanel().getFieldPanel();
        this.adjustFieldPanel(fp);
    }

    @Override
    public void rightLocationChanged(ProgramLocation rightLocation) {
        if (this.addressCorrelation == null) {
            return;
        }
        Address rightAddress = rightLocation.getAddress();
        if (rightAddress == null) {
            return;
        }
        Address leftAddress = this.addressCorrelation.getAddressInFirst(rightAddress);
        if (leftAddress == null) {
            return;
        }
        this.setLockedAddresses(leftAddress, rightAddress);
        FieldPanel fp = this.dualListingPanel.getRightPanel().getFieldPanel();
        this.adjustFieldPanel(fp);
    }

    void adjustFieldPanel(FieldPanel fp) {
        ViewerPosition viewerPosition = fp.getViewerPosition();
        BigInteger topIndex = viewerPosition.getIndex();
        int topXOffset = viewerPosition.getXOffset();
        int topYOffset = viewerPosition.getYOffset();
        this.viewChanged(fp, topIndex, topXOffset, topYOffset);
    }

    void setLockedAddresses(Address leftAddress, Address rightAddress) {
        this.lockLineAddresses[0] = leftAddress;
        this.lockLineAddresses[1] = rightAddress;
        ListingPanel leftListingPanel = this.dualListingPanel.getLeftPanel();
        ListingPanel rightListingPanel = this.dualListingPanel.getRightPanel();
        AddressIndexMap leftAddressIndexMap = leftListingPanel.getAddressIndexMap();
        AddressIndexMap rightAddressIndexMap = rightListingPanel.getAddressIndexMap();
        BigInteger leftIndex = leftAddress != null ? leftAddressIndexMap.getIndex(leftAddress) : null;
        BigInteger rightIndex = rightAddress != null ? rightAddressIndexMap.getIndex(rightAddress) : null;
        this.lockLines(new BigInteger[]{leftIndex, rightIndex});
    }

    Address[] getLockedAddresses() {
        return this.lockLineAddresses;
    }
}

