/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AbstractTextFieldElement;
import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.app.util.viewer.field.AnnotationCommentPart;
import ghidra.app.util.viewer.field.CommentPart;
import ghidra.app.util.viewer.field.StringCommentPart;
import ghidra.app.util.viewer.field.SymbolAnnotatedStringHandler;
import ghidra.program.model.listing.Program;
import ghidra.util.StringUtilities;
import ghidra.util.WordLocation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommentUtils {
    private static final Pattern ANNOTATION_START_PATTERN = CommentUtils.createAnnotationStartPattern();

    public static String fixupAnnotations(String rawCommentText, Program program) {
        if (rawCommentText == null) {
            return null;
        }
        AttributedString prototype = CommentUtils.createPrototype();
        Function<Annotation, Annotation> symbolFixer = annotation -> {
            AnnotatedStringHandler handler = annotation.getHandler();
            if (!(handler instanceof SymbolAnnotatedStringHandler)) {
                return annotation;
            }
            String rawText = annotation.getAnnotationText();
            String[] annotationParts = annotation.getAnnotationParts();
            String updatedText = SymbolAnnotatedStringHandler.convertAnnotationSymbolToAddress(annotationParts, rawText, program);
            if (updatedText == null) {
                return annotation;
            }
            return new Annotation(updatedText, prototype, program);
        };
        StringBuilder buffy = new StringBuilder();
        List<CommentPart> parts = CommentUtils.doParseTextIntoTextAndAnnotations(rawCommentText, symbolFixer, program, prototype);
        for (CommentPart part : parts) {
            buffy.append(part.getRawText());
        }
        return buffy.toString();
    }

    private static AttributedString createPrototype() {
        Font dummyFont = Gui.getFont((String)"font.monospaced");
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(dummyFont);
        return new AttributedString("", (Color)GThemeDefaults.Colors.FOREGROUND, fontMetrics);
    }

    public static String getDisplayString(String rawCommentText, Program program) {
        AttributedString prototype = CommentUtils.createPrototype();
        FieldElement element = CommentUtils.parseTextForAnnotations(rawCommentText, program, prototype, 0);
        String displayText = element.getText();
        return displayText;
    }

    public static FieldElement parseTextForAnnotations(String text, Program program, AttributedString prototypeString, int row) {
        Function<Annotation, Annotation> noFixing = Function.identity();
        return CommentUtils.doParseTextForAnnotations(text, noFixing, program, prototypeString, row);
    }

    public static String sanitize(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\u0000", "");
    }

    private static FieldElement doParseTextForAnnotations(String text, Function<Annotation, Annotation> fixerUpper, Program program, AttributedString prototype, int row) {
        text = StringUtilities.convertTabsToSpaces((String)text);
        int column = 0;
        List<CommentPart> parts = CommentUtils.doParseTextIntoTextAndAnnotations(text, fixerUpper, program, prototype);
        ArrayList<AbstractTextFieldElement> fields = new ArrayList<AbstractTextFieldElement>();
        for (CommentPart part : parts) {
            fields.add(part.createElement(row, column));
            column += part.getDisplayText().length();
        }
        return new CompositeFieldElement(fields.toArray(new FieldElement[fields.size()]));
    }

    private static List<CommentPart> doParseTextIntoTextAndAnnotations(String text, Function<Annotation, Annotation> fixerUpper, Program program, AttributedString prototype) {
        ArrayList<CommentPart> results = new ArrayList<CommentPart>();
        List<WordLocation> annotations = CommentUtils.getCommentAnnotations(text);
        if (annotations.isEmpty()) {
            results.add(new StringCommentPart(text, prototype));
            return results;
        }
        int offset = 0;
        for (WordLocation word : annotations) {
            int start = word.getStart();
            if (offset != start) {
                String preceeding = text.substring(offset, start);
                results.add(new StringCommentPart(preceeding, prototype));
            }
            String annotationText = word.getWord();
            Annotation annotation = new Annotation(annotationText, prototype, program);
            annotation = fixerUpper.apply(annotation);
            results.add(new AnnotationCommentPart(annotationText, annotation));
            offset = start + annotationText.length();
        }
        if (offset != text.length()) {
            String trailing = text.substring(offset);
            results.add(new StringCommentPart(trailing, prototype));
        }
        return results;
    }

    static List<WordLocation> getCommentAnnotations(String comment) {
        ArrayList<WordLocation> starts = new ArrayList<WordLocation>();
        Matcher matcher = ANNOTATION_START_PATTERN.matcher(comment);
        while (matcher.find()) {
            int position = matcher.start();
            String text = matcher.group();
            starts.add(new WordLocation(comment, text, position));
        }
        ArrayList<WordLocation> results = new ArrayList<WordLocation>();
        for (WordLocation word : starts) {
            int start = word.getStart();
            int offset = start + word.getWord().length();
            int end = CommentUtils.findAnnotationEnd(comment, offset);
            if (end == -1) continue;
            String annotation = comment.substring(start, end);
            results.add(new WordLocation(comment, annotation, start));
        }
        return results;
    }

    private static Pattern createAnnotationStartPattern() {
        Set<String> names = Annotation.getAnnotationNames();
        String namePatternString = StringUtils.join(names, (String)"|");
        return Pattern.compile("(?<!\\\\)(\\{@(" + namePatternString + ")\\s+?)");
    }

    private static int findAnnotationEnd(String comment, int start) {
        boolean escaped = false;
        boolean inQuote = false;
        for (int i = start; i < comment.length(); ++i) {
            boolean wasEscaped = escaped;
            escaped = false;
            int prev = 0;
            if (i != 0 && !wasEscaped) {
                prev = comment.charAt(i - 1);
            }
            char c = comment.charAt(i);
            if (prev == 92 && "{}\"\\".indexOf(c) != -1) {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c != '}' || inQuote) continue;
            return i + 1;
        }
        return -1;
    }
}

