/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.ne.EntryPoint;
import ghidra.app.util.bin.format.ne.EntryTable;
import ghidra.app.util.bin.format.ne.EntryTableBundle;
import ghidra.app.util.bin.format.ne.ImportedNameTable;
import ghidra.app.util.bin.format.ne.InformationBlock;
import ghidra.app.util.bin.format.ne.LengthStringOrdinalSet;
import ghidra.app.util.bin.format.ne.LengthStringSet;
import ghidra.app.util.bin.format.ne.ModuleReferenceTable;
import ghidra.app.util.bin.format.ne.NewExecutable;
import ghidra.app.util.bin.format.ne.NonResidentNameTable;
import ghidra.app.util.bin.format.ne.ResidentNameTable;
import ghidra.app.util.bin.format.ne.Resource;
import ghidra.app.util.bin.format.ne.ResourceStringTable;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.app.util.bin.format.ne.ResourceType;
import ghidra.app.util.bin.format.ne.Segment;
import ghidra.app.util.bin.format.ne.SegmentRelocation;
import ghidra.app.util.bin.format.ne.SegmentTable;
import ghidra.app.util.bin.format.ne.WindowsHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractOrdinalSupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Conv;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class NeLoader
extends AbstractOrdinalSupportLoader {
    public static final String NE_NAME = "New Executable (NE)";
    private static final String TAB = "    ";
    private static final long MIN_BYTE_LENGTH = 4L;
    private static final int SEGMENT_START = 4096;
    private ArrayList<Address> entryPointList = new ArrayList();
    private Comparator<String> comparator = new CallNameComparator();

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        NewExecutable ne = new NewExecutable(provider, null);
        WindowsHeader wh = ne.getWindowsHeader();
        if (wh != null) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), "" + wh.getInformationBlock().getMagicNumber(), null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing new executable...");
        this.initVars();
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(prog, provider, monitor);
        SegmentedAddressSpace space = (SegmentedAddressSpace)prog.getAddressFactory().getDefaultAddressSpace();
        NewExecutable ne = new NewExecutable(provider, space.getAddress(4096, 0));
        WindowsHeader wh = ne.getWindowsHeader();
        InformationBlock ib = wh.getInformationBlock();
        SegmentTable st = wh.getSegmentTable();
        ResourceTable rt = wh.getResourceTable();
        EntryTable et = wh.getEntryTable();
        ResidentNameTable rnt = wh.getResidentNameTable();
        NonResidentNameTable nrnt = wh.getNonResidentNameTable();
        ImportedNameTable imp = wh.getImportedNameTable();
        ModuleReferenceTable mrt = wh.getModuleReferenceTable();
        Listing listing = prog.getListing();
        SymbolTable symbolTable = prog.getSymbolTable();
        Memory memory = prog.getMemory();
        ProgramContext context = prog.getProgramContext();
        RelocationTable relocTable = prog.getRelocationTable();
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing segment table...");
        this.processSegmentTable(log, ib, st, space, prog, context, fileBytes, monitor);
        if (prog.getMemory().isEmpty()) {
            Msg.error((Object)this, (Object)("Empty memory for " + prog));
            return;
        }
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing resource table...");
        this.processResourceTable(log, prog, rt, space, fileBytes, monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing module reference table...");
        this.processModuleReferenceTable(mrt, st, imp, prog, space, log, monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing entry table...");
        this.processEntryTable(st, ib, et, symbolTable, space, log);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing non-resident name table...");
        this.processNonResidentNameTable(nrnt, symbolTable);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing resident name table...");
        this.processResidentNameTable(rnt, symbolTable);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing segment relocations...");
        this.processRelocations(st, imp, mrt, relocTable, prog, memory, space, log, monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("Processing information block...");
        this.processInformationBlock(ib, nrnt, memory, listing);
        this.processProperties(ib, prog, monitor);
    }

    @Override
    protected boolean isOptionalLibraryFilenameExtensions() {
        return true;
    }

    @Override
    protected boolean isCaseInsensitiveLibraryFilenames() {
        return true;
    }

    private void processProperties(InformationBlock ib, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        Options props = prog.getOptions("Program Information");
        boolean relocatable = (ib.getApplicationFlags() & 0xFFFFFF80) != 0;
        props.setBoolean("Relocatable", relocatable);
    }

    private void processInformationBlock(InformationBlock ib, NonResidentNameTable nrnt, Memory memory, Listing listing) {
        Address addr = memory.getMinAddress();
        CodeUnit firstCU = listing.getCodeUnitAt(addr);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Title:  " + nrnt.getTitle() + "\n");
        buffer.append("Format: New Executable (NE) Windows\n");
        buffer.append("CRC:    " + Conv.toHexString((int)ib.getChecksum()) + "\n");
        buffer.append("\n");
        buffer.append("Program Entry Point (CS:IP):   " + Conv.toHexString((short)ib.getEntryPointSegment()) + ":" + Conv.toHexString((short)ib.getEntryPointOffset()) + "\n");
        buffer.append("Initial Stack Pointer (SS:SP): " + Conv.toHexString((short)ib.getStackPointerSegment()) + ":" + Conv.toHexString((short)ib.getStackPointerOffset()) + "\n");
        buffer.append("Auto Data Segment Index:       " + Conv.toHexString((short)ib.getAutomaticDataSegment()) + "\n");
        buffer.append("Initial Heap Size:             " + Conv.toHexString((short)ib.getInitialHeapSize()) + "\n");
        buffer.append("Initial Stack Size:            " + Conv.toHexString((short)ib.getInitialStackSize()) + "\n");
        buffer.append("Minimum Code Swap Size:        " + Conv.toHexString((short)ib.getMinCodeSwapSize()) + "\n");
        buffer.append("\n");
        buffer.append("Linker Version:  " + ib.getVersion() + "." + ib.getRevision() + "\n");
        buffer.append("Target OS:       " + ib.getTargetOpSysAsString() + "\n");
        buffer.append("Windows Version: " + (ib.getExpectedWindowsVersion() >> 8) + "." + (ib.getExpectedWindowsVersion() & 0xFF) + "\n");
        buffer.append("\n");
        buffer.append("Program Flags:     " + Conv.toHexString((byte)ib.getProgramFlags()) + "\n");
        buffer.append(ib.getProgramFlagsAsString());
        buffer.append("Application Flags: " + Conv.toHexString((byte)ib.getApplicationFlags()) + "\n");
        buffer.append(ib.getApplicationFlagsAsString());
        buffer.append("Other Flags:       " + Conv.toHexString((byte)ib.getOtherFlags()) + "\n");
        buffer.append(ib.getOtherFlagsAsString());
        firstCU.setComment(3, buffer.toString());
    }

    private void processSegmentTable(MessageLog log, InformationBlock ib, SegmentTable st, SegmentedAddressSpace space, Program program, ProgramContext context, FileBytes fileBytes, TaskMonitor monitor) throws IOException {
        try {
            Segment[] segments = st.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                MemoryBlock block;
                String name = (segments[i].isCode() ? "Code" : "Data") + (i + 1);
                SegmentedAddress addr = space.getAddress(segments[i].getSegmentID(), 0);
                boolean r = true;
                boolean w = segments[i].isData() && !segments[i].isReadOnly();
                boolean x = segments[i].isCode();
                int offset = segments[i].getOffsetShiftAligned();
                int length = Short.toUnsignedInt(segments[i].getLength());
                int minalloc = Short.toUnsignedInt(segments[i].getMinAllocSize());
                if (minalloc == 0) {
                    minalloc = 65536;
                }
                if (length > 0) {
                    block = MemoryBlockUtils.createInitializedBlock(program, false, name, (Address)addr, fileBytes, (long)offset, length, "", "", r, w, x, log);
                    if (length < minalloc) {
                        byte[] zeros = new byte[minalloc - length];
                        MemoryBlock zeroBlock = MemoryBlockUtils.createInitializedBlock(program, false, name, addr.add((long)length), new ByteArrayInputStream(zeros), (long)zeros.length, "", "", r, w, x, log, monitor);
                        try {
                            block = program.getMemory().join(block, zeroBlock);
                        }
                        catch (LockException | MemoryBlockException | NotFoundException e) {
                            throw new IOException(e);
                        }
                    }
                } else {
                    block = MemoryBlockUtils.createUninitializedBlock(program, false, name, (Address)addr, minalloc, "", "", r, w, x, log);
                }
                if (segments[i].is32bit()) {
                    Address end = block.getEnd();
                    Register opsizeRegister = context.getRegister("opsize");
                    Register addrsizeRegister = context.getRegister("addrsize");
                    try {
                        context.setValue(opsizeRegister, (Address)addr, end, BigInteger.valueOf(1L));
                        context.setValue(addrsizeRegister, (Address)addr, end, BigInteger.valueOf(1L));
                    }
                    catch (ContextChangeException contextChangeException) {
                        // empty catch block
                    }
                }
                StringBuffer buff = new StringBuffer();
                buff.append("Segment:    " + (i + 1) + "\n");
                buff.append("Offset:     " + Conv.toHexString((int)segments[i].getOffsetShiftAligned()) + "\n");
                buff.append("Length:     " + Conv.toHexString((short)segments[i].getLength()) + "\n");
                buff.append("Min Alloc:  " + Conv.toHexString((short)segments[i].getMinAllocSize()) + "\n");
                buff.append("Flags:      " + Conv.toHexString((short)segments[i].getFlagword()) + "\n");
                buff.append(TAB + (segments[i].isCode() ? "Code" : "Data") + "\n");
                buff.append(segments[i].isDiscardable() ? "    Discardable\n" : "");
                buff.append(segments[i].isExecuteOnly() ? "    Execute Only\n" : "");
                buff.append(segments[i].isLoaded() ? "    Loaded\n" : "");
                buff.append(segments[i].isLoaderAllocated() ? "    LoaderAllocated\n" : "");
                buff.append(TAB + (segments[i].isMoveable() ? "Moveable" : "Fixed") + "\n");
                buff.append(TAB + (segments[i].isPreload() ? "Preload" : "LoadOnCall") + "\n");
                buff.append(TAB + (segments[i].isPure() ? "Pure (Shareable)" : "Impure (Non-shareable)") + "\n");
                buff.append(segments[i].isReadOnly() ? "    Read Only\n" : "");
                buff.append(segments[i].is32bit() ? "    Use 32 Bit\n" : "");
                CodeUnit cu = program.getListing().getCodeUnitAt((Address)addr);
                cu.setComment(1, buff.toString());
            }
            for (Segment segment : segments) {
                if (!segment.isCode()) continue;
                SegmentedAddress addr = space.getAddress(segment.getSegmentID(), 0);
                MemoryBlock mb = program.getMemory().getBlock((Address)addr);
                this.setRegisterDS(ib, st, context, mb.getStart(), mb.getEnd());
            }
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException(e);
        }
    }

    private void processResourceTable(MessageLog log, Program program, ResourceTable rt, SegmentedAddressSpace space, FileBytes fileBytes, TaskMonitor monitor) {
        ResourceType[] types;
        Listing listing = program.getListing();
        if (rt == null) {
            return;
        }
        int id = 0;
        for (ResourceType type : types = rt.getResourceTypes()) {
            Resource[] resources;
            for (Resource resource : resources = type.getResources()) {
                LengthStringSet[] strings;
                int segidx = space.getNextOpenSegment(program.getMemory().getMaxAddress());
                SegmentedAddress addr = space.getAddress(segidx, 0);
                try {
                    int offset = resource.getFileOffsetShifted();
                    int length = resource.getFileLengthShifted();
                    if (length > 0) {
                        MemoryBlockUtils.createInitializedBlock(program, false, "Rsrc" + id++, (Address)addr, fileBytes, (long)offset, length, "", "", true, false, false, log);
                    }
                }
                catch (AddressOverflowException e) {
                    throw new RuntimeException(e);
                }
                StringBuilder buf = new StringBuilder();
                buf.append("Resource Type:  " + Conv.toHexString((short)type.getTypeID()) + " (" + type + ")\n");
                buf.append("File Length:    " + Conv.toHexString((int)resource.getFileLengthShifted()) + "\n");
                buf.append("File Offset:    " + Conv.toHexString((int)resource.getFileOffsetShifted()) + "\n");
                buf.append("Attributes:     " + Conv.toHexString((short)resource.getFlagword()) + " (");
                if (resource.isMoveable()) {
                    buf.append("Moveable");
                }
                if (resource.isPreload()) {
                    buf.append(",Preload");
                }
                if (resource.isPure()) {
                    buf.append(",Pure");
                }
                buf.append(")\n");
                buf.append("Resource ID:    " + resource + "\n");
                buf.append("Handle:         " + Conv.toHexString((short)resource.getHandle()) + "\n");
                buf.append("Usage:          " + Conv.toHexString((short)resource.getUsage()) + "\n");
                CodeUnit cu = listing.getCodeUnitAt((Address)addr);
                if (cu != null) {
                    cu.setComment(1, buf.toString());
                }
                if (!(resource instanceof ResourceStringTable)) continue;
                ResourceStringTable rst = (ResourceStringTable)resource;
                for (LengthStringSet string : strings = rst.getStrings()) {
                    try {
                        long dis = string.getIndex() - (long)resource.getFileOffsetShifted();
                        Address straddr = addr.addNoWrap(dis);
                        listing.createData(straddr, (DataType)new ByteDataType(), 1);
                        straddr = straddr.addNoWrap(1L);
                        listing.createData(straddr, (DataType)new StringDataType(), Byte.toUnsignedInt(string.getLength()));
                    }
                    catch (AddressOverflowException | CodeUnitInsertionException e) {
                        log.appendMsg("Error creating data");
                        log.appendException(e);
                    }
                }
            }
        }
    }

    private void processModuleReferenceTable(ModuleReferenceTable mrt, SegmentTable st, ImportedNameTable imp, Program program, SegmentedAddressSpace space, MessageLog log, TaskMonitor monitor) throws IOException {
        int thunkBodySize = 4;
        ExternalManager externalManager = program.getExternalManager();
        FunctionManager functionManager = program.getFunctionManager();
        Namespace globalNamespace = program.getGlobalNamespace();
        LengthStringSet[] names = mrt.getNames();
        String[][] mod2proclist = new String[names.length][];
        int length = 0;
        for (int i = 0; i < names.length; ++i) {
            String moduleName = names[i].getString();
            String[] callnames = this.getCallNamesForModule(moduleName, mrt, st, imp);
            mod2proclist[i] = callnames;
            length += callnames.length * thunkBodySize;
        }
        if (length == 0) {
            return;
        }
        int segment = space.getNextOpenSegment(program.getMemory().getMaxAddress());
        SegmentedAddress addr = space.getAddress(segment, 0);
        String comment = "";
        String source = "";
        MemoryBlockUtils.createUninitializedBlock(program, false, "EXTERNAL", (Address)addr, length, comment, source, true, false, false, log);
        for (int i = 0; i < names.length; ++i) {
            String[] callnames;
            String moduleName = names[i].getString();
            for (String callname : callnames = mod2proclist[i]) {
                Function refFunction = null;
                try {
                    ExternalLocation loc = externalManager.addExtFunction(moduleName, callname, null, SourceType.IMPORTED);
                    refFunction = loc.getFunction();
                }
                catch (DuplicateNameException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                catch (InvalidInputException e) {
                    log.appendMsg(e.getMessage() + "\n");
                    continue;
                }
                AddressSet body = new AddressSet();
                body.add((Address)addr, addr.add((long)(thunkBodySize - 1)));
                try {
                    functionManager.createThunkFunction(null, globalNamespace, (Address)addr, (AddressSetView)body, refFunction, SourceType.IMPORTED);
                }
                catch (OverlappingFunctionException e) {
                    log.appendMsg(e.getMessage() + "\n");
                }
                addr = addr.addWrap((long)thunkBodySize);
            }
        }
    }

    private String[] getCallNamesForModule(String moduleName, ModuleReferenceTable mrt, SegmentTable st, ImportedNameTable imp) throws IOException {
        Segment[] segments;
        ArrayList<String> list = new ArrayList<String>();
        for (Segment segment : segments = st.getSegments()) {
            SegmentRelocation[] relocs;
            for (SegmentRelocation reloc : relocs = segment.getRelocations()) {
                String procname;
                if (!moduleName.equals(this.getRelocationModuleName(mrt, reloc)) || list.contains(procname = this.getRelocationProcName(reloc, imp))) continue;
                list.add(procname);
            }
        }
        String[] callnames = new String[list.size()];
        list.toArray(callnames);
        Arrays.sort(callnames, this.comparator);
        return callnames;
    }

    private void processEntryTable(SegmentTable st, InformationBlock ib, EntryTable et, SymbolTable symbolTable, SegmentedAddressSpace space, MessageLog log) {
        EntryTableBundle[] bundles;
        short segmentIdx = ib.getEntryPointSegment();
        if (segmentIdx > 0) {
            int segment = st.getSegments()[segmentIdx - 1].getSegmentID();
            short offset = ib.getEntryPointOffset();
            SegmentedAddress entryAddr = space.getAddress(segment, Short.toUnsignedInt(offset));
            symbolTable.addExternalEntryPoint((Address)entryAddr);
            try {
                symbolTable.createLabel((Address)entryAddr, "entry", SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                log.appendMsg("Error creating label at " + (Address)entryAddr);
                log.appendException((Throwable)e);
            }
        }
        for (EntryTableBundle bundle : bundles = et.getBundles()) {
            EntryPoint[] pts;
            if (bundle.getType() == 0) {
                int count = Byte.toUnsignedInt(bundle.getCount());
                for (int i = 0; i < count; ++i) {
                    this.entryPointList.add(null);
                }
                continue;
            }
            for (EntryPoint pt : pts = bundle.getEntryPoints()) {
                int seg = 0;
                if (bundle.isMoveable()) {
                    int segmentIndex = Byte.toUnsignedInt(pt.getSegment()) - 1;
                    if (segmentIndex < 0 || segmentIndex >= st.getSegments().length) {
                        log.appendMsg("Invalid segmentIndex " + segmentIndex);
                        continue;
                    }
                    seg = st.getSegments()[segmentIndex].getSegmentID();
                } else if (bundle.isConstant()) {
                    log.appendMsg("NE - constant entry point...");
                } else {
                    seg = st.getSegments()[bundle.getType() - 1].getSegmentID();
                }
                int off = Short.toUnsignedInt(pt.getOffset());
                SegmentedAddress addr = space.getAddress(seg, off);
                symbolTable.addExternalEntryPoint((Address)addr);
                this.entryPointList.add((Address)addr);
            }
        }
    }

    private void processNonResidentNameTable(NonResidentNameTable nrnt, SymbolTable symbolTable) {
        this.createSymbols(nrnt.getNames(), symbolTable);
    }

    private void processResidentNameTable(ResidentNameTable rnt, SymbolTable symbolTable) {
        this.createSymbols(rnt.getNames(), symbolTable);
    }

    private SegmentedAddress getImportSymbolByName(SymbolTable symbolTable, String modname, String procname) {
        Function func;
        Address[] thunkAddresses;
        Namespace libnamespace = symbolTable.getNamespace(modname, null);
        List symbols = symbolTable.getSymbols(procname, libnamespace);
        if (symbols.isEmpty()) {
            return null;
        }
        Symbol symbol = (Symbol)symbols.get(0);
        if (symbol.getSymbolType() == SymbolType.FUNCTION && symbol.isExternal() && (thunkAddresses = (func = (Function)symbol.getObject()).getFunctionThunkAddresses(false)) != null && thunkAddresses.length != 0) {
            return (SegmentedAddress)thunkAddresses[0];
        }
        return null;
    }

    private void processRelocations(SegmentTable st, ImportedNameTable imp, ModuleReferenceTable mrt, RelocationTable relocTable, Program program, Memory memory, SegmentedAddressSpace space, MessageLog log, TaskMonitor monitor) throws IOException {
        SymbolTable symbolTable = program.getSymbolTable();
        Segment[] segments = st.getSegments();
        for (int s = 0; s < segments.length; ++s) {
            SegmentRelocation[] relocs;
            if (monitor.isCancelled()) {
                return;
            }
            block3: for (SegmentRelocation reloc : relocs = segments[s].getRelocations()) {
                if (monitor.isCancelled()) {
                    return;
                }
                int segment = st.getSegments()[s].getSegmentID();
                int offset = Short.toUnsignedInt(reloc.getOffset());
                SegmentedAddress relocAddr = null;
                if (reloc.isInternalRef()) {
                    if (reloc.getTargetSegment() == 255) {
                        relocAddr = (SegmentedAddress)this.entryPointList.get(reloc.getTargetOffset());
                    } else {
                        int seg = st.getSegments()[reloc.getTargetSegment() - 1].getSegmentID();
                        int off = Short.toUnsignedInt(reloc.getTargetOffset());
                        relocAddr = space.getAddress(seg, off);
                    }
                } else if (reloc.isImportName()) {
                    String modname = this.getRelocationModuleName(mrt, reloc);
                    String procname = imp.getNameAt(reloc.getTargetOffset()).getString();
                    relocAddr = this.getImportSymbolByName(symbolTable, modname, procname);
                } else if (reloc.isImportOrdinal()) {
                    String modname = this.getRelocationModuleName(mrt, reloc);
                    int ordinal = Short.toUnsignedInt(reloc.getTargetOffset());
                    String procname = "Ordinal_" + ordinal;
                    relocAddr = this.getImportSymbolByName(symbolTable, modname, procname);
                } else if (reloc.isOpSysFixup()) {
                    // empty if block
                }
                if (relocAddr == null) continue;
                byte relocType = reloc.getType();
                int byteLength = SegmentRelocation.TYPE_LENGTHS[relocType];
                do {
                    SegmentedAddress address = space.getAddress(segment, offset);
                    try {
                        offset = this.relocate(memory, reloc, address, relocAddr);
                        relocTable.add((Address)address, Relocation.Status.APPLIED, (int)relocType, reloc.getValues(), byteLength, null);
                    }
                    catch (MemoryAccessException e) {
                        log.appendMsg("Relocation does not exist in memory: " + relocAddr);
                        continue block3;
                    }
                } while (!reloc.isAdditive() && offset > 0 && offset < 65535 && !monitor.isCancelled());
            }
        }
    }

    private int relocate(Memory memory, SegmentRelocation reloc, SegmentedAddress address, SegmentedAddress relocAddr) throws MemoryAccessException {
        int value = 0;
        switch (reloc.getType()) {
            case 0: {
                value = memory.getByte((Address)address) & 0xFF;
                memory.setByte((Address)address, (byte)relocAddr.getSegmentOffset());
                break;
            }
            case 2: {
                value = memory.getShort((Address)address) & 0xFFFF;
                int relocSeg = relocAddr.getSegment();
                memory.setByte((Address)address, (byte)relocSeg);
                memory.setByte(address.addWrap(1L), (byte)(relocSeg >> 8));
                break;
            }
            case 5: {
                value = memory.getShort((Address)address) & 0xFFFF;
                long relocOff = relocAddr.getSegmentOffset();
                memory.setByte((Address)address, (byte)relocOff);
                memory.setByte(address.addWrap(1L), (byte)(relocOff >> 8));
                break;
            }
            case 3: {
                value = memory.getInt((Address)address);
                int relocSeg = relocAddr.getSegment();
                long relocOff = relocAddr.getSegmentOffset();
                long farAddr = (long)(relocSeg << 16) | relocOff;
                if (reloc.isAdditive()) {
                    farAddr += (long)value;
                }
                memory.setInt((Address)address, (int)farAddr);
                break;
            }
            case 12: {
                break;
            }
        }
        return value;
    }

    private String getRelocationModuleName(ModuleReferenceTable mrt, SegmentRelocation reloc) {
        if (reloc.isImportName() || reloc.isImportOrdinal()) {
            LengthStringSet[] names = mrt.getNames();
            return names[reloc.getTargetSegment() - 1].getString();
        }
        return null;
    }

    private String getRelocationProcName(SegmentRelocation reloc, ImportedNameTable imp) throws IOException {
        if (reloc.isImportName()) {
            return imp.getNameAt(reloc.getTargetOffset()).getString();
        }
        if (reloc.isImportOrdinal()) {
            int ordinal = Short.toUnsignedInt(reloc.getTargetOffset());
            return "Ordinal_" + ordinal;
        }
        return null;
    }

    private void initVars() {
        this.entryPointList.clear();
        this.entryPointList.add(null);
    }

    private void setRegisterDS(InformationBlock ib, SegmentTable segmentTable, ProgramContext context, Address start, Address end) {
        byte progflag = ib.getProgramFlags();
        boolean isSingleData = (progflag & 1) != 0;
        boolean isMultipleData = (progflag & 2) != 0;
        Register ds = context.getRegister("DS");
        try {
            if (isSingleData || isMultipleData) {
                short autoDataSeg = ib.getAutomaticDataSegment();
                long regval = segmentTable.getSegments()[autoDataSeg - 1].getSegmentID();
                context.setValue(ds, start, end, BigInteger.valueOf(regval));
            } else {
                context.remove(start, end, ds);
            }
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
    }

    private void createSymbols(LengthStringOrdinalSet[] lengthStringOrdinalSets, SymbolTable symbolTable) {
        for (LengthStringOrdinalSet lengthStringOrdinalSet : lengthStringOrdinalSets) {
            Address addr;
            int ordinal = Short.toUnsignedInt(lengthStringOrdinalSet.getOrdinal());
            if (ordinal >= this.entryPointList.size() || (addr = this.entryPointList.get(ordinal)) == null) continue;
            String name = lengthStringOrdinalSet.getString();
            name = SymbolUtilities.replaceInvalidChars((String)name, (boolean)true);
            try {
                symbolTable.createLabel(addr, name, SourceType.IMPORTED);
                symbolTable.createLabel(addr, "Ordinal_" + ordinal, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Error creating label " + name + "@" + addr), (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return NE_NAME;
    }

    private class CallNameComparator
    implements Comparator<String> {
        private int prefixLength = "Ordinal_".length();

        private CallNameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.startsWith("Ordinal_") && s2.startsWith("Ordinal_")) {
                int i2;
                int i1 = Integer.parseInt(s1.substring(this.prefixLength));
                if (i1 < (i2 = Integer.parseInt(s2.substring(this.prefixLength)))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
            return s1.compareTo(s2);
        }
    }
}

