/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.ValidatableLine;
import ghidra.program.model.data.DataType;
import ghidra.util.StringUtilities;
import ghidra.util.UniversalID;
import java.awt.Color;
import java.util.Objects;

public class DataTypeLine
implements ValidatableLine {
    private String type;
    private String name;
    private String comment;
    private DataType dataType;
    private Color typeColor;
    private Color nameColor;
    private Color commentColor;
    private ValidatableLine validationLine;

    DataTypeLine(String name, String type, String comment, DataType dt) {
        this.dataType = dt;
        if (name == null) {
            name = "";
        }
        this.name = name;
        this.type = Objects.requireNonNull(type, "Type of data type cannot be null");
        this.comment = comment == null ? "" : comment;
    }

    @Override
    public ValidatableLine copy() {
        return new DataTypeLine(this.name, this.type, this.comment, this.dataType);
    }

    @Override
    public boolean isDiffColored() {
        return this.getTypeColor() != null || this.getNameColor() != null || this.getCommentColor() != null;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean hasUniversalId() {
        if (this.dataType == null) {
            return false;
        }
        UniversalID id = this.dataType.getUniversalID();
        return id != null && id.getValue() != 0L;
    }

    public Color getTypeColor() {
        return this.typeColor;
    }

    public void setTypeColor(Color typeColor) {
        this.typeColor = typeColor;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setNameColor(Color nameColor) {
        this.nameColor = nameColor;
    }

    public Color getCommentColor() {
        return this.commentColor;
    }

    public void setCommentColor(Color commentColor) {
        this.commentColor = commentColor;
    }

    @Override
    public void setTextColor(Color color) {
        this.setAllColors(color);
    }

    void setAllColors(Color diffColor) {
        this.setNameColor(diffColor);
        this.setTypeColor(diffColor);
        this.setCommentColor(diffColor);
    }

    @Override
    public void updateColor(ValidatableLine otherValidatableLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherValidatableLine == null) {
            this.setNameColor(invalidColor);
            this.setTypeColor(invalidColor);
            this.setCommentColor(invalidColor);
            return;
        }
        if (!(otherValidatableLine instanceof DataTypeLine)) {
            otherValidatableLine.setTextColor(invalidColor);
            return;
        }
        DataTypeLine otherLine = (DataTypeLine)otherValidatableLine;
        if (!otherLine.matchesName(this.name)) {
            this.setNameColor(invalidColor);
            otherLine.setNameColor(invalidColor);
        }
        if (!otherLine.matchesType(this.type)) {
            this.setTypeColor(invalidColor);
            otherLine.setTypeColor(invalidColor);
        }
        if (!otherLine.matchesComment(this.comment)) {
            this.setCommentColor(invalidColor);
            otherLine.setCommentColor(invalidColor);
        }
    }

    boolean matchesName(String otherName) {
        return this.name.equals(otherName);
    }

    boolean matchesType(String otherType) {
        return this.type.equals(otherType);
    }

    boolean matchesComment(String otherComment) {
        return this.comment.equals(otherComment);
    }

    @Override
    public boolean isValidated() {
        return this.validationLine != null;
    }

    @Override
    public String getText() {
        return this.type + " " + this.name + " " + this.comment;
    }

    public String toString() {
        int max = Math.max(this.length(this.type), Math.max(this.length(this.name), this.length(this.comment)));
        return "\ntype:    " + this.pad(this.type, max) + this.colorString(this.typeColor) + "\nname:    " + this.pad(this.name, max) + this.colorString(this.nameColor) + "\ncomment: " + this.pad(this.comment, max) + this.colorString(this.commentColor) + "\n";
    }

    private int length(String s) {
        return s == null ? 0 : s.length();
    }

    private String colorString(Color c) {
        if (c == null) {
            return "";
        }
        return " (colored)";
    }

    private String pad(String actual, int size) {
        int diff = size - actual.length();
        return StringUtilities.pad((String)actual, (char)' ', (int)(-diff));
    }

    @Override
    public boolean matches(ValidatableLine otherValidatableLine) {
        if (otherValidatableLine == null) {
            return false;
        }
        if (!(otherValidatableLine instanceof DataTypeLine)) {
            return false;
        }
        DataTypeLine otherLine = (DataTypeLine)otherValidatableLine;
        return otherLine.matchesName(this.name) && otherLine.matchesType(this.type) && otherLine.matchesComment(this.comment);
    }

    @Override
    public void setValidationLine(ValidatableLine line) {
        if (this.validationLine == line) {
            return;
        }
        this.validationLine = line;
        line.setValidationLine(this);
        this.updateColor(line, INVALID_COLOR);
    }
}

