/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.textfield.HintTextField;
import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.app.util.opinion.IntelHexRecord;
import ghidra.app.util.opinion.IntelHexRecordWriter;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class IntelHexExporter
extends Exporter {
    protected Option addressSpaceOption;
    protected RecordSizeOption recordSizeOption;
    private static final int DEFAULT_RECORD_SIZE = 16;

    public IntelHexExporter() {
        this("Intel Hex", "hex", new HelpLocation("ExporterPlugin", "intel_hex"));
    }

    public IntelHexExporter(int recordSize, boolean dropBytes) {
        this("Intel Hex", "hex", new HelpLocation("ExporterPlugin", "intel_hex"));
        this.recordSizeOption = new RecordSizeOption("Record Size", Integer.class);
        this.recordSizeOption.setRecordSize(recordSize);
        this.recordSizeOption.setDropBytes(dropBytes);
    }

    protected IntelHexExporter(String name, String extension, HelpLocation help) {
        super(name, extension, help);
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        ArrayList<Option> optionsList = new ArrayList<Option>();
        DomainObject domainObject = domainObjectService.getDomainObject();
        if (!(domainObject instanceof Program)) {
            return null;
        }
        Program program = (Program)domainObject;
        this.addressSpaceOption = new Option("Address Space", program.getAddressFactory().getDefaultAddressSpace(), AddressSpace.class, null);
        if (this.recordSizeOption == null) {
            this.recordSizeOption = new RecordSizeOption("Record Size", Integer.class);
        }
        optionsList.add(this.addressSpaceOption);
        optionsList.add(this.recordSizeOption);
        return optionsList;
    }

    @Override
    public void setOptions(List<Option> options) throws OptionException {
        if (!options.isEmpty()) {
            this.addressSpaceOption = options.get(0);
            this.recordSizeOption = (RecordSizeOption)options.get(1);
        }
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        this.log.clear();
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getName());
            return false;
        }
        Program program = (Program)domainObj;
        if (program.getMaxAddress().getSize() > 32) {
            this.log.appendMsg("Cannot be used for programs larger than 32 bits");
            return false;
        }
        if (this.addressSpaceOption == null || this.recordSizeOption == null) {
            this.getOptions(() -> program);
        }
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(file));){
            Memory memory = program.getMemory();
            if (addrSet == null) {
                addrSet = memory;
            }
            try {
                List<IntelHexRecord> records = this.dumpMemory(program, memory, addrSet, monitor);
                for (IntelHexRecord record : records) {
                    writer.println(record.format());
                }
            }
            catch (MemoryAccessException e) {
                throw new ExporterException((Exception)((Object)e));
            }
            finally {
                this.addressSpaceOption = null;
                this.recordSizeOption = null;
            }
        }
        return true;
    }

    protected List<IntelHexRecord> dumpMemory(Program program, Memory memory, AddressSetView addrSetView, TaskMonitor monitor) throws MemoryAccessException {
        MemoryBlock[] blocks;
        int size = (Integer)this.recordSizeOption.getValue();
        boolean dropBytes = this.recordSizeOption.dropExtraBytes();
        IntelHexRecordWriter writer = new IntelHexRecordWriter(size, dropBytes);
        AddressSet set = new AddressSet(addrSetView);
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (block.isInitialized() && block.getStart().getAddressSpace() == this.addressSpaceOption.getValue()) continue;
            set.delete((AddressRange)new AddressRangeImpl(block.getStart(), block.getEnd()));
        }
        AddressIterator addresses = set.getAddresses(true);
        while (addresses.hasNext()) {
            Address address = addresses.next();
            byte b = memory.getByte(address);
            writer.addByte(address, b);
        }
        Address entryPoint = null;
        AddressIterator entryPointIterator = program.getSymbolTable().getExternalEntryPointIterator();
        while (entryPoint == null && entryPointIterator.hasNext()) {
            Address address = entryPointIterator.next();
            if (!set.contains(address)) continue;
            entryPoint = address;
        }
        return writer.finish(entryPoint);
    }

    private class RecordSizeOption
    extends Option {
        private final RecordSizeComponent comp;

        public RecordSizeOption(String name, Class<?> valueClass) {
            super(name, valueClass);
            this.comp = new RecordSizeComponent(16);
        }

        public RecordSizeOption(String name, Class<?> valueClass, Object value, String arg, String group) {
            super(name, valueClass, value, arg, group);
            this.comp = new RecordSizeComponent(16);
        }

        @Override
        public Component getCustomEditorComponent() {
            return this.comp;
        }

        @Override
        public Option copy() {
            return new RecordSizeOption(this.getName(), this.getValueClass(), this.getValue(), this.getArg(), this.getGroup());
        }

        @Override
        public Object getValue() {
            return this.comp.getValue();
        }

        @Override
        public Class<?> getValueClass() {
            return Integer.class;
        }

        public boolean dropExtraBytes() {
            return this.comp.dropExtraBytes();
        }

        public void setRecordSize(int recordSize) {
            this.comp.setRecordSize(recordSize);
        }

        public void setDropBytes(boolean dropBytes) {
            this.comp.setDropBytes(dropBytes);
        }
    }

    private class RecordSizeComponent
    extends JPanel {
        private HintTextField input;
        private GCheckBox dropCb;

        public RecordSizeComponent(int recordSize) {
            this.setLayout(new BorderLayout());
            this.input = new HintTextField(Integer.toString(recordSize), false, (InputVerifier)new BoundedIntegerVerifier());
            this.dropCb = new GCheckBox("Align To Record Size");
            this.input.setText(Integer.toString(recordSize));
            this.add((Component)this.input, "Center");
            this.add((Component)this.dropCb, "East");
        }

        public int getValue() {
            String val = this.input.getText();
            if (!this.input.isFieldValid()) {
                return 16;
            }
            return Integer.valueOf(val);
        }

        public boolean dropExtraBytes() {
            return this.dropCb.isSelected();
        }

        public void setRecordSize(int recordSize) {
            this.input.setText(Integer.toString(recordSize));
        }

        public void setDropBytes(boolean dropBytes) {
            this.dropCb.setSelected(dropBytes);
        }
    }

    private class BoundedIntegerVerifier
    extends InputVerifier {
        private BoundedIntegerVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            int val;
            HintTextField field = (HintTextField)input;
            String text = field.getText();
            try {
                val = Integer.decode(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return val <= 255 && val >= 0;
        }
    }
}

