/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigProperty
extends CliAbstractSig {
    private int sizeOfCount;
    private byte flags;
    private CliAbstractSig.CliRetType returnType;
    private CliAbstractSig.CliParam[] params;
    private final int CLISIGPROPERTY_PROLOG = 8;
    private final int CLISIGPROPERTY_FLAGS_HASTHIS = 32;

    public CliSigProperty(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        this.flags = reader.readNextByte();
        if ((this.flags & 8) != 8) {
            Msg.warn((Object)this, (Object)("PropertySig had unexpected prolog (0x" + Integer.toHexString(this.flags) + ")"));
            return;
        }
        this.flags = (byte)(this.flags ^ 8);
        long origIndex = reader.getPointerIndex();
        int paramsCount = CliSigProperty.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.returnType = new CliAbstractSig.CliRetType(reader);
        }
        catch (InvalidInputException e) {
            this.returnType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            try {
                this.params[i] = new CliAbstractSig.CliParam(reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.params[i] = null;
                e.printStackTrace();
            }
        }
    }

    public boolean hasThis() {
        return (this.flags & 0x20) == 32;
    }

    @Override
    public String getContentsName() {
        return "PropertySig";
    }

    @Override
    public String getContentsComment() {
        return "Contains signature for properties. Gives params for getters/setters.";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "PROPERTY", "Magic (0x08) optionalled OR'd with HASTHIS (0x20)");
        struct.add(CliSigProperty.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of params to follow RetType");
        struct.add(this.returnType.getDefinitionDataType(), "RetType", "Return type");
        for (CliAbstractSig.CliParam param : this.params) {
            struct.add(param.getDefinitionDataType(), "Param", null);
        }
        return struct;
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object paramsStr = "";
        for (CliAbstractSig.CliParam param : this.params) {
            paramsStr = (String)paramsStr + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            paramsStr = ((String)paramsStr).substring(0, ((String)paramsStr).length() - 2);
        }
        return String.format("%s get(%s)", this.getRepresentationOf(this.returnType, stream, isShort), paramsStr);
    }
}

