/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigMethodDef
extends CliAbstractSig {
    private CliAbstractSig.CliRetType retType;
    private CliAbstractSig.CliParam[] params;
    private int sizeOfCount;
    private int genericParamCount;
    private byte flags;
    private int sizeOfGenericCount;
    private final int METHODDEFSIG_FLAGS_DEFAULT = 0;
    private final int METHODDEFSIG_FLAGS_VARARG = 5;
    private final int METHODDEFSIG_FLAGS_GENERIC = 16;
    private final int METHODDEFSIG_FLAGS_HASTHIS = 32;
    private final int METHODDEFSIG_FLAGS_EXPLICITTHIS = 64;

    public CliSigMethodDef(CliBlob blob) throws IOException {
        super(blob);
        long origIndex;
        BinaryReader reader = this.getContentsReader();
        this.flags = reader.readNextByte();
        if ((this.flags & 0x10) == 16) {
            origIndex = reader.getPointerIndex();
            this.genericParamCount = CliSigMethodDef.decodeCompressedUnsignedInt(reader);
            this.sizeOfGenericCount = (int)(reader.getPointerIndex() - origIndex);
        }
        origIndex = reader.getPointerIndex();
        int paramCount = CliSigMethodDef.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.retType = new CliAbstractSig.CliRetType(reader);
        }
        catch (InvalidInputException e) {
            this.retType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            try {
                this.params[i] = new CliAbstractSig.CliParam(reader);
                continue;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getContentsName() {
        return "MethodDefSig";
    }

    @Override
    public String getContentsComment() {
        return "Type info for method return and params";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "Flags", "ORed VARARG/GENERIC/HASTHIS/EXPLICITTHIS");
        if (this.genericParamCount > 0) {
            struct.add(CliSigMethodDef.getDataTypeForBytes(this.sizeOfGenericCount), "GenParamCount", "Number of generic paramameters for the method");
        }
        struct.add(CliSigMethodDef.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of parameter types to follow RetType");
        struct.add(this.retType.getDefinitionDataType(), "RetType", null);
        for (int i = 0; i < this.params.length; ++i) {
            struct.add(this.params[i].getDefinitionDataType(), "Param" + i, null);
        }
        return struct;
    }

    public CliAbstractSig.CliRetType getReturnType() {
        return this.retType;
    }

    public CliAbstractSig.CliParam[] getParamTypes() {
        return (CliAbstractSig.CliParam[])this.params.clone();
    }

    public boolean hasThis() {
        return (this.flags & 0x20) == 32;
    }

    public boolean hasExplicitThis() {
        return (this.flags & 0x40) == 64;
    }

    public boolean hasVarArgs() {
        return (this.flags & 5) == 5;
    }

    public Boolean hasGenericArgs() {
        return (this.flags & 0x10) == 16;
    }

    @Override
    protected String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object rep = this.getRepresentationOf(this.retType, stream, isShort);
        rep = (String)rep + " fn(";
        for (CliAbstractSig.CliParam param : this.params) {
            rep = param == null ? (String)rep + "unidentified_param_type, " : (String)rep + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            rep = ((String)rep).substring(0, ((String)rep).length() - 2);
        }
        rep = (String)rep + ")";
        return rep;
    }
}

