/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.dyld.BindOpcode;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BindingTable {
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<Binding> threadedBindings = null;
    private List<Long> opcodeOffsets = new ArrayList<Long>();
    private List<Long> ulebOffsets = new ArrayList<Long>();
    private List<Long> slebOffsets = new ArrayList<Long>();
    private List<Long> stringOffsets = new ArrayList<Long>();

    public BindingTable() {
    }

    public BindingTable(BinaryReader reader, MachHeader header, int tableSize, boolean lazy) throws IOException {
        this();
        int pointerSize = header.getAddressSize();
        long origIndex = reader.getPointerIndex();
        Binding binding = new Binding();
        block20: while (reader.getPointerIndex() < origIndex + (long)tableSize) {
            this.opcodeOffsets.add(reader.getPointerIndex() - origIndex);
            byte b = reader.readNextByte();
            BindOpcode opcode = BindOpcode.forOpcode(b & 0xF0);
            int immediate = b & 0xF;
            block0 : switch (opcode) {
                case BIND_OPCODE_DONE: {
                    if (lazy) break;
                    return;
                }
                case BIND_OPCODE_SET_DYLIB_ORDINAL_IMM: {
                    binding.libraryOrdinal = immediate;
                    break;
                }
                case BIND_OPCODE_SET_DYLIB_ORDINAL_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.libraryOrdinal = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                    break;
                }
                case BIND_OPCODE_SET_DYLIB_SPECIAL_IMM: {
                    if (immediate == 0) {
                        binding.libraryOrdinal = 0;
                        break;
                    }
                    byte signExtended = (byte)(0xF0 | immediate);
                    binding.libraryOrdinal = signExtended;
                    break;
                }
                case BIND_OPCODE_SET_SYMBOL_TRAILING_FLAGS_IMM: {
                    this.stringOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.symbolName = reader.readNextAsciiString();
                    binding.weak = (immediate & 1) != 0;
                    break;
                }
                case BIND_OPCODE_SET_TYPE_IMM: {
                    binding.type = immediate;
                    break;
                }
                case BIND_OPCODE_SET_ADDEND_SLEB: {
                    this.slebOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.addend = reader.readNext(LEB128::signed);
                    break;
                }
                case BIND_OPCODE_SET_SEGMENT_AND_OFFSET_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.segmentOffset = reader.readNext(LEB128::unsigned);
                    binding.segmentIndex = immediate;
                    break;
                }
                case BIND_OPCODE_ADD_ADDR_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.segmentOffset += reader.readNext(LEB128::unsigned).longValue();
                    break;
                }
                case BIND_OPCODE_DO_BIND: {
                    this.bindings.add(new Binding(binding));
                    if (this.threadedBindings != null) continue block20;
                    binding.segmentOffset += (long)pointerSize;
                    break;
                }
                case BIND_OPCODE_DO_BIND_ADD_ADDR_ULEB: {
                    this.bindings.add(new Binding(binding));
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    binding.segmentOffset += reader.readNext(LEB128::unsigned) + (long)pointerSize;
                    break;
                }
                case BIND_OPCODE_DO_BIND_ADD_ADDR_IMM_SCALED: {
                    this.bindings.add(new Binding(binding));
                    binding.segmentOffset += (long)(immediate * pointerSize + pointerSize);
                    break;
                }
                case BIND_OPCODE_DO_BIND_ULEB_TIMES_SKIPPING_ULEB: {
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    long count = reader.readNext(LEB128::unsigned);
                    this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                    long skip = reader.readNext(LEB128::unsigned);
                    int i = 0;
                    while ((long)i < count) {
                        this.bindings.add(new Binding(binding));
                        binding.segmentOffset += skip + (long)pointerSize;
                        ++i;
                    }
                    continue block20;
                }
                case BIND_OPCODE_THREADED: {
                    switch (immediate) {
                        case 0: {
                            this.ulebOffsets.add(reader.getPointerIndex() - origIndex);
                            int numThreaded = reader.readNextVarInt(LEB128::unsigned);
                            this.threadedBindings = new ArrayList<Binding>(numThreaded);
                            break block0;
                        }
                        case 1: {
                            this.threadedBindings.add(new Binding(binding));
                            break block0;
                        }
                    }
                    Binding unknownBinding = new Binding(binding);
                    unknownBinding.unknownOpcode = Byte.toUnsignedInt(b);
                    this.bindings.add(unknownBinding);
                    return;
                }
                default: {
                    Binding unknownBinding = new Binding(binding);
                    unknownBinding.unknownOpcode = Byte.toUnsignedInt(b) & 0xF0;
                    this.bindings.add(unknownBinding);
                    return;
                }
            }
        }
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public List<Binding> getThreadedBindings() {
        return this.threadedBindings;
    }

    public List<Long> getOpcodeOffsets() {
        return this.opcodeOffsets;
    }

    public List<Long> getUlebOffsets() {
        return this.ulebOffsets;
    }

    public List<Long> getSlebOffsets() {
        return this.slebOffsets;
    }

    public List<Long> getStringOffsets() {
        return this.stringOffsets;
    }

    public static class Binding {
        private String symbolName;
        private int type;
        private int libraryOrdinal;
        private long segmentOffset;
        private int segmentIndex = -1;
        private long addend;
        private boolean weak;
        private Integer unknownOpcode;

        public Binding() {
        }

        public Binding(Binding binding) {
            this.symbolName = binding.symbolName;
            this.type = binding.type;
            this.libraryOrdinal = binding.libraryOrdinal;
            this.segmentOffset = binding.segmentOffset;
            this.segmentIndex = binding.segmentIndex;
            this.addend = binding.addend;
            this.weak = binding.weak;
            this.unknownOpcode = binding.unknownOpcode;
        }

        public String getSymbolName() {
            return this.symbolName;
        }

        public int getType() {
            return this.type;
        }

        public int getLibraryOrdinal() {
            return this.libraryOrdinal;
        }

        public long getSegmentOffset() {
            return this.segmentOffset;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }

        public long getAddend() {
            return this.addend;
        }

        public boolean isWeak() {
            return this.weak;
        }

        public Integer getUnknownOpcode() {
            return this.unknownOpcode;
        }
    }
}

