/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInImage;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInSegment;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsOffsets;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class DyldChainedFixups {
    private MachHeader machoHeader;
    private Program program;
    private List<String> libraryPaths;
    private MessageLog log;
    private TaskMonitor monitor;
    private Memory memory;
    private AddressSpace space;

    public DyldChainedFixups(Program program, MachHeader header, List<String> libraryPaths, MessageLog log, TaskMonitor monitor) {
        this.program = program;
        this.machoHeader = header;
        this.libraryPaths = libraryPaths;
        this.log = log;
        this.monitor = monitor;
        this.memory = program.getMemory();
        this.space = program.getAddressFactory().getDefaultAddressSpace();
    }

    /*
     * WARNING - void declaration
     */
    public List<Address> processChainedFixups() throws Exception {
        this.monitor.setMessage("Fixing up chained pointers...");
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        List<DyldChainedFixupsCommand> loadCommands = this.machoHeader.getLoadCommands(DyldChainedFixupsCommand.class);
        for (DyldChainedFixupsCommand loadCommand : loadCommands) {
            DyldChainedFixupHeader chainHeader = loadCommand.getChainHeader();
            DyldChainedStartsInImage chainedStartsInImage = chainHeader.getChainedStartsInImage();
            List<DyldChainedStartsInSegment> chainedStarts = chainedStartsInImage.getChainedStarts();
            for (DyldChainedStartsInSegment dyldChainedStartsInSegment : chainedStarts) {
                fixedAddresses.addAll(this.processSegmentPointerChain(chainHeader, dyldChainedStartsInSegment));
            }
            this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        }
        if (!loadCommands.isEmpty()) {
            return fixedAddresses;
        }
        Section chainStartsSection = this.machoHeader.getSection("__TEXT", "__chain_starts");
        Section threadStartsSection = this.machoHeader.getSection("__TEXT", "__thread_starts");
        if (chainStartsSection != null) {
            Address sectionStart = this.space.getAddress(chainStartsSection.getAddress());
            MemoryByteProvider provider = new MemoryByteProvider(this.memory, sectionStart);
            BinaryReader reader = new BinaryReader(provider, this.machoHeader.isLittleEndian());
            DyldChainedStartsOffsets chainedStartsOffsets = new DyldChainedStartsOffsets(reader);
            for (int offset : chainedStartsOffsets.getChainStartOffsets()) {
                this.processPointerChain(null, fixedAddresses, chainedStartsOffsets.getPointerFormat(), this.program.getImageBase().add((long)offset).getOffset(), 0L, 0L);
            }
            this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        } else if (threadStartsSection != null) {
            int headStartOffset;
            void var9_13;
            Address threadSectionStart = this.space.getAddress(threadStartsSection.getAddress());
            Address threadSectionEnd = threadSectionStart.add(threadStartsSection.getSize() - 1L);
            long nextOffSize = (this.memory.getInt(threadSectionStart) & 1) * 4 + 4;
            Address address = threadSectionStart.add(4L);
            while (var9_13.compareTo((Object)threadSectionEnd) < 0 && !this.monitor.isCancelled() && (headStartOffset = this.memory.getInt((Address)var9_13)) != -1 && headStartOffset != 0) {
                Address chainStart = this.program.getImageBase().add((long)headStartOffset & 0xFFFFFFFFL);
                fixedAddresses.addAll(this.processPointerChain(chainStart, nextOffSize));
                Address address2 = var9_13.add(4L);
            }
            this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        }
        return fixedAddresses;
    }

    private List<Address> processSegmentPointerChain(DyldChainedFixupHeader chainHeader, DyldChainedStartsInSegment chainStart) throws MemoryAccessException, CancelledException {
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        long fixedAddressCount = 0L;
        if (chainStart.getPointerFormat() == 0) {
            return fixedAddresses;
        }
        long dataPageStart = chainStart.getSegmentOffset();
        dataPageStart += this.program.getImageBase().getOffset();
        long pageSize = chainStart.getPageSize();
        long pageStartsCount = chainStart.getPageCount();
        long authValueAdd = 0L;
        short[] pageStarts = chainStart.getPageStarts();
        short ptrFormatValue = chainStart.getPointerFormat();
        DyldChainedPtr.DyldChainType ptrFormat = DyldChainedPtr.DyldChainType.lookupChainPtr(ptrFormatValue);
        this.monitor.setMessage("Fixing " + ptrFormat.getName() + " chained pointers...");
        this.monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            this.monitor.checkCancelled();
            long page = dataPageStart + pageSize * (long)index;
            this.monitor.setProgress((long)index);
            int pageEntry = pageStarts[index] & 0xFFFF;
            if (pageEntry != 65535) {
                ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
                long pageOffset = pageEntry;
                switch (ptrFormat) {
                    case DYLD_CHAINED_PTR_ARM64E: 
                    case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
                    case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
                    case DYLD_CHAINED_PTR_ARM64E_USERLAND24: {
                        this.processPointerChain(chainHeader.getChainedImports(), unchainedLocList, ptrFormat, page, pageOffset, authValueAdd);
                        break;
                    }
                    case DYLD_CHAINED_PTR_64: 
                    case DYLD_CHAINED_PTR_64_OFFSET: 
                    case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
                    case DYLD_CHAINED_PTR_32: 
                    case DYLD_CHAINED_PTR_32_CACHE: 
                    case DYLD_CHAINED_PTR_32_FIRMWARE: 
                    case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                        this.processPointerChain(chainHeader.getChainedImports(), unchainedLocList, ptrFormat, page, pageOffset, authValueAdd);
                        break;
                    }
                    default: {
                        this.log.appendMsg("WARNING: Pointer Chain format " + ptrFormat + " not processed yet!");
                    }
                }
                fixedAddressCount += (long)unchainedLocList.size();
                fixedAddresses.addAll(unchainedLocList);
            }
            ++index;
        }
        this.log.appendMsg("Fixed " + fixedAddressCount + " " + ptrFormat.getName() + " chained pointers.");
        return fixedAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPointerChain(DyldChainedImports chainedImports, List<Address> unchainedLocList, DyldChainedPtr.DyldChainType pointerFormat, long page, long nextOff, long auth_value_add) throws MemoryAccessException, CancelledException {
        long imageBaseOffset = this.program.getImageBase().getOffset();
        Address chainStart = this.space.getAddress(page);
        long next = -1L;
        boolean start = true;
        while (next != 0L) {
            long chainValue;
            this.monitor.checkCancelled();
            Address chainLoc = chainStart.add(nextOff);
            long newChainValue = chainValue = DyldChainedPtr.getChainValue(this.memory, chainLoc, pointerFormat);
            boolean isAuthenticated = DyldChainedPtr.isAuthenticated(pointerFormat, chainValue);
            boolean isBound = DyldChainedPtr.isBound(pointerFormat, chainValue);
            if (isBound && chainedImports == null) {
                this.log.appendMsg("Error: dyld_chained_import array required to process bound chain fixup at " + chainLoc);
                return;
            }
            String symName = null;
            if (isAuthenticated && !isBound) {
                long offsetFromSharedCacheBase = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                newChainValue = imageBaseOffset + offsetFromSharedCacheBase + auth_value_add;
            } else if (!isAuthenticated && isBound) {
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                long addend = DyldChainedPtr.getAddend(pointerFormat, chainValue);
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                symName = chainedImport.getName();
                List globalSymbols = this.program.getSymbolTable().getGlobalSymbols(symName);
                if (globalSymbols.size() > 0) {
                    Symbol symbol = (Symbol)globalSymbols.get(0);
                    newChainValue = symbol.getAddress().getOffset();
                    this.fixupExternalLibrary(chainedImport.getLibOrdinal(), symbol);
                }
                newChainValue += addend;
            } else if (isAuthenticated && isBound) {
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                symName = chainedImport.getName();
                List globalSymbols = this.program.getSymbolTable().getGlobalSymbols(symName);
                if (globalSymbols.size() > 0) {
                    Symbol symbol = (Symbol)globalSymbols.get(0);
                    newChainValue = symbol.getAddress().getOffset();
                    this.fixupExternalLibrary(chainedImport.getLibOrdinal(), symbol);
                }
                newChainValue += auth_value_add;
            } else {
                newChainValue = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                if (DyldChainedPtr.isRelative(pointerFormat)) {
                    newChainValue += imageBaseOffset;
                }
            }
            if (!start || !this.program.getRelocationTable().hasRelocation(chainLoc)) {
                int byteLength = 0;
                Relocation.Status status = Relocation.Status.FAILURE;
                try {
                    RelocationResult result = DyldChainedPtr.setChainValue(this.memory, chainLoc, pointerFormat, newChainValue);
                    status = result.status();
                    byteLength = result.byteLength();
                }
                catch (Throwable throwable) {
                    this.program.getRelocationTable().add(chainLoc, status, (start ? 32768 : 16384) | (isAuthenticated ? 4 : 0) | (isBound ? 2 : 0) | 1, new long[]{newChainValue}, byteLength, symName);
                    throw throwable;
                }
                this.program.getRelocationTable().add(chainLoc, status, (start ? 32768 : 16384) | (isAuthenticated ? 4 : 0) | (isBound ? 2 : 0) | 1, new long[]{newChainValue}, byteLength, symName);
            }
            unchainedLocList.add(chainLoc);
            start = false;
            next = DyldChainedPtr.getNext(pointerFormat, chainValue);
            nextOff += next * DyldChainedPtr.getStride(pointerFormat);
        }
    }

    private void fixupExternalLibrary(int libraryOrdinal, Symbol symbol) {
        ExternalManager extManager = this.program.getExternalManager();
        int libraryIndex = libraryOrdinal - 1;
        if (libraryIndex >= 0 && libraryIndex < this.libraryPaths.size()) {
            Library library = extManager.getExternalLibrary(this.libraryPaths.get(libraryIndex));
            ExternalLocation loc = extManager.getUniqueExternalLocation("<EXTERNAL>", symbol.getName());
            if (loc != null) {
                try {
                    loc.setName((Namespace)library, symbol.getName(), SourceType.IMPORTED);
                }
                catch (InvalidInputException e) {
                    this.log.appendException((Throwable)e);
                }
            }
        }
    }

    private List<Address> processPointerChain(Address chainStart, long nextOffSize) throws MemoryAccessException {
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        while (!this.monitor.isCancelled()) {
            long chainValue = this.memory.getLong(chainStart);
            this.fixupPointer(chainStart, chainValue);
            fixedAddresses.add(chainStart);
            long nextValueOff = (chainValue >> 51 & 0x7FFL) * nextOffSize;
            if (nextValueOff == 0L) break;
            chainStart = chainStart.add(nextValueOff);
        }
        return fixedAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupPointer(Address pointerAddr, long pointerValue) throws MemoryAccessException {
        Relocation.Status status;
        long BIT63 = Long.MIN_VALUE;
        long BIT62 = 0x4000000000000000L;
        if ((pointerValue & 0x4000000000000000L) != 0L) {
            // empty if block
        }
        long fixedPointerValue = 0L;
        long fixedPointerType = 0L;
        if ((pointerValue & Long.MIN_VALUE) != 0L) {
            long pacMod;
            fixedPointerType = pacMod = pointerValue >> 32 & 0xFFFFL;
            fixedPointerValue = this.program.getImageBase().getOffset() + (pointerValue & 0xFFFFFFFFL);
        } else {
            fixedPointerValue = pointerValue << 13 & 0xFF00000000000000L | pointerValue & 0x7FFFFFFFFFFL;
            if ((pointerValue & 0x40000000000L) != 0L) {
                fixedPointerValue |= 0xFFFC0000000000L;
            }
        }
        byte[] origBytes = new byte[8];
        this.memory.getBytes(pointerAddr, origBytes);
        boolean success = false;
        try {
            this.memory.setLong(pointerAddr, fixedPointerValue);
            success = true;
            status = success ? Relocation.Status.APPLIED : Relocation.Status.FAILURE;
        }
        catch (Throwable throwable) {
            Relocation.Status status2 = success ? Relocation.Status.APPLIED : Relocation.Status.FAILURE;
            this.program.getRelocationTable().add(pointerAddr, status2, (int)fixedPointerType, new long[]{fixedPointerValue}, origBytes, null);
            throw throwable;
        }
        this.program.getRelocationTable().add(pointerAddr, status, (int)fixedPointerType, new long[]{fixedPointerValue}, origBytes, null);
    }
}

