/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncryptedInformationCommand
extends LoadCommand {
    private int cryptoff;
    private int cryptsize;
    private int cryptid;
    private boolean is32bit;

    EncryptedInformationCommand(BinaryReader reader, boolean is32bit) throws IOException {
        super(reader);
        this.is32bit = is32bit;
        this.cryptoff = reader.readNextInt();
        this.cryptsize = reader.readNextInt();
        this.cryptid = reader.readNextInt();
    }

    public int getCryptID() {
        return this.cryptid;
    }

    public int getCryptOffset() {
        return this.cryptoff;
    }

    public int getCryptSize() {
        return this.cryptsize;
    }

    @Override
    public String getCommandName() {
        return "encryption_info_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "cryptoff", null);
        struct.add(DWORD, "cryptsize", null);
        struct.add(DWORD, "cryptid", null);
        if (!this.is32bit) {
            struct.add(DWORD, "pad", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

