/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.DataConverter;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTypeMapper
implements AutoCloseable {
    protected Program program;
    protected DataTypeManager programDTM;
    protected DataTypeManager archiveDTM;
    protected List<CategoryPath> programSearchCPs = new ArrayList<CategoryPath>();
    protected List<CategoryPath> archiveSearchCPs = new ArrayList<CategoryPath>();
    protected Map<Class<?>, StructureMappingInfo<?>> mappingInfo = new HashMap();

    protected DataTypeMapper(Program program, ResourceFile archiveGDT) throws IOException {
        this.program = program;
        this.programDTM = program.getDataTypeManager();
        this.archiveDTM = archiveGDT != null ? FileDataTypeManager.openFileArchive((ResourceFile)archiveGDT, (boolean)false) : null;
    }

    @Override
    public void close() {
        if (this.archiveDTM != null) {
            this.archiveDTM.close();
            this.archiveDTM = null;
        }
    }

    public CategoryPath getDefaultVariableLengthStructCategoryPath() {
        return CategoryPath.ROOT;
    }

    public Program getProgram() {
        return this.program;
    }

    public MarkupSession createMarkupSession(TaskMonitor monitor) {
        return new MarkupSession(this, monitor);
    }

    public DataConverter getDataConverter() {
        return DataConverter.getInstance((boolean)this.program.getMemory().isBigEndian());
    }

    public void addProgramSearchCategoryPath(CategoryPath ... paths) {
        this.programSearchCPs.addAll(Arrays.asList(paths));
    }

    public void addArchiveSearchCategoryPath(CategoryPath ... paths) {
        this.archiveSearchCPs.addAll(Arrays.asList(paths));
    }

    public <T> void registerStructure(Class<T> clazz) throws IOException {
        Structure structDT = null;
        String structName = StructureMappingInfo.getStructureDataTypeNameForClass(clazz);
        if (structName != null && !structName.isBlank()) {
            structDT = this.getType(structName, Structure.class);
        }
        if (!StructureReader.class.isAssignableFrom(clazz) && structDT == null) {
            if (structName == null || structName.isBlank()) {
                structName = "<missing>";
            }
            throw new IOException("Missing struct definition %s - %s".formatted(clazz.getSimpleName(), structName));
        }
        StructureMappingInfo<T> structMappingInfo = StructureMappingInfo.fromClass(clazz, structDT);
        this.mappingInfo.put(clazz, structMappingInfo);
    }

    public void registerStructures(List<Class<?>> classes) throws IOException {
        for (Class<?> clazz : classes) {
            this.registerStructure(clazz);
        }
    }

    public <T> StructureMappingInfo<T> getStructureMappingInfo(Class<T> clazz) {
        StructureMappingInfo<?> smi = this.mappingInfo.get(clazz);
        return smi;
    }

    public <T> StructureMappingInfo<T> getStructureMappingInfo(T structureInstance) {
        return structureInstance != null ? this.mappingInfo.get(structureInstance.getClass()) : null;
    }

    public Structure getStructureDataType(Class<?> clazz) {
        StructureMappingInfo<?> smi = this.mappingInfo.get(clazz);
        return smi != null ? smi.getStructureDataType() : null;
    }

    public String getStructureDataTypeName(Class<?> clazz) {
        StructureMappingInfo<?> mi = this.mappingInfo.get(clazz);
        return mi != null ? mi.getStructureName() : null;
    }

    public <T extends DataType> T getType(String name, Class<T> clazz) {
        DataType dataType = this.findType(name, this.programSearchCPs, this.programDTM);
        if (dataType == null && this.archiveDTM != null && (dataType = this.findType(name, this.archiveSearchCPs, this.archiveDTM)) != null) {
            dataType = this.programDTM.resolve(dataType, (DataTypeConflictHandler)DWARFDataTypeConflictHandler.INSTANCE);
        }
        if (dataType == null) {
            dataType = BuiltInDataTypeManager.getDataTypeManager().getDataType(CategoryPath.ROOT, name);
        }
        return (T)(clazz.isInstance(dataType) ? (DataType)clazz.cast(dataType) : null);
    }

    public <T extends DataType> T getTypeOrDefault(String name, Class<T> clazz, T defaultValue) {
        T result = this.getType(name, clazz);
        return result != null ? result : defaultValue;
    }

    public DataTypeManager getDTM() {
        return this.programDTM;
    }

    public <T> StructureContext<T> getStructureContextOfInstance(T structureInstance) {
        StructureMappingInfo<T> smi = structureInstance != null ? this.getStructureMappingInfo(structureInstance) : null;
        return smi != null ? smi.recoverStructureContext(structureInstance) : null;
    }

    public <T> Address getAddressOfStructure(T structureInstance) {
        StructureMappingInfo<T> smi = structureInstance != null ? this.getStructureMappingInfo(structureInstance) : null;
        StructureContext<T> structureContext = smi != null ? smi.recoverStructureContext(structureInstance) : null;
        return structureContext != null ? structureContext.getStructureAddress() : null;
    }

    public <T> Address getMaxAddressOfStructure(T structureInstance) {
        StructureMappingInfo<T> smi = structureInstance != null ? this.getStructureMappingInfo(structureInstance) : null;
        StructureContext<T> structureContext = smi != null ? smi.recoverStructureContext(structureInstance) : null;
        return structureContext != null ? structureContext.getStructureAddress().add((long)(structureContext.getStructureLength() - 1)) : null;
    }

    public <T> T readStructure(Class<T> structureClass, BinaryReader structReader) throws IOException {
        return this.readStructure(structureClass, null, structReader);
    }

    public <T> T readStructure(Class<T> structureClass, DataType containingFieldDataType, BinaryReader structReader) throws IOException {
        StructureContext<T> structureContext = this.createStructureContext(structureClass, containingFieldDataType, structReader);
        T result = structureContext.readNewInstance();
        return result;
    }

    public <T> T readStructure(Class<T> structureClass, long position) throws IOException {
        return this.readStructure(structureClass, this.getReader(position));
    }

    public <T> T readStructure(Class<T> structureClass, Address address) throws IOException {
        return this.readStructure(structureClass, this.getReader(address.getOffset()));
    }

    public BinaryReader getReader(long position) {
        BinaryReader reader = this.createProgramReader();
        reader.setPointerIndex(position);
        return reader;
    }

    public Address getDataAddress(long offset) {
        return this.program.getImageBase().getNewAddress(offset);
    }

    public Address getCodeAddress(long offset) {
        return this.program.getImageBase().getNewAddress(offset);
    }

    public String toString() {
        return "DataTypeMapper { program: %s }".formatted(this.program.getName());
    }

    protected BinaryReader createProgramReader() {
        MemoryByteProvider bp = new MemoryByteProvider(this.program.getMemory(), this.program.getImageBase().getAddressSpace());
        return new BinaryReader(bp, !this.program.getMemory().isBigEndian());
    }

    protected DataType findType(String name, List<CategoryPath> searchList, DataTypeManager dtm) {
        for (CategoryPath searchCP : searchList) {
            DataType dataType = dtm.getDataType(searchCP, name);
            if (dataType == null) continue;
            return dataType;
        }
        return null;
    }

    private <T> StructureContext<T> createStructureContext(Class<T> structureClass, DataType containingFieldDataType, BinaryReader reader) throws IllegalArgumentException {
        StructureMappingInfo<Class<T>> smi = this.getStructureMappingInfo((T)structureClass);
        if (smi == null) {
            throw new IllegalArgumentException("Unknown structure mapped class: " + structureClass.getSimpleName());
        }
        return new StructureContext<Class<T>>(this, smi, containingFieldDataType, reader);
    }

    public <T> StructureContext<T> createArtificialStructureContext(Class<T> structureClass) {
        StructureMappingInfo<Class<T>> smi = this.getStructureMappingInfo((T)structureClass);
        if (smi == null) {
            throw new IllegalArgumentException("Unknown structure mapped class: " + structureClass.getSimpleName());
        }
        return new StructureContext<Class<T>>(this, smi, null);
    }
}

