/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFAttributeSpecification;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFCompileUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFLocation;
import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFIndirectAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFForm;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DIEAggregate {
    private static final int MAX_FRAGMENT_COUNT = 20;
    private DebugInfoEntry[] fragments;

    public static DIEAggregate createFromHead(DebugInfoEntry die) {
        DebugInfoEntry tmp;
        DIEAggregate result = new DIEAggregate(new DebugInfoEntry[]{die});
        while ((tmp = result.getRefDIE(49)) != null && !result.hasOffset(tmp.getOffset()) && result.getFragmentCount() < 20) {
            result.addFragment(tmp);
        }
        tmp = result.getRefDIE(71);
        if (tmp != null) {
            result.addFragment(tmp);
        }
        result.flipFragments();
        return result;
    }

    public static DIEAggregate createSkipHead(DIEAggregate source) {
        if (source.fragments.length == 1) {
            return null;
        }
        DebugInfoEntry[] partialFrags = new DebugInfoEntry[source.fragments.length - 1];
        System.arraycopy(source.fragments, 1, partialFrags, 0, partialFrags.length);
        return new DIEAggregate(partialFrags);
    }

    public static DIEAggregate createSingle(DebugInfoEntry die) {
        DIEAggregate result = new DIEAggregate(new DebugInfoEntry[]{die});
        return result;
    }

    private DIEAggregate(DebugInfoEntry[] fragments) {
        this.fragments = fragments;
    }

    private void addFragment(DebugInfoEntry newDIE) {
        DebugInfoEntry[] tmp = new DebugInfoEntry[this.fragments.length + 1];
        System.arraycopy(this.fragments, 0, tmp, 1, this.fragments.length);
        tmp[0] = newDIE;
        this.fragments = tmp;
    }

    private void flipFragments() {
        ArrayUtils.reverse((Object[])this.fragments);
    }

    public int getFragmentCount() {
        return this.fragments.length;
    }

    public long getOffset() {
        return this.getHeadFragment().getOffset();
    }

    public long[] getOffsets() {
        long[] result = new long[this.fragments.length];
        for (int i = 0; i < this.fragments.length; ++i) {
            result[i] = this.fragments[i].getOffset();
        }
        return result;
    }

    public boolean hasOffset(long offset) {
        for (DebugInfoEntry fragment : this.fragments) {
            if (fragment.getOffset() != offset) continue;
            return true;
        }
        return false;
    }

    public long getDeclOffset() {
        return this.getLastFragment().getOffset();
    }

    public String getHexOffset() {
        return Long.toHexString(this.getHeadFragment().getOffset());
    }

    public int getTag() {
        return this.getHeadFragment().getTag();
    }

    public DWARFCompilationUnit getCompilationUnit() {
        return this.getHeadFragment().getCompilationUnit();
    }

    public DWARFProgram getProgram() {
        return this.getHeadFragment().getCompilationUnit().getProgram();
    }

    public DebugInfoEntry getLastFragment() {
        return this.fragments[this.fragments.length - 1];
    }

    public DebugInfoEntry getHeadFragment() {
        return this.fragments[0];
    }

    public DIEAggregate getDeclParent() {
        DebugInfoEntry declDIE = this.getLastFragment();
        DebugInfoEntry declParent = declDIE.getParent();
        return this.getCompilationUnit().getProgram().getAggregate(declParent);
    }

    public DIEAggregate getParent() {
        DebugInfoEntry die = this.getHeadFragment();
        DebugInfoEntry parent = die.getParent();
        return this.getCompilationUnit().getProgram().getAggregate(parent);
    }

    public int getDepth() {
        int result = 0;
        for (DebugInfoEntry die = this.getHeadFragment(); die != null; die = die.getParent()) {
            ++result;
        }
        return result - 1;
    }

    private AttrInfo findAttribute(int attribute) {
        for (DebugInfoEntry die : this.fragments) {
            DWARFAttributeValue[] dieAttrValues = die.getAttributes();
            DWARFAttributeSpecification[] attrDefs = die.getAbbreviation().getAttributes();
            for (int i = 0; i < attrDefs.length; ++i) {
                DWARFAttributeSpecification attrDef = attrDefs[i];
                if (attrDef.getAttribute() != attribute) continue;
                DWARFAttributeValue attrVal = dieAttrValues[i];
                DWARFForm form = attrDef.getAttributeForm();
                if (attrVal instanceof DWARFIndirectAttribute) {
                    form = ((DWARFIndirectAttribute)attrVal).getForm();
                    attrVal = ((DWARFIndirectAttribute)attrVal).getValue();
                }
                return new AttrInfo(attrVal, die, form);
            }
        }
        return null;
    }

    public <T extends DWARFAttributeValue> T findAttributeInChildren(int attribute, int childTag, Class<T> clazz) {
        T attributeValue = this.getAttribute(attribute, clazz);
        if (attributeValue != null) {
            return attributeValue;
        }
        for (DebugInfoEntry childDIE : this.getChildren(childTag)) {
            DIEAggregate childDIEA = this.getProgram().getAggregate(childDIE);
            attributeValue = childDIEA.getAttribute(attribute, clazz);
            if (attributeValue == null) continue;
            return attributeValue;
        }
        return null;
    }

    public <T extends DWARFAttributeValue> T getAttribute(int attribute, Class<T> clazz) {
        AttrInfo attrInfo = this.findAttribute(attribute);
        return attrInfo != null ? (T)attrInfo.getValue(clazz) : null;
    }

    public DWARFAttributeValue getAttribute(int attribute) {
        return this.getAttribute(attribute, DWARFAttributeValue.class);
    }

    public long getLong(int attribute, long defaultValue) {
        DWARFNumericAttribute attr = this.getAttribute(attribute, DWARFNumericAttribute.class);
        return attr != null ? attr.getValue() : defaultValue;
    }

    public boolean getBool(int attribute, boolean defaultValue) {
        DWARFBooleanAttribute val = this.getAttribute(attribute, DWARFBooleanAttribute.class);
        return val != null ? val.getValue() : defaultValue;
    }

    public String getString(int attribute, String defaultValue) {
        DWARFStringAttribute attr = this.getAttribute(attribute, DWARFStringAttribute.class);
        return attr != null ? attr.getValue(this.getProgram().getDebugStrings()) : defaultValue;
    }

    public String getName() {
        return this.getString(3, null);
    }

    public long getUnsignedLong(int attribute, long defaultValue) {
        DWARFNumericAttribute attr = this.getAttribute(attribute, DWARFNumericAttribute.class);
        return attr != null ? attr.getUnsignedValue() : defaultValue;
    }

    public DebugInfoEntry getRefDIE(int attribute) {
        AttrInfo attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return null;
        }
        DWARFNumericAttribute val = attrInfo.getValue(DWARFNumericAttribute.class);
        long offset = val != null ? val.getUnsignedValue() : -1L;
        DebugInfoEntry result = this.getProgram().getEntryAtByteOffsetUnchecked(offset);
        if (result == null) {
            Msg.warn((Object)this, (Object)("Invalid reference value [" + Long.toHexString(offset) + "]"));
            Msg.warn((Object)this, (Object)this.toString());
        }
        return result;
    }

    public DIEAggregate getRef(int attribute) {
        DebugInfoEntry die = this.getRefDIE(attribute);
        return this.getCompilationUnit().getProgram().getAggregate(die);
    }

    public DIEAggregate getContainingTypeRef() {
        return this.getRef(29);
    }

    public DIEAggregate getTypeRef() {
        return this.getRef(73);
    }

    public String getSourceFile() {
        AttrInfo attrInfo = this.findAttribute(58);
        if (attrInfo == null) {
            return null;
        }
        DWARFNumericAttribute attr = attrInfo.getValue(DWARFNumericAttribute.class);
        if (attr == null) {
            return null;
        }
        int fileNum = (int)attr.getUnsignedValue();
        DWARFCompileUnit dcu = attrInfo.die.getCompilationUnit().getCompileUnit();
        return dcu.isValidFileIndex(fileNum) ? dcu.getFileByIndex(fileNum) : null;
    }

    public List<DebugInfoEntry> getChildren(int childTag) {
        return this.getHeadFragment().getChildren(childTag);
    }

    public boolean hasAttribute(int attribute) {
        return this.findAttribute(attribute) != null;
    }

    public DIEAggregate getAbstractInstance() {
        AttrInfo aoAttr = this.findAttribute(49);
        if (aoAttr == null) {
            return null;
        }
        for (int aoIndex = 0; aoIndex < this.fragments.length; ++aoIndex) {
            if (this.fragments[aoIndex] != aoAttr.die) continue;
            DebugInfoEntry[] partialFrags = new DebugInfoEntry[this.fragments.length - aoIndex - 1];
            System.arraycopy(this.fragments, aoIndex + 1, partialFrags, 0, partialFrags.length);
            return new DIEAggregate(partialFrags);
        }
        throw new IllegalArgumentException("Should not get here");
    }

    public int parseInt(int attribute, int defaultValue) throws IOException, DWARFExpressionException {
        AttrInfo attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return defaultValue;
        }
        DWARFAttributeValue attr = attrInfo.attr;
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return this.assertValidInt(dnum.getValue());
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = DWARFExpressionEvaluator.create(this.getHeadFragment());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return this.assertValidInt(evaluator.pop());
        }
        throw new IOException("DWARF attribute form not valid for integer value: " + attrInfo.form);
    }

    public long parseUnsignedLong(int attribute, long defaultValue) throws IOException, DWARFExpressionException {
        AttrInfo attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return defaultValue;
        }
        DWARFAttributeValue attr = attrInfo.attr;
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return dnum.getUnsignedValue();
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = DWARFExpressionEvaluator.create(this.getHeadFragment());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return evaluator.pop();
        }
        throw new IOException("DWARF attribute form not valid for integer value: " + attrInfo.form);
    }

    private int assertValidInt(long l) throws IOException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IOException("Value out of allowed range: " + l);
        }
        return (int)l;
    }

    private int assertValidUInt(long l) throws IOException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IOException("Value out of allowed range: " + l);
        }
        return (int)l;
    }

    public int parseDataMemberOffset(int attribute, int defaultValue) throws IOException, DWARFExpressionException {
        AttrInfo attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return defaultValue;
        }
        DWARFAttributeValue attr = attrInfo.attr;
        if (attr instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attr;
            return this.assertValidUInt(dnum.getUnsignedValue());
        }
        if (attr instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attr;
            byte[] exprBytes = dblob.getBytes();
            DWARFExpressionEvaluator evaluator = DWARFExpressionEvaluator.create(this.getHeadFragment());
            DWARFExpression expr = evaluator.readExpr(exprBytes);
            evaluator.evaluate(expr, 0L);
            return this.assertValidUInt(evaluator.pop());
        }
        throw new IOException("DWARF attribute form not valid for data member offset: " + attrInfo.form);
    }

    public List<DWARFLocation> getAsLocation(int attribute, DWARFRange range) throws IOException {
        AttrInfo attrInfo = this.findAttribute(attribute);
        if (attrInfo == null) {
            return List.of();
        }
        DWARFAttributeValue dWARFAttributeValue = attrInfo.attr;
        if (dWARFAttributeValue instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)dWARFAttributeValue;
            return this.readDebugLocList(dnum.getUnsignedValue());
        }
        dWARFAttributeValue = attrInfo.attr;
        if (dWARFAttributeValue instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)dWARFAttributeValue;
            return this._exprBytesAsLocation(dblob, range);
        }
        throw new UnsupportedOperationException("This method is unsupported for the attribute type " + attrInfo.form + ".");
    }

    public long evaluateLocation(DWARFLocation location) throws IOException, DWARFExpressionException {
        DWARFExpressionEvaluator evaluator = DWARFExpressionEvaluator.create(this.getHeadFragment());
        DWARFExpression expr = evaluator.readExpr(location.getLocation());
        evaluator.evaluate(expr);
        return evaluator.pop();
    }

    private List<DWARFLocation> readDebugLocList(long offset) throws IOException {
        long cuBase;
        BinaryReader debug_loc = this.getCompilationUnit().getProgram().getDebugLocation();
        ArrayList<DWARFLocation> results = new ArrayList<DWARFLocation>();
        if (debug_loc == null) {
            return results;
        }
        debug_loc.setPointerIndex(offset);
        byte pointerSize = this.getCompilationUnit().getPointerSize();
        Number baseAddress = this.getCompilationUnit().getCompileUnit().getLowPC();
        long baseAddressOffset = baseAddress != null ? baseAddress.longValue() : 0L;
        Number cuLowPC = this.getCompilationUnit().getCompileUnit().getLowPC();
        long l = cuBase = cuLowPC != null ? cuLowPC.longValue() : Long.MAX_VALUE;
        while (debug_loc.getPointerIndex() < debug_loc.length()) {
            long beginning = DWARFUtil.readAddressAsLong(debug_loc, pointerSize);
            long ending = DWARFUtil.readAddressAsLong(debug_loc, pointerSize);
            if (beginning == 0L && ending == 0L) break;
            if (beginning == -1L || pointerSize == 4 && beginning == 0xFFFFFFFFL) {
                baseAddressOffset = ending;
                continue;
            }
            int size = debug_loc.readNextUnsignedShort();
            byte[] location = debug_loc.readNextByteArray(size);
            boolean isBadOffset = beginning > cuBase;
            long absStart = beginning;
            long absEnd = ending;
            if (!isBadOffset) {
                absStart += baseAddressOffset;
                absEnd += baseAddressOffset;
            }
            results.add(new DWARFLocation(new DWARFRange(absStart, absEnd + 1L), location));
        }
        return results;
    }

    private List<DWARFLocation> _exprBytesAsLocation(DWARFBlobAttribute attr, DWARFRange range) {
        return List.of(new DWARFLocation(range, attr.getBytes()));
    }

    public boolean isDanglingDeclaration() {
        return this.isPartialDeclaration() && this.fragments.length == 1;
    }

    public boolean isPartialDeclaration() {
        return this.hasAttribute(60);
    }

    public boolean isNamedType() {
        switch (this.getTag()) {
            case 2: 
            case 4: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 46: 
            case 56: 
            case 57: 
            case 59: {
                return true;
            }
        }
        return false;
    }

    public boolean isNameSpaceContainer() {
        switch (this.getTag()) {
            case 2: 
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 46: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public boolean isStructureType() {
        switch (this.getTag()) {
            case 2: 
            case 19: 
            case 23: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    public boolean isFuncDefType() {
        switch (this.getTag()) {
            case 21: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DIEAgregrate of: ");
        for (DebugInfoEntry die : this.fragments) {
            sb.append("DIE [").append(Long.toHexString(die.getOffset())).append("], ");
        }
        sb.append("\n");
        for (DebugInfoEntry die : this.fragments) {
            sb.append(die.toString());
        }
        return sb.toString();
    }

    public List<DWARFRange> parseDebugRange(int attribute) throws IOException {
        List<DWARFRange> result = this.readRange(attribute);
        Collections.sort(result);
        return result;
    }

    public List<DWARFRange> readRange(int attribute) throws IOException {
        long baseAddress;
        byte pointerSize = this.getCompilationUnit().getPointerSize();
        BinaryReader reader = this.getCompilationUnit().getProgram().getDebugRanges();
        long offset = this.getUnsignedLong(attribute, -1L);
        if (offset == -1L) {
            throw new IOException("Bad / missing attribute " + attribute);
        }
        reader.setPointerIndex(offset);
        ArrayList<DWARFRange> ranges = new ArrayList<DWARFRange>();
        DWARFCompileUnit dcu = this.getCompilationUnit().getCompileUnit();
        long l = baseAddress = dcu != null && dcu.getLowPC() != null ? dcu.getLowPC().longValue() : 0L;
        while (reader.hasNext()) {
            long beginning = DWARFUtil.readAddressAsLong(reader, pointerSize);
            long ending = DWARFUtil.readAddressAsLong(reader, pointerSize);
            if (beginning == 0L && ending == 0L) break;
            if (beginning == -1L || pointerSize == 4 && beginning == 0xFFFFFFFFL) {
                baseAddress = ending;
                continue;
            }
            ranges.add(new DWARFRange(baseAddress + beginning, baseAddress + ending));
        }
        return ranges;
    }

    public long getLowPC(long defaultValue) {
        DWARFNumericAttribute attr = this.getAttribute(17, DWARFNumericAttribute.class);
        return attr != null ? attr.getUnsignedValue() + this.getProgram().getProgramBaseAddressFixup() : defaultValue;
    }

    public long getHighPC() throws IOException {
        DWARFAttributeValue dWARFAttributeValue;
        AttrInfo high = this.findAttribute(18);
        if (high != null && (dWARFAttributeValue = high.attr) instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute highVal = (DWARFNumericAttribute)dWARFAttributeValue;
            if (high.form == DWARFForm.DW_FORM_addr) {
                return highVal.getUnsignedValue() + this.getProgram().getProgramBaseAddressFixup() - 1L;
            }
            DWARFNumericAttribute low = this.getAttribute(17, DWARFNumericAttribute.class);
            long lhighVal = highVal.getUnsignedValue();
            if (lhighVal == 0L) {
                lhighVal = 1L;
            }
            if (low != null && lhighVal > 0L) {
                return low.getUnsignedValue() + this.getProgram().getProgramBaseAddressFixup() + lhighVal - 1L;
            }
        }
        throw new IOException("Bad/unsupported DW_AT_high_pc attribute value or type");
    }

    public boolean isLowPCEqualHighPC() {
        DWARFAttributeValue dWARFAttributeValue;
        AttrInfo low = this.findAttribute(17);
        AttrInfo high = this.findAttribute(18);
        if (low != null && high != null && low.form == high.form && (dWARFAttributeValue = low.attr) instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute lowVal = (DWARFNumericAttribute)dWARFAttributeValue;
            dWARFAttributeValue = high.attr;
            if (dWARFAttributeValue instanceof DWARFNumericAttribute) {
                DWARFNumericAttribute highVal = (DWARFNumericAttribute)dWARFAttributeValue;
                return lowVal.getValue() == highVal.getValue();
            }
        }
        return false;
    }

    public List<DIEAggregate> getFunctionParamList() {
        ArrayList<DIEAggregate> params = new ArrayList<DIEAggregate>();
        for (DebugInfoEntry paramDIE : this.getChildren(5)) {
            DIEAggregate paramDIEA = this.getProgram().getAggregate(paramDIE);
            params.add(paramDIEA);
        }
        DIEAggregate abstractDIEA = this.getAbstractInstance();
        if (abstractDIEA != null) {
            ArrayList<DIEAggregate> newParams = new ArrayList<DIEAggregate>();
            for (DebugInfoEntry paramDIE : abstractDIEA.getChildren(5)) {
                int index = DIEAggregate.findDIEInList(params, paramDIE);
                if (index >= 0) {
                    newParams.add((DIEAggregate)params.get(index));
                    params.remove(index);
                    continue;
                }
                newParams.add(this.getProgram().getAggregate(paramDIE));
            }
            if (!params.isEmpty()) {
                newParams.addAll(params);
            }
            params = newParams;
        }
        return params;
    }

    private static int findDIEInList(List<DIEAggregate> dieas, DebugInfoEntry die) {
        for (int i = 0; i < dieas.size(); ++i) {
            if (!dieas.get(i).hasOffset(die.getOffset())) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fragments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DIEAggregate)) {
            return false;
        }
        DIEAggregate other = (DIEAggregate)obj;
        return Arrays.equals(this.fragments, other.fragments);
    }

    static class AttrInfo {
        DWARFAttributeValue attr;
        DebugInfoEntry die;
        DWARFForm form;

        AttrInfo(DWARFAttributeValue attr, DebugInfoEntry die, DWARFForm form) {
            this.attr = attr;
            this.die = die;
            this.form = form;
        }

        <T extends DWARFAttributeValue> T getValue(Class<T> clazz) {
            if (this.attr != null && clazz.isAssignableFrom(this.attr.getClass())) {
                return (T)((DWARFAttributeValue)clazz.cast(this.attr));
            }
            return null;
        }
    }
}

