/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import ghidra.app.plugin.core.terminal.DefaultTerminal;
import ghidra.app.plugin.core.terminal.TerminalProvider;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class ThreadedTerminal
extends DefaultTerminal {
    protected final ReadableByteChannel in;
    protected final Thread pumpThread = new Thread(this::pump);
    protected final ByteBuffer buffer = ByteBuffer.allocate(1024);
    protected boolean closed = false;

    public ThreadedTerminal(TerminalProvider provider, InputStream in) {
        super(provider);
        this.in = Channels.newChannel(in);
        this.pumpThread.start();
    }

    @Override
    public void close() {
        this.closed = true;
        this.pumpThread.interrupt();
        super.close();
    }

    static void printBuffer(String prefix, ByteBuffer bb) {
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bb.position(), bytes);
        System.err.print(prefix);
        try {
            String str = new String(bytes, "US-ASCII");
            for (char c : str.toCharArray()) {
                if (c == '\u001b') {
                    System.err.print("\n\\x1b");
                    continue;
                }
                if (c < ' ' || c > '\u007f') {
                    System.err.print("\\x%02x".formatted(c));
                    continue;
                }
                System.err.print(c);
            }
            System.err.println();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Couldn't decode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pump() {
        while (!this.closed) {
            try {
                if (-1 == this.in.read(this.buffer) || this.closed) {
                    return;
                }
                this.buffer.flip();
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.provider.processInput(this.buffer);
                }
                this.buffer.clear();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Console input closed unexpectedly: " + e));
                this.closed = true;
                return;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Unexpected error processing terminal input", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectDisplayOutput(ByteBuffer bb) {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.provider.processInput(bb);
        }
    }
}

