/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.plugin.core.terminal.vt.AnsiColorResolver;
import ghidra.app.plugin.core.terminal.vt.VtAttributes;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class TerminalTextFieldElement
implements FieldElement {
    public static final int UNDERLINE_HEIGHT = 1;
    protected final VtLine line;
    protected final FontMetrics metrics;
    protected final AnsiColorResolver colors;
    protected final int em;

    public TerminalTextFieldElement(VtLine line, FontMetrics metrics, AnsiColorResolver colors) {
        this.line = line;
        this.metrics = metrics;
        this.colors = colors;
        this.em = metrics.charWidth('M');
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        this.line.gatherText(sb, 0, this.line.length());
        return sb.toString();
    }

    public int length() {
        return this.line.length();
    }

    public int getNumCols() {
        return this.line.cols();
    }

    public int getStringWidth() {
        return this.em * this.length();
    }

    public int getHeightAbove() {
        return this.metrics.getMaxAscent() + this.metrics.getLeading();
    }

    public int getHeightBelow() {
        return this.metrics.getMaxDescent();
    }

    public char charAt(int index) {
        return this.line.getChar(index);
    }

    public Color getColor(int charIndex) {
        return this.line.getCellAttrs(charIndex).resolveForeground(this.colors);
    }

    public FieldElement substring(int start) {
        return this;
    }

    public FieldElement substring(int start, int end) {
        return this;
    }

    public FieldElement replaceAll(char[] targets, char replacement) {
        throw new UnsupportedOperationException("No wrapping");
    }

    public int getMaxCharactersForWidth(int width) {
        return width / this.em;
    }

    public RowColLocation getDataLocationForCharacterIndex(int characterIndex) {
        return new RowColLocation(0, characterIndex);
    }

    public int getCharacterIndexForDataLocation(int dataRow, int dataColumn) {
        if (dataRow == 0 && dataColumn >= 0 && dataColumn < this.length()) {
            return dataColumn;
        }
        return -1;
    }

    protected void paintChars(JComponent c, Graphics g, int x, int y, VtAttributes attrs, int start, int end) {
        char[] ch = this.line.getCharBuffer();
        int descent = this.metrics.getDescent();
        int height = this.metrics.getHeight();
        int left = x + start * this.em;
        int width = this.em * (end - start);
        Font font = this.metrics.getFont();
        Color bg = attrs.resolveBackground(this.colors);
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(left, descent - height, width, height);
        }
        g.setColor(attrs.resolveForeground(this.colors));
        if (attrs.intensity() == VtHandler.Intensity.DIM) {
            g.setFont(font.deriveFont(0));
        } else {
            g.setFont(font.deriveFont(1));
        }
        if (!attrs.hidden()) {
            switch (attrs.underline()) {
                case DOUBLE: {
                    g.fillRect(left, descent - 3, width, 1);
                }
                case SINGLE: {
                    g.fillRect(left, descent - 1, width, 1);
                }
            }
            for (int i = start; i < end; ++i) {
                int chW = this.metrics.charWidth(ch[i]);
                if (chW != this.em) {
                    try (SaveTransform st = new SaveTransform(g);){
                        st.g.translate(x + this.em * i, 0);
                        st.g.scale((double)this.em / (double)chW, 1.0);
                        st.g.drawChars(ch, i, 1, 0, 0);
                        continue;
                    }
                }
                g.drawChars(ch, i, 1, x + this.em * i, 0);
            }
            if (attrs.strikeThrough()) {
                g.fillRect(left, height * 2 / 3, width, 1);
            }
        }
    }

    public void paint(JComponent c, Graphics g, int x, int y) {
        this.line.forEachRun((attrs, start, end) -> this.paintChars(c, g, x, y, attrs, start, end));
    }

    public FieldElement getFieldElement(int column) {
        return this;
    }

    protected static class SaveTransform
    implements AutoCloseable {
        private final Graphics2D g;
        private final AffineTransform saved;

        public SaveTransform(Graphics g) {
            this.g = (Graphics2D)g;
            this.saved = this.g.getTransform();
        }

        @Override
        public void close() {
            this.g.setTransform(this.saved);
        }
    }
}

