/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.ClassSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import java.awt.datatransfer.DataFlavor;
import javax.swing.Icon;

public class NamespaceCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_NAMESPACES_ICON = new GIcon("icon.plugin.symboltree.node.category.namespace.open");
    public static final Icon CLOSED_FOLDER_NAMESPACES_ICON = new GIcon("icon.plugin.symboltree.node.category.namespace.closed");

    NamespaceCategoryNode(Program program) {
        super(SymbolCategory.NAMESPACE_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_NAMESPACES_ICON : CLOSED_FOLDER_NAMESPACES_ICON;
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        if (super.supportsSymbol(symbol)) {
            return true;
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        return parentNamespace != null && parentNamespace != this.globalNamespace;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (!this.isSupportedLocalFlavor(flavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedLocalFlavor(DataFlavor flavor) {
        if (!this.isLocalDataFlavor(flavor)) {
            return false;
        }
        return flavor != ClassSymbolNode.LOCAL_DATA_FLAVOR;
    }
}

