/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.strings.EncodedStringsFilterStats;
import ghidra.app.plugin.core.strings.EncodedStringsOptions;
import ghidra.app.plugin.core.strings.EncodedStringsRow;
import ghidra.app.plugin.core.strings.StringInfo;
import ghidra.app.plugin.core.strings.UndefinedStringIterator;
import ghidra.app.services.StringValidatorQuery;
import ghidra.app.services.StringValidityScore;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.table.TableModel;

class EncodedStringsTableModel
extends AddressBasedTableModel<EncodedStringsRow> {
    private UnicodeScriptColumn unicodeScriptColumn;
    private ValidStringColumn validStringColumn;
    private AddressSetView selectedAddresses;
    private AddressSetView filteredAddresses;
    private boolean singleStringMode;
    private ModelState state;

    EncodedStringsTableModel(Program program, AddressSetView selectedAddresses) {
        super("Encoded Strings Table", (ServiceProvider)new ServiceProviderStub(), program, null, true);
        this.selectedAddresses = selectedAddresses;
        this.singleStringMode = selectedAddresses.getNumAddresses() == 1L;
        this.state = new ModelState(null, null);
    }

    public EncodedStringsFilterStats getStats() {
        return this.state.stats;
    }

    public void dispose() {
        this.state = new ModelState(null, null);
        super.dispose();
    }

    @Override
    protected TableColumnDescriptor<EncodedStringsRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        this.validStringColumn = new ValidStringColumn();
        this.unicodeScriptColumn = new UnicodeScriptColumn();
        descriptor.addVisibleColumn((DynamicTableColumn)new DataLocationColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new StringRepColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new RefCountColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new OffcutRefCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)this.unicodeScriptColumn);
        descriptor.addVisibleColumn((DynamicTableColumn)this.validStringColumn);
        descriptor.addVisibleColumn((DynamicTableColumn)new LengthColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ByteLengthColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<EncodedStringsRow> accumulator, TaskMonitor monitor) throws CancelledException {
        Program localProgram = this.program;
        ModelState state = this.state;
        if (state == null || localProgram == null || state.options == null) {
            return;
        }
        if (state.previousData != null) {
            EncodedStringsFilterStats newStats = new EncodedStringsFilterStats();
            for (EncodedStringsRow row : state.previousData) {
                if (!row.matches(state.options, newStats)) continue;
                accumulator.add((Object)row);
            }
            state.stats = newStats;
            return;
        }
        Listing listing = localProgram.getListing();
        if (this.filteredAddresses == null) {
            this.filteredAddresses = this.singleStringMode ? UndefinedStringIterator.getSingleStringEndAddrRange(localProgram, this.selectedAddresses) : new AddressSet(this.selectedAddresses);
            this.filteredAddresses = this.filteredAddresses.intersect(localProgram.getMemory().getAllInitializedAddressSet());
            monitor.setIndeterminate(true);
            monitor.initialize(0L, "Finding undefined address ranges");
            this.filteredAddresses = listing.getUndefinedRanges(this.filteredAddresses, false, monitor);
            monitor.setIndeterminate(false);
        }
        int align = 1;
        if (state.options.alignStartOfString()) {
            align = localProgram.getDataTypeManager().getDataOrganization().getSizeAlignment(state.options.charSize());
        }
        ArrayList<EncodedStringsRow> allStrings = new ArrayList<EncodedStringsRow>();
        EncodedStringsFilterStats newStats = new EncodedStringsFilterStats();
        UndefinedStringIterator usi = new UndefinedStringIterator(localProgram, this.filteredAddresses, state.options.charSize(), align, state.options.breakOnRef(), this.singleStringMode, state.options.stringDT(), state.options.settings(), monitor);
        for (StringDataInstance sdi : usi) {
            monitor.checkCancelled();
            StringInfo stringInfo = StringInfo.fromString(sdi.getStringValue());
            int refCount = localProgram.getReferenceManager().getReferenceCountTo(sdi.getAddress());
            int offcutRefCount = this.getOffcutRefCount(localProgram, (AddressRange)new AddressRangeImpl(sdi.getAddress(), sdi.getEndAddress()));
            boolean isValid = true;
            if (state.options.stringValidator() != null) {
                StringValidatorQuery svq = new StringValidatorQuery(stringInfo.stringValue(), stringInfo);
                StringValidityScore score = state.options.stringValidator().getStringValidityScore(svq);
                isValid = score.isScoreAboveThreshold();
            }
            EncodedStringsRow row = new EncodedStringsRow(sdi, stringInfo, refCount, offcutRefCount, isValid);
            allStrings.add(row);
            if (row.matches(state.options, newStats)) {
                accumulator.add((Object)row);
            }
            if (!this.singleStringMode) continue;
            break;
        }
        state.stats = newStats;
        state.previousData = allStrings;
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int elementIndex : rows) {
            EncodedStringsRow row = (EncodedStringsRow)this.filteredData.get(elementIndex);
            set.add(row.sdi().getAddressRange());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    public void removeRows(List<EncodedStringsRow> rows) {
        for (EncodedStringsRow row : rows) {
            this.removeObject(row);
        }
    }

    public void setOptions(EncodedStringsOptions options) {
        ModelState newState;
        boolean canReusePrevData = options.equivalentStringCreationOptions(this.state.options);
        this.state = newState = new ModelState(options, canReusePrevData ? this.state.previousData : null);
        this.clearData();
        this.reload();
    }

    @Override
    public Address getAddress(int row) {
        return ((EncodedStringsRow)this.getRowObject(row)).sdi().getAddress();
    }

    private int getOffcutRefCount(Program localProgram, AddressRange range) {
        int offcutRefCount = 0;
        Address prevAddr = range.getMinAddress();
        for (Address address : localProgram.getReferenceManager().getReferenceDestinationIterator((AddressSetView)new AddressSet(range), true)) {
            if (address.equals((Object)prevAddr)) continue;
            ++offcutRefCount;
            prevAddr = address;
        }
        return offcutRefCount;
    }

    private static class ModelState {
        final EncodedStringsOptions options;
        Collection<EncodedStringsRow> previousData;
        EncodedStringsFilterStats stats = new EncodedStringsFilterStats();

        ModelState(EncodedStringsOptions options, Collection<EncodedStringsRow> previousData) {
            this.options = options;
            this.previousData = previousData;
        }
    }

    private static class ValidStringColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, Boolean> {
        private ValidStringColumn() {
        }

        public String getColumnName() {
            return "Is Valid String";
        }

        public Boolean getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.validString();
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class UnicodeScriptColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, String> {
        private UnicodeScriptColumn() {
        }

        public String getColumnName() {
            return "Unicode Script";
        }

        public String getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Set<Character.UnicodeScript> scripts = rowObject.stringInfo().scripts();
            String formattedColStr = scripts.stream().map(Enum::name).collect(Collectors.joining(","));
            return formattedColStr;
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class DataLocationColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, AddressBasedLocation> {
        private DataLocationColumn() {
        }

        public String getColumnName() {
            return "Location";
        }

        public AddressBasedLocation getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return new AddressBasedLocation(program, rowObject.sdi().getAddress());
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class StringRepColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, EncodedStringsRow> {
        private StringRepCellRenderer renderer = new StringRepCellRenderer();

        private StringRepColumn() {
        }

        public String getColumnName() {
            return "String";
        }

        public EncodedStringsRow getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject;
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }

        public GColumnRenderer<EncodedStringsRow> getColumnRenderer() {
            return this.renderer;
        }

        private class StringRepCellRenderer
        extends AbstractGColumnRenderer<EncodedStringsRow> {
            private StringRepCellRenderer() {
            }

            protected String getText(Object value) {
                String string;
                if (value instanceof EncodedStringsRow) {
                    EncodedStringsRow rowValue = (EncodedStringsRow)value;
                    string = rowValue.sdi().getStringRepresentation();
                } else {
                    string = "";
                }
                return string;
            }

            public String getFilterString(EncodedStringsRow t, Settings settings) {
                return this.getText(t);
            }

            protected void setForegroundColor(JTable table, TableModel model, Object value) {
                EncodedStringsRow rowValue;
                if (value instanceof EncodedStringsRow && (rowValue = (EncodedStringsRow)value).stringInfo().hasCodecError()) {
                    this.setForeground((Color)GThemeDefaults.Colors.Tables.ERROR_UNSELECTED);
                } else {
                    super.setForegroundColor(table, model, value);
                }
            }
        }
    }

    private static class RefCountColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, Integer> {
        private RefCountColumn() {
        }

        public String getColumnName() {
            return "Reference Count";
        }

        public Integer getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.refCount();
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class OffcutRefCountColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, Integer> {
        private OffcutRefCountColumn() {
        }

        public String getColumnName() {
            return "Offcut Reference Count";
        }

        public Integer getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.offcutCount();
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class LengthColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, Integer> {
        private LengthColumn() {
        }

        public String getColumnName() {
            return "Length";
        }

        public Integer getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.stringInfo().stringValue().length();
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }

    private static class ByteLengthColumn
    extends AbstractProgramLocationTableColumn<EncodedStringsRow, Integer> {
        private ByteLengthColumn() {
        }

        public String getColumnName() {
            return "Byte Length";
        }

        public Integer getValue(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.sdi().getDataLength();
        }

        @Override
        public ProgramLocation getProgramLocation(EncodedStringsRow rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
            return new ProgramLocation(program, rowObject.sdi().getAddress());
        }
    }
}

