/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.PostCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.util.StringUtilities;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentFieldSearcher
extends ProgramDatabaseFieldSearcher {
    private AddressIterator iterator;
    private final int commentType;
    private Program program;

    public CommentFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, int commentType) {
        super(pattern, forward, startLoc, set);
        this.commentType = commentType;
        this.program = program;
        if (set != null) {
            this.iterator = program.getListing().getCommentAddressIterator(commentType, set, forward);
        } else {
            Memory addressSet = program.getMemory();
            if (forward) {
                addressSet.intersectRange(startLoc.getAddress(), addressSet.getMaxAddress());
            } else {
                addressSet.intersectRange(addressSet.getMinAddress(), startLoc.getAddress());
            }
            this.iterator = program.getListing().getCommentAddressIterator(commentType, (AddressSetView)addressSet, forward);
        }
    }

    @Override
    protected Address advance(List<Searcher.TextSearchResult> currentMatches) {
        Address nextAddress = this.iterator.next();
        if (nextAddress != null) {
            this.findMatchesForCurrentAddress(nextAddress, currentMatches);
        }
        return nextAddress;
    }

    private void findMatchesForCurrentAddress(Address address, List<Searcher.TextSearchResult> currentMatches) {
        String comment = this.program.getListing().getComment(this.commentType, address);
        if (comment == null) {
            return;
        }
        String cleanedUpComment = comment.replace('\n', ' ');
        Matcher matcher = this.pattern.matcher(cleanedUpComment);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult(this.getCommentLocation(comment, index, address), index));
        }
    }

    private ProgramLocation getCommentLocation(String commentStr, int index, Address address) {
        String[] comments = StringUtilities.toLines((String)commentStr);
        int rowIndex = this.findRowIndex(comments, index);
        int charOffset = this.getRelativeCharOffset(index, rowIndex, comments);
        int[] dataPath = this.getDataComponentPath(address);
        switch (this.commentType) {
            case 0: {
                return new EolCommentFieldLocation(this.program, address, dataPath, comments, rowIndex, charOffset, rowIndex);
            }
            case 3: {
                return new PlateFieldLocation(this.program, address, dataPath, rowIndex, charOffset, comments, rowIndex);
            }
            case 4: {
                return new RepeatableCommentFieldLocation(this.program, address, dataPath, comments, rowIndex, charOffset, rowIndex);
            }
            case 2: {
                return new PostCommentFieldLocation(this.program, address, dataPath, comments, rowIndex, charOffset);
            }
        }
        return new CommentFieldLocation(this.program, address, dataPath, comments, this.commentType, rowIndex, charOffset);
    }

    private int[] getDataComponentPath(Address address) {
        Data data;
        Data primitiveAt;
        CodeUnit cu = this.program.getListing().getCodeUnitContaining(address);
        if (cu == null) {
            return null;
        }
        if (cu instanceof Data && (primitiveAt = (data = (Data)cu).getPrimitiveAt((int)address.subtract(data.getAddress()))) != null) {
            return primitiveAt.getComponentPath();
        }
        return null;
    }

    private int getRelativeCharOffset(int index, int rowIndex, String[] comments) {
        int preceding = 0;
        for (int i = 0; i < rowIndex; ++i) {
            preceding += comments[i].length();
        }
        return index - preceding;
    }

    private int findRowIndex(String[] commentStrings, int index) {
        int totalSoFar = 0;
        for (int i = 0; i < commentStrings.length; ++i) {
            if (index < totalSoFar + commentStrings[i].length()) {
                return i;
            }
            totalSoFar += commentStrings[i].length();
        }
        return commentStrings.length - 1;
    }
}

