/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.MultiLineLabel;
import docking.widgets.label.GLabel;
import docking.widgets.list.ListPanel;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SaveDialog
extends DialogComponentProvider
implements ListSelectionListener {
    protected GhidraScriptComponentProvider componentProvider;
    protected ResourceFile scriptFile;
    private GhidraScriptProvider provider;
    private List<ResourceFile> paths;
    private ListPanel<ResourceFile> listPanel;
    private JTextField nameField;
    private boolean cancelled;

    SaveDialog(Component parent, String title, GhidraScriptComponentProvider componentProvider, ResourceFile scriptFile, HelpLocation help) {
        this(parent, title, componentProvider, componentProvider.getWritableScriptDirectories(), scriptFile, help);
    }

    public SaveDialog(Component parent, String title, GhidraScriptComponentProvider componentProvider, List<ResourceFile> scriptDirs, ResourceFile scriptFile, HelpLocation help) {
        super(title, true, true, true, false);
        this.componentProvider = componentProvider;
        this.provider = GhidraScriptUtil.getProvider(scriptFile);
        this.scriptFile = scriptFile;
        this.paths = new ArrayList<ResourceFile>(scriptDirs);
        JPanel pathPanel = this.buildPathPanel();
        JPanel namePanel = this.buildNamePanel();
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (this.paths.size() != 0) {
            panel.add((Component)pathPanel, "Center");
            panel.add((Component)namePanel, "South");
        } else {
            panel.add((Component)namePanel, "North");
        }
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setHelpLocation(help);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    private JPanel buildNamePanel() {
        this.nameField = new JTextField(20);
        this.nameField.setText(this.scriptFile == null ? "" : this.scriptFile.getName());
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.add((Component)new GLabel("Enter script file name:"), "North");
        panel.add((Component)this.nameField, "Center");
        return panel;
    }

    private JPanel buildPathPanel() {
        DefaultListModel<ResourceFile> listModel = new DefaultListModel<ResourceFile>();
        for (ResourceFile dir : this.paths) {
            listModel.addElement(dir);
        }
        this.listPanel = new ListPanel();
        this.listPanel.setName("PATH_LIST");
        this.listPanel.setListModel(listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.setDoubleClickActionListener(e -> this.close());
        if (this.scriptFile != null) {
            this.listPanel.setSelectedValue((Object)this.scriptFile.getParentFile());
        }
        this.listPanel.setListSelectionListener((ListSelectionListener)this);
        JPanel pathPanel = new JPanel(new BorderLayout());
        MultiLineLabel mll = new MultiLineLabel("Please select a directory:");
        pathPanel.add((Component)mll, "North");
        pathPanel.add((Component)this.listPanel, "Center");
        return pathPanel;
    }

    protected void dialogShown() {
        String text = this.nameField.getText();
        int endIndex = text.length();
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            endIndex = dotIndex;
        }
        this.nameField.requestFocusInWindow();
        this.nameField.select(0, endIndex);
        super.dialogShown();
    }

    protected void okCallback() {
        if (this.paths.size() != 0 && this.listPanel.getSelectedIndex() == -1) {
            this.setStatusText("Please select a directory.");
            return;
        }
        if (this.nameField.getText().length() == 0) {
            this.setStatusText("Please enter a file name.");
            return;
        }
        if (this.nameField.getText().length() > 100) {
            this.setStatusText("File name is too long.");
            return;
        }
        String errorMessage = this.getDuplicateNameErrorMessage(this.nameField.getText());
        if (errorMessage != null) {
            this.setStatusText(errorMessage);
            return;
        }
        this.close();
    }

    protected String getDuplicateNameErrorMessage(String name) {
        ScriptInfo existingInfo = this.componentProvider.getInfoManager().getExistingScriptInfo(name);
        if (existingInfo != null) {
            ResourceFile sourceFile = existingInfo.getSourceFile();
            if (sourceFile.exists()) {
                return "Duplicate script name.";
            }
            return null;
        }
        ResourceFile directory = this.getDirectory();
        File userChoice = new File(directory.getAbsolutePath(), name);
        if (userChoice.exists()) {
            return "File already exists on disk.";
        }
        return null;
    }

    protected void cancelCallback() {
        this.cancelled = true;
        super.cancelCallback();
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.nameField.getText().startsWith("NewScript")) {
            return;
        }
        try {
            this.scriptFile = GhidraScriptUtil.createNewScript(this.provider, this.getDirectory(), this.componentProvider.getScriptDirectories());
            this.nameField.setText(this.scriptFile.getName());
        }
        catch (IOException ioe) {
            this.scriptFile = null;
            this.nameField.setText("");
        }
    }

    protected ResourceFile getDirectory() {
        if (this.paths.size() == 0 && this.scriptFile != null) {
            return this.scriptFile.getParentFile();
        }
        int index = this.listPanel.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.paths.get(index);
    }

    ResourceFile getFile() {
        ResourceFile directory = this.getDirectory();
        if (directory == null || this.nameField.getText().length() == 0) {
            return null;
        }
        Object name = this.nameField.getText();
        if (!((String)name).toLowerCase().endsWith(this.provider.getExtension())) {
            name = (String)name + this.provider.getExtension();
        }
        return new ResourceFile(directory, (String)name);
    }
}

