/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.processors;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import docking.widgets.OptionDialog;
import docking.widgets.label.GDLabel;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.processors.InstructionInfoProvider;
import ghidra.app.plugin.core.processors.ShowInfoAction;
import ghidra.app.plugin.core.processors.ShowProcessorManualAction;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.BrowserLoader;
import ghidra.util.HTMLUtilities;
import ghidra.util.ManualEntry;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Show Instruction Information", description="This plugin shows the raw instruction at the current location. The instruction is displayed as it was disassembled without any operands replaced by label references or other adornments.")
public class ShowInstructionInfoPlugin
extends ProgramPlugin {
    private static final String CURRENT_INSTRUCTION_PREPEND_STRING = "Current Instruction: ";
    private static final String CURRENT_DATA_PREPEND_STRING = "Current Datatype: ";
    private static final String CURRENT_FUNCTION_APPEND_STRING = " (double-click to go to function entry)";
    private static final int MAX_MANUAL_WRAPPER_FILE_COUNT = 5;
    private DockingAction showInfoAction;
    private InstructionInfoProvider connectedProvider;
    private List<InstructionInfoProvider> disconnectedProviders = new ArrayList<InstructionInfoProvider>();
    private DockingAction showProcessorManualAction;
    private JLabel codeUnitLabel;
    private JPanel codeUnitPanel;
    private JLabel functionLabel;
    private JPanel functionPanel;
    private JLabel addressLabel;
    private JPanel addressPanel;
    private GoToService goToService;
    private ArrayList<File> manualWrapperFiles = new ArrayList();

    public ShowInstructionInfoPlugin(PluginTool tool) {
        super(tool);
        this.createStatusPanels();
        this.createActions();
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
    }

    private void createStatusPanels() {
        this.codeUnitPanel = new JPanel(new BorderLayout());
        this.codeUnitLabel = new GDLabel("                         ");
        this.codeUnitPanel.setPreferredSize(new Dimension(200, this.codeUnitLabel.getPreferredSize().height));
        this.codeUnitLabel.setToolTipText(CURRENT_INSTRUCTION_PREPEND_STRING);
        this.codeUnitPanel.add(this.codeUnitLabel);
        this.codeUnitPanel.setName("Current Instruction");
        this.tool.addStatusComponent((JComponent)this.codeUnitPanel, true, false);
        this.functionPanel = new JPanel(new BorderLayout());
        this.functionLabel = new GDLabel("                   ");
        this.functionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                ShowInstructionInfoPlugin.this.goToSurroundingFunction();
            }
        });
        this.functionPanel.setPreferredSize(new Dimension(130, this.functionLabel.getPreferredSize().height));
        this.functionLabel.setToolTipText("Current Function");
        this.functionPanel.add(this.functionLabel);
        this.functionPanel.setName("Current Function");
        this.tool.addStatusComponent((JComponent)this.functionPanel, true, false);
        this.addressPanel = new JPanel(new BorderLayout());
        this.addressLabel = new GDLabel("          ");
        this.addressPanel.setPreferredSize(new Dimension(95, this.addressLabel.getPreferredSize().height));
        this.addressLabel.setToolTipText("Current Address");
        this.addressPanel.add(this.addressLabel);
        this.addressPanel.setName("Current Address");
        this.tool.addStatusComponent((JComponent)this.addressPanel, true, false);
    }

    private void createActions() {
        this.showInfoAction = new ShowInfoAction(this);
        this.tool.addAction((DockingActionIf)this.showInfoAction);
        this.showProcessorManualAction = new ShowProcessorManualAction(this);
        this.tool.addAction((DockingActionIf)this.showProcessorManualAction);
    }

    void browseInstruction(ListingActionContext context) {
        boolean isDynamic;
        boolean bl = isDynamic = context.getProgram() == this.currentProgram && context.getLocation().equals((Object)this.currentLocation);
        if (isDynamic) {
            this.createOrShowConnectedProvider();
            this.connectedProvider.setProgram(this.currentProgram);
            this.connectedProvider.setAddress(context.getAddress());
        } else {
            InstructionInfoProvider provider = new InstructionInfoProvider(this, false);
            provider.setProgram(context.getProgram());
            provider.setAddress(context.getAddress());
            provider.show();
        }
    }

    private void createOrShowConnectedProvider() {
        if (this.connectedProvider == null) {
            this.connectedProvider = new InstructionInfoProvider(this, true);
            this.connectedProvider.show();
        } else {
            this.connectedProvider.setVisible(true);
        }
    }

    void showProcessorManual(ProgramActionContext context) {
        Language lang = this.currentProgram.getLanguage();
        File wrapperFile = null;
        try {
            URL fileURL = this.getValidUrl(context, lang);
            if (fileURL == null) {
                return;
            }
            wrapperFile = this.writeWrapperFile(fileURL);
            BrowserLoader.display(wrapperFile.toURI().toURL(), fileURL, (ServiceProvider)this.tool);
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Exception Locating Manual", (Object)("Exception locating/displaying processor manual for language: " + lang), (Throwable)e);
        }
    }

    private File writeWrapperFile(URL fileURL) throws IOException {
        File f;
        if (this.manualWrapperFiles.size() < 5) {
            f = File.createTempFile("pdfView", ".html");
            f.deleteOnExit();
        } else {
            f = this.manualWrapperFiles.remove(0);
        }
        this.manualWrapperFiles.add(f);
        try (PrintWriter pw = new PrintWriter(f);){
            pw.println("<!DOCTYPE html>");
            pw.println("<html lang=\"en\">");
            pw.println("<head><meta charset=\"utf-8\"></head>");
            pw.println("<body style=\"height:100vh;\">");
            pw.println("<embed src=\"" + fileURL.toExternalForm() + "\" width=\"100%\" height=\"100%\">");
            pw.println("</body>");
            pw.println("</html>");
        }
        return f;
    }

    URL getValidUrl(ProgramActionContext context, Language language) throws IOException {
        ManualEntry entry = this.locateManualEntry(context, language);
        if (entry == null) {
            return null;
        }
        String filename = entry.getManualPath();
        String missingDescription = entry.getMissingManualDescription();
        if (filename == null || !new File(filename).exists()) {
            String message = this.buildMissingManualMessage(language, filename, missingDescription);
            int choice = OptionDialog.showOptionNoCancelDialog(null, (String)"Missing Processor Manual", (String)message, (String)"Copy \uff06 Close", (String)"Close", (int)1);
            if (choice == 1) {
                Clipboard systemClipboard = GClipboard.getSystemClipboard();
                String copyText = "Missing file: " + filename + "\nDetails: " + missingDescription;
                StringTransferable transferable = new StringTransferable(copyText);
                systemClipboard.setContents((Transferable)transferable, null);
            }
            return null;
        }
        URL url = new File(filename).toURI().toURL();
        String pageNumber = entry.getPageNumber();
        if (pageNumber != null) {
            String fileNameAndPage = url.getFile() + "#page=" + pageNumber;
            url = new URL(url.getProtocol(), null, fileNameAndPage);
        }
        return url;
    }

    ManualEntry locateManualEntry(ProgramActionContext context, Language language) {
        ManualEntry entry;
        String mnemonicString;
        if (language == null || context == null) {
            return null;
        }
        Instruction instruction = null;
        if (context instanceof ListingActionContext) {
            instruction = this.getInstructionForContext((ListingActionContext)context);
        }
        String string = mnemonicString = instruction == null ? null : instruction.getMnemonicString();
        if (mnemonicString != null && !mnemonicString.isEmpty() && mnemonicString.charAt(0) == '_') {
            mnemonicString = mnemonicString.substring(1);
        }
        if ((entry = language.getManualEntry(mnemonicString)) != null) {
            return entry;
        }
        Msg.showError((Object)((Object)this), null, (String)"No Processor Manual", (Object)("Couldn't find processor manual for language: " + language));
        return null;
    }

    private String buildMissingManualMessage(Language language, String filename, String missingDescription) {
        StringBuffer buf = new StringBuffer("<html>");
        buf.append("Ghidra could not find the processor manual for ").append(language);
        buf.append("<br>");
        buf.append("<br>");
        buf.append("Note: The Ghidra distribution does not include some of the processor manuals due to copyright issues. ");
        buf.append("<br>");
        buf.append("Most of these manuals are readily available on-line.");
        buf.append("<br>");
        buf.append("<br>");
        buf.append("To correct this issue, obtain the manual described below and place it at the specified location. ");
        buf.append("<br>");
        buf.append("<br>");
        buf.append("Manual information: ");
        buf.append(HTMLUtilities.bold((String)missingDescription));
        buf.append("<br>");
        buf.append("<br>");
        buf.append("Location to place manual file: ");
        buf.append(HTMLUtilities.bold((String)filename));
        buf.append("<br>");
        buf.append("<br>");
        buf.append("Contact the Ghidra team if you have any problems.");
        return buf.toString();
    }

    public void dispose() {
        if (this.connectedProvider != null) {
            this.connectedProvider.dispose();
        }
        for (InstructionInfoProvider provider : this.disconnectedProviders) {
            provider.dispose();
        }
        this.disconnectedProviders.clear();
        this.tool.removeStatusComponent((JComponent)this.codeUnitPanel);
        this.tool.removeStatusComponent((JComponent)this.addressPanel);
        this.tool.removeStatusComponent((JComponent)this.functionPanel);
        super.dispose();
    }

    public void remove(InstructionInfoProvider provider) {
        if (provider == this.connectedProvider) {
            this.connectedProvider = null;
        } else {
            this.disconnectedProviders.remove((Object)provider);
        }
        provider.dispose();
    }

    JLabel getInstructionLabel() {
        return this.codeUnitLabel;
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        boolean insideFunction;
        if (this.connectedProvider != null) {
            this.connectedProvider.setAddress(loc == null ? null : loc.getAddress());
        }
        if (loc == null || loc.getAddress() == null) {
            this.addressLabel.setText("");
            this.functionLabel.setText("");
            return;
        }
        this.addressLabel.setText(loc.getAddress().toString(false));
        Function currentFunction = this.currentProgram.getListing().getFunctionContaining(this.currentLocation.getAddress());
        boolean bl = insideFunction = currentFunction != null;
        if (insideFunction) {
            this.functionLabel.setText(" " + currentFunction.getName() + " ");
            this.functionLabel.setToolTipText(currentFunction.getName() + CURRENT_FUNCTION_APPEND_STRING);
        } else {
            this.functionLabel.setText("");
            this.functionLabel.setToolTipText("");
        }
        CodeUnit codeUnit = this.getCodeUnitForCurrentProgram();
        if (codeUnit == null) {
            this.codeUnitLabel.setText("");
            this.codeUnitLabel.setToolTipText("");
            return;
        }
        if (codeUnit instanceof Instruction) {
            String representation = codeUnit.toString();
            this.codeUnitLabel.setText(" " + representation + " ");
            this.codeUnitLabel.setToolTipText(CURRENT_INSTRUCTION_PREPEND_STRING + representation);
        } else {
            Data data = (Data)codeUnit;
            String dataTypeName = data.getDataType().getName();
            int size = data.getLength();
            String displayText = dataTypeName + "  (" + size + ")";
            String toolTipText = CURRENT_DATA_PREPEND_STRING + dataTypeName + "  Size = " + size;
            this.codeUnitLabel.setText(displayText);
            this.codeUnitLabel.setToolTipText(toolTipText);
        }
    }

    @Override
    protected void programActivated(Program program) {
        if (this.connectedProvider != null) {
            this.connectedProvider.setProgram(program);
        }
    }

    @Override
    protected void programClosed(Program program) {
        for (InstructionInfoProvider provider : new ArrayList<InstructionInfoProvider>(this.disconnectedProviders)) {
            if (provider.getProgram() != program) continue;
            this.remove(provider);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        this.codeUnitLabel.setText("");
        this.codeUnitLabel.setToolTipText("");
        if (this.connectedProvider != null) {
            this.connectedProvider.setProgram(null);
        }
    }

    Instruction getInstructionForContext(ListingActionContext context) {
        Address addr = context.getAddress();
        if (addr == null) {
            return null;
        }
        Program program = context.getProgram();
        Listing listing = program.getListing();
        return listing.getInstructionContaining(addr);
    }

    private CodeUnit getCodeUnitForCurrentProgram() {
        Address addr = this.currentLocation.getAddress();
        if (addr == null) {
            return null;
        }
        Listing listing = this.currentProgram.getListing();
        return listing.getCodeUnitContaining(addr);
    }

    void goToSurroundingFunction() {
        if (this.goToService == null || this.currentProgram == null) {
            return;
        }
        Function currentFunction = this.currentProgram.getListing().getFunctionContaining(this.currentLocation.getAddress());
        if (currentFunction != null) {
            this.goToService.goTo((ProgramLocation)new FunctionSignatureFieldLocation(this.currentProgram, currentFunction.getEntryPoint(), null, 0, currentFunction.getPrototypeString(false, false)));
        }
    }

    void dynamicStateChanged(InstructionInfoProvider provider, boolean isDynamic) {
        if (provider == this.connectedProvider && !isDynamic) {
            this.disconnectedProviders.add(provider);
            this.connectedProvider = null;
        } else if (provider != this.connectedProvider && isDynamic) {
            if (this.connectedProvider != null) {
                this.connectedProvider.setNonDynamic();
            }
            this.disconnectedProviders.remove((Object)provider);
            this.connectedProvider = provider;
            this.connectedProvider.setProgram(this.currentProgram);
            Address address = this.currentLocation == null ? null : this.currentLocation.getAddress();
            this.connectedProvider.setAddress(address);
        }
    }
}

