/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import javax.swing.event.ChangeListener;

abstract class ExpandBlockModel
implements DomainObjectListener {
    protected PluginTool tool;
    protected Program program;
    protected Address startAddr;
    protected Address endAddr;
    protected Address blockStart;
    protected long length;
    protected MemoryBlock block;
    protected String message;
    protected ChangeListener listener;

    ExpandBlockModel(PluginTool tool, Program program) {
        this.tool = tool;
        this.program = program;
        program.addListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!ev.containsEvent(4)) {
            return;
        }
        if (this.blockStart == null) {
            return;
        }
        MemoryBlock updatedBlock = this.program.getMemory().getBlock(this.blockStart);
        this.initialize(updatedBlock);
    }

    void initialize(MemoryBlock newBlock) {
        this.block = newBlock;
        this.length = newBlock.getSize();
        this.startAddr = newBlock.getStart();
        this.endAddr = newBlock.getEnd();
        this.blockStart = this.startAddr;
        this.message = "";
        this.listener.stateChanged(null);
    }

    void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    String getMessage() {
        return this.message;
    }

    Address getStartAddress() {
        return this.startAddr;
    }

    Address getEndAddress() {
        return this.endAddr;
    }

    long getLength() {
        return this.length;
    }

    abstract void setStartAddress(Address var1);

    abstract void setEndAddress(Address var1);

    abstract void setLength(long var1);

    abstract boolean execute();

    protected boolean expandBlock() {
        ExpandBlockCmd cmd = new ExpandBlockCmd(this.block);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.message = cmd.getStatusMsg();
            this.tool.setStatusInfo(this.message);
            return false;
        }
        return true;
    }

    boolean isValidLength() {
        long blockSize = this.block.getSize();
        if (this.length <= blockSize) {
            this.message = "Block size must be greater than " + Long.toHexString(blockSize);
            return false;
        }
        if (this.length < 0L || this.length > Integer.MAX_VALUE) {
            this.message = "Expanded block is too large";
            return false;
        }
        return true;
    }

    void dispose() {
        this.tool = null;
        this.program.removeListener((DomainObjectListener)this);
        this.program = null;
    }

    private class ExpandBlockCmd
    implements Command {
        private String msg;
        private MemoryBlock expandBlock;

        ExpandBlockCmd(MemoryBlock block) {
            this.expandBlock = block;
        }

        public boolean applyTo(DomainObject obj) {
            Program prog = (Program)obj;
            Memory memory = prog.getMemory();
            try {
                String blockName = this.expandBlock.getName();
                MemoryBlock newBlock = memory.createBlock(this.expandBlock, this.expandBlock.getName() + ".exp", ExpandBlockModel.this.startAddr, ExpandBlockModel.this.length);
                MemoryBlock b = memory.join(this.expandBlock, newBlock);
                if (!b.getName().equals(blockName)) {
                    b.setName(blockName);
                }
                return true;
            }
            catch (Exception e) {
                this.msg = e.getMessage();
                if (this.msg == null) {
                    this.msg = "Error expanding block: " + e;
                }
                return false;
            }
        }

        public String getName() {
            return "Expand Block";
        }

        public String getStatusMsg() {
            return this.msg;
        }
    }
}

