/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.help;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Displays list of installed processor modules", description="This plugin provides a Help action that displays a list of installed processor modules")
public class ProcessorListPlugin
extends Plugin
implements ApplicationLevelPlugin {
    private DockingAction processorListAction;
    private ProcessorListDialogProvider dialogProvider;

    public ProcessorListPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.setupActions();
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.processorListAction);
        this.processorListAction.dispose();
        if (this.dialogProvider != null) {
            this.dialogProvider.dispose();
        }
        super.dispose();
    }

    private void setupActions() {
        this.processorListAction = new DockingAction("Installed Processors", this.getName()){

            public void actionPerformed(ActionContext context) {
                ProcessorListPlugin.this.showProcessorList();
            }
        };
        this.processorListAction.setEnabled(true);
        this.processorListAction.setMenuBarData(new MenuData(new String[]{"&Help", this.processorListAction.getName()}, null, "AAAZ"));
        this.processorListAction.setHelpLocation(new HelpLocation("About", "ProcessorList"));
        this.processorListAction.setDescription(this.getPluginDescription().getDescription());
        this.tool.addAction((DockingActionIf)this.processorListAction);
    }

    private void dialogClosed() {
        this.dialogProvider = null;
    }

    private void showProcessorList() {
        if (this.dialogProvider == null) {
            this.dialogProvider = new ProcessorListDialogProvider();
        }
        this.tool.showDialog((DialogComponentProvider)this.dialogProvider);
    }

    private void copy(boolean asHtml) {
        Clipboard systemClipboard = GClipboard.getSystemClipboard();
        StringTransferable transferable = new StringTransferable(this.getProcessorList(asHtml));
        systemClipboard.setContents((Transferable)transferable, null);
    }

    private Set<Processor> getProcessors() {
        TreeSet<Processor> processors = new TreeSet<Processor>();
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        for (LanguageDescription languageDescription : languageService.getLanguageDescriptions(true)) {
            processors.add(languageDescription.getProcessor());
        }
        return processors;
    }

    private String getProcessorList(boolean asHtml) {
        StringBuilder strBuilder = new StringBuilder();
        if (asHtml) {
            strBuilder.append("<html><BODY>\n");
            strBuilder.append("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n<tr>");
        }
        Set<Processor> processors = this.getProcessors();
        int itemsPerColum = (processors.size() + 2) / 3;
        int colCnt = 0;
        for (Processor processor : processors) {
            if (asHtml) {
                if (colCnt % itemsPerColum == 0) {
                    if (colCnt != 0) {
                        strBuilder.append("</ul>\n</td>");
                    }
                    strBuilder.append("<td width=\"33%\">\n<ul>");
                }
                strBuilder.append("<li>");
            }
            ++colCnt;
            strBuilder.append(processor.toString());
            if (asHtml) {
                strBuilder.append("</li>");
            }
            strBuilder.append("\n");
        }
        if (asHtml) {
            strBuilder.append("</ul>\n</td></tr>\n</table>");
            strBuilder.append("</BODY></html>");
        }
        return strBuilder.toString();
    }

    private class ProcessorListDialogProvider
    extends ReusableDialogComponentProvider {
        ProcessorListDialogProvider() {
            super("Installed Processor Modules", false, false, true, false);
            ProcessorListTableProvider tableProvider = new ProcessorListTableProvider(ProcessorListPlugin.this.tool, ProcessorListPlugin.this.getName());
            this.setRememberLocation(true);
            this.addWorkPanel(tableProvider.getComponent());
            this.setHelpLocation(new HelpLocation("About", "ProcessorList"));
            if (SystemUtilities.isInDevelopmentMode()) {
                JButton copyButton = new JButton("Copy");
                copyButton.addActionListener(e -> ProcessorListPlugin.this.copy(false));
                this.addButton(copyButton);
                JButton copyHtmlButton = new JButton("Copy as HTML");
                copyHtmlButton.addActionListener(e -> ProcessorListPlugin.this.copy(true));
                this.addButton(copyHtmlButton);
            }
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(e -> this.close());
            this.addButton(closeButton);
        }

        protected void dialogClosed() {
            super.dialogClosed();
            ProcessorListPlugin.this.dialogClosed();
        }
    }

    public class ProcessorListTableModel
    extends AbstractSortedTableModel<Processor> {
        private static final int PROCESSOR_COL = 0;
        private List<Processor> processors;

        public ProcessorListTableModel(List<Processor> processors) {
            this.processors = processors;
        }

        public Object getColumnValueForRow(Processor p, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return p.toString();
                }
            }
            return null;
        }

        public String getName() {
            return "Processors";
        }

        public List<Processor> getModelData() {
            return this.processors;
        }

        public boolean isSortable(int columnIndex) {
            return false;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this.processors.size();
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Processor";
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
            }
            return Object.class;
        }
    }

    public class ProcessorListTableProvider
    extends ComponentProviderAdapter {
        GTable table;
        private ProcessorListTableModel processorTableModel;
        private JScrollPane scrollPane;

        public ProcessorListTableProvider(PluginTool tool, String owner) {
            super(tool, "Processor Table", owner);
            this.buildTable();
        }

        public JComponent getComponent() {
            return this.scrollPane;
        }

        private void buildTable() {
            TreeSet<Processor> processors = new TreeSet<Processor>();
            LanguageService languageService = DefaultLanguageService.getLanguageService();
            for (LanguageDescription languageDescription : languageService.getLanguageDescriptions(true)) {
                processors.add(languageDescription.getProcessor());
            }
            this.processorTableModel = new ProcessorListTableModel(new ArrayList<Processor>(processors));
            this.table = new GTable((TableModel)((Object)this.processorTableModel));
            this.scrollPane = new JScrollPane((Component)this.table);
            this.table.getSelectionManager().setSelectionMode(0);
        }
    }
}

