/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.action.DockingActionIf;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderManager;
import ghidra.app.plugin.core.functioncompare.actions.CompareFunctionsFromListingAction;
import ghidra.app.services.FunctionComparisonService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.Swing;
import java.util.Set;
import java.util.function.Supplier;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Difference", shortDescription="Compare Functions", description="Allows users to compare two or more functions", servicesProvided={FunctionComparisonService.class}, eventsConsumed={ProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class})
public class FunctionComparisonPlugin
extends ProgramPlugin
implements DomainObjectListener,
FunctionComparisonService {
    static final String MENU_PULLRIGHT = "CompareFunctions";
    static final String POPUP_MENU_GROUP = "CompareFunction";
    private FunctionComparisonProviderManager functionComparisonManager = new FunctionComparisonProviderManager(this);

    public FunctionComparisonPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        CompareFunctionsFromListingAction compareFunctionsAction = new CompareFunctionsFromListingAction(this.tool, this.getName());
        this.tool.addAction((DockingActionIf)compareFunctionsAction);
    }

    public void dispose() {
        this.functionComparisonManager.dispose();
    }

    @Override
    protected void programOpened(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    @Override
    protected void programClosed(Program program) {
        this.functionComparisonManager.closeProviders(program);
        program.removeListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        block4: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            int eventType = doRecord.getEventType();
            switch (eventType) {
                case 4: {
                    this.functionComparisonManager.domainObjectRestored(ev);
                    continue block4;
                }
                case 151: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    if (function == null) continue block4;
                    this.removeFunction(function);
                }
            }
        }
    }

    private void runOnSwingNonBlocking(Runnable r) {
        Swing.runIfSwingOrRunLater((Runnable)r);
    }

    private FunctionComparisonProvider getFromSwingBlocking(Supplier<FunctionComparisonProvider> comparer) {
        if (Swing.isSwingThread()) {
            return comparer.get();
        }
        return (FunctionComparisonProvider)Swing.runNow(comparer);
    }

    void providerClosed(FunctionComparisonProvider provider) {
        this.functionComparisonManager.providerClosed(provider);
    }

    @Override
    public void removeFunction(Function function) {
        this.runOnSwingNonBlocking(() -> this.functionComparisonManager.removeFunction(function));
    }

    @Override
    public void removeFunction(Function function, FunctionComparisonProvider provider) {
        this.runOnSwingNonBlocking(() -> this.functionComparisonManager.removeFunction(function, provider));
    }

    @Override
    public FunctionComparisonProvider createFunctionComparisonProvider() {
        return this.getFromSwingBlocking(() -> this.functionComparisonManager.createProvider());
    }

    @Override
    public FunctionComparisonProvider compareFunctions(Function source, Function target) {
        return this.getFromSwingBlocking(() -> this.functionComparisonManager.compareFunctions(source, target));
    }

    @Override
    public FunctionComparisonProvider compareFunctions(Set<Function> functions) {
        return this.getFromSwingBlocking(() -> this.functionComparisonManager.compareFunctions(functions));
    }

    @Override
    public void compareFunctions(Set<Function> functions, FunctionComparisonProvider provider) {
        this.runOnSwingNonBlocking(() -> this.functionComparisonManager.compareFunctions(functions, provider));
    }

    @Override
    public void compareFunctions(Function source, Function target, FunctionComparisonProvider provider) {
        this.runOnSwingNonBlocking(() -> this.functionComparisonManager.compareFunctions(source, target, provider));
    }
}

