/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.tabbedpane.DockingTabRenderer;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonData;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FunctionComparisonPanel
extends JPanel
implements ChangeListener {
    private FunctionComparisonData leftComparisonData;
    private FunctionComparisonData rightComparisonData;
    private static final String DEFAULT_CODE_COMPARISON_VIEW = "Listing View";
    private static final String COMPARISON_VIEW_DISPLAYED = "COMPARISON_VIEW_DISPLAYED";
    private static final String CODE_COMPARISON_LOCK_SCROLLING_TOGETHER = "CODE_COMPARISON_LOCK_SCROLLING_TOGETHER";
    private static final HelpService help = Help.getHelpService();
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon SYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.lock");
    private static final Icon UNSYNC_SCROLLING_ICON = new GIcon("icon.plugin.functioncompare.scroll.unlock");
    private static final String SCROLLING_GROUP = "A9_SCROLLING";
    private static final String DUAL_SCROLLING_ACTION_GROUP = "DualScrolling";
    private static final String DUAL_SCROLLING_HELP_TOPIC = "FunctionComparison";
    private JTabbedPane tabbedPane;
    private Map<String, JComponent> tabNameToComponentMap;
    protected PluginTool tool;
    protected ComponentProviderAdapter provider;
    private List<CodeComparisonPanel<? extends FieldPanelCoordinator>> codeComparisonPanels;
    private ToggleScrollLockAction toggleScrollLockAction;
    private boolean syncScrolling = false;

    public FunctionComparisonPanel(ComponentProviderAdapter provider, PluginTool tool, Function leftFunction, Function rightFunction) {
        this.provider = provider;
        this.tool = tool;
        this.leftComparisonData = new FunctionComparisonData();
        this.rightComparisonData = new FunctionComparisonData();
        this.leftComparisonData.setFunction(leftFunction);
        this.rightComparisonData.setFunction(rightFunction);
        this.codeComparisonPanels = this.getCodeComparisonPanels();
        this.tabNameToComponentMap = new HashMap<String, JComponent>();
        this.createMainPanel();
        this.createActions();
        this.setScrollingSyncState(true);
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    public void loadFunctions(Function leftFunction, Function rightFunction) {
        this.leftComparisonData.setFunction(leftFunction);
        this.rightComparisonData.setFunction(rightFunction);
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadFunctions(this.leftComparisonData.getFunction(), this.rightComparisonData.getFunction());
        }
    }

    public void loadData(Data leftData, Data rightData) {
        this.leftComparisonData.setData(leftData);
        this.rightComparisonData.setData(rightData);
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadData(this.leftComparisonData.getData(), this.rightComparisonData.getData());
        }
    }

    public void loadAddresses(Program leftProgram, Program rightProgram, AddressSetView leftAddresses, AddressSetView rightAddresses) {
        this.leftComparisonData.setAddressSet(leftAddresses);
        this.rightComparisonData.setAddressSet(rightAddresses);
        this.leftComparisonData.setProgram(leftProgram);
        this.rightComparisonData.setProgram(rightProgram);
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadAddresses(this.leftComparisonData.getProgram(), this.rightComparisonData.getProgram(), this.leftComparisonData.getAddressSet(), this.rightComparisonData.getAddressSet());
        }
    }

    public DockingAction[] getActions() {
        DockingAction[] actions = new DockingAction[]{this.toggleScrollLockAction};
        return actions;
    }

    public String getDescription() {
        Function leftFunc = this.leftComparisonData.getFunction();
        Function rightFunc = this.rightComparisonData.getFunction();
        Data leftData = this.leftComparisonData.getData();
        Data rightData = this.rightComparisonData.getData();
        if (leftFunc != null && rightFunc != null) {
            return leftFunc.getName(true) + " & " + rightFunc.getName(true);
        }
        if (leftData != null && rightData != null) {
            return leftData.getDataType().getName() + " & " + rightData.getDataType().getName();
        }
        return "Nothing selected";
    }

    public void clear() {
        this.leftComparisonData.clear();
        this.rightComparisonData.clear();
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadAddresses(null, null, null, null);
        }
    }

    public boolean isEmpty() {
        return this.leftComparisonData.isEmpty() || this.rightComparisonData.isEmpty();
    }

    public ListingCodeComparisonPanel getDualListingPanel() {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            JComponent component = codeComparisonPanel.getComponent();
            if (!(component instanceof ListingCodeComparisonPanel)) continue;
            return (ListingCodeComparisonPanel)component;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabChanged();
    }

    public void reload() {
    }

    public boolean setCurrentTabbedComponent(String name) {
        JComponent component = this.tabNameToComponentMap.get(name);
        if (component != null) {
            if (this.tabbedPane.getSelectedComponent() == component) {
                this.tabChanged();
            }
            this.tabbedPane.setSelectedComponent(component);
        }
        return component != null;
    }

    public String getCurrentComponentName() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            return this.tabbedPane.getTitleAt(selectedIndex);
        }
        return null;
    }

    int getNumberOfTabbedComponents() {
        return this.tabNameToComponentMap.size();
    }

    public void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        this.tabbedPane.removeAll();
        this.setVisible(false);
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.dispose();
        }
    }

    private void createMainPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.loadFunctions(this.leftComparisonData.getFunction(), this.rightComparisonData.getFunction());
            JComponent component = codeComparisonPanel.getComponent();
            this.tabbedPane.add(codeComparisonPanel.getTitle(), component);
            this.tabNameToComponentMap.put(codeComparisonPanel.getTitle(), component);
        }
    }

    private void tabChanged() {
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel == null) {
            return;
        }
        if (this.leftComparisonData.isFunction() || this.rightComparisonData.isFunction()) {
            activePanel.loadFunctions(this.leftComparisonData.getFunction(), this.rightComparisonData.getFunction());
        } else if (this.leftComparisonData.isData() || this.rightComparisonData.isData()) {
            activePanel.loadData(this.leftComparisonData.getData(), this.rightComparisonData.getData());
        } else {
            activePanel.loadAddresses(this.leftComparisonData.getProgram(), this.rightComparisonData.getProgram(), this.leftComparisonData.getAddressSet(), this.rightComparisonData.getAddressSet());
        }
    }

    private CodeComparisonPanel<? extends FieldPanelCoordinator> getActiveComparisonPanel() {
        JComponent c = (JComponent)this.tabbedPane.getSelectedComponent();
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            JComponent component = codeComparisonPanel.getComponent();
            if (c != component) continue;
            return codeComparisonPanel;
        }
        return null;
    }

    public FunctionComparisonData getLeftComparisonData() {
        return this.leftComparisonData;
    }

    public FunctionComparisonData getRightComparisonData() {
        return this.rightComparisonData;
    }

    public Function getLeftFunction() {
        return this.leftComparisonData.getFunction();
    }

    protected void setLeftFunction(Function function) {
        this.loadFunctions(function, this.rightComparisonData.getFunction());
    }

    public Function getRightFunction() {
        return this.rightComparisonData.getFunction();
    }

    protected void setRightFunction(Function function) {
        this.loadFunctions(this.leftComparisonData.getFunction(), function);
    }

    public Data getLeftData() {
        return this.leftComparisonData.getData();
    }

    public Data getRightData() {
        return this.rightComparisonData.getData();
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.setMouseNavigationEnabled(enabled);
        }
    }

    public void readConfigState(String prefix, SaveState saveState) {
        String currentTabView = saveState.getString(prefix + COMPARISON_VIEW_DISPLAYED, DEFAULT_CODE_COMPARISON_VIEW);
        this.setCurrentTabbedComponent(currentTabView);
        this.setScrollingSyncState(saveState.getBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, true));
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.readConfigState(prefix, saveState);
        }
    }

    public void writeConfigState(String prefix, SaveState saveState) {
        String currentComponentName = this.getCurrentComponentName();
        if (currentComponentName != null) {
            saveState.putString(prefix + COMPARISON_VIEW_DISPLAYED, this.getCurrentComponentName());
        }
        saveState.putBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, this.isScrollingSynced());
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.writeConfigState(prefix, saveState);
        }
    }

    public DockingAction[] getCodeComparisonActions() {
        ArrayList<DockingAction> dockingActionList = new ArrayList<DockingAction>();
        DockingAction[] functionComparisonActions = this.getActions();
        for (DockingAction dockingAction : functionComparisonActions) {
            dockingActionList.add(dockingAction);
        }
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            DockingAction[] actions;
            for (DockingAction dockingAction : actions = codeComparisonPanel.getActions()) {
                dockingActionList.add(dockingAction);
            }
        }
        return dockingActionList.toArray(new DockingAction[dockingActionList.size()]);
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        Component[] components;
        for (Component component : components = this.tabbedPane.getComponents()) {
            if (!(component instanceof CodeComparisonPanel)) continue;
            ((CodeComparisonPanel)component).setTitlePrefixes(leftTitlePrefix, rightTitlePrefix);
        }
    }

    public ActionContext getActionContext(MouseEvent event, ComponentProvider componentProvider) {
        Object source = event != null ? event.getSource() : null;
        Component sourceComponent = source instanceof Component ? (Component)source : null;
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null && dualListingPanel.isAncestorOf(sourceComponent)) {
            return dualListingPanel.getActionContext(event, componentProvider);
        }
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getFocusedComparisonPanel();
        if (activePanel != null) {
            return activePanel.getActionContext(componentProvider, event);
        }
        return null;
    }

    private CodeComparisonPanel<? extends FieldPanelCoordinator> getFocusedComparisonPanel() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused != null) {
            for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
                JComponent component = codeComparisonPanel.getComponent();
                boolean isParent = SwingUtilities.isDescendingFrom(focused, component);
                if (!isParent) continue;
                return codeComparisonPanel;
            }
        }
        return null;
    }

    public final boolean isScrollingSynced() {
        return this.syncScrolling;
    }

    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        this.toggleScrollLockAction.setSelected(syncScrolling);
        this.toggleScrollLockAction.setToolBarData(new ToolBarData(syncScrolling ? SYNC_SCROLLING_ICON : UNSYNC_SCROLLING_ICON, SCROLLING_GROUP));
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.setScrollingSyncState(syncScrolling);
        }
        this.syncScrolling = syncScrolling;
    }

    public CodeComparisonPanel<? extends FieldPanelCoordinator> getDisplayedPanel() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        Component component = this.tabbedPane.getComponentAt(selectedIndex);
        return (CodeComparisonPanel)component;
    }

    public void updateActionEnablement() {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.updateActionEnablement();
        }
    }

    CodeComparisonPanel<? extends FieldPanelCoordinator> getCurrentComponent() {
        return (CodeComparisonPanel)this.tabbedPane.getSelectedComponent();
    }

    boolean isTabClick(MouseEvent event) {
        Component component = event.getComponent();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            if (!SwingUtilities.isDescendingFrom(component, (Component)renderer)) continue;
            return true;
        }
        return false;
    }

    private void createActions() {
        this.toggleScrollLockAction = new ToggleScrollLockAction();
    }

    public List<CodeComparisonPanel<? extends FieldPanelCoordinator>> getComparisonPanels() {
        return this.codeComparisonPanels;
    }

    private List<CodeComparisonPanel<? extends FieldPanelCoordinator>> getCodeComparisonPanels() {
        if (this.codeComparisonPanels == null) {
            this.codeComparisonPanels = this.createAllPossibleCodeComparisonPanels();
            this.codeComparisonPanels.sort((p1, p2) -> p1.getTitle().compareTo(p2.getTitle()));
        }
        return this.codeComparisonPanels;
    }

    private ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>> createAllPossibleCodeComparisonPanels() {
        ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>> instances = new ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>>();
        List classes = ClassSearcher.getClasses(CodeComparisonPanel.class);
        for (Class panelClass : classes) {
            try {
                Constructor constructor = panelClass.getConstructor(String.class, PluginTool.class);
                CodeComparisonPanel panel = (CodeComparisonPanel)constructor.newInstance(this.provider.getName(), this.tool);
                instances.add(panel);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Error Creating Extension Point", (Object)("Error creating class " + panelClass.getName() + " when creating extension points for " + CodeComparisonPanel.class.getName()), (Throwable)e);
            }
        }
        return instances;
    }

    private class ToggleScrollLockAction
    extends ToggleDockingAction {
        ToggleScrollLockAction() {
            super("Synchronize Scrolling of Dual View", FunctionComparisonPanel.this.provider.getName());
            this.setDescription("Lock/Unlock Synchronized Scrolling of Dual View");
            this.setToolBarData(new ToolBarData(UNSYNC_SCROLLING_ICON, FunctionComparisonPanel.SCROLLING_GROUP));
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Synchronize Scrolling"}, FunctionComparisonPanel.DUAL_SCROLLING_ACTION_GROUP);
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Synchronize Scrolling of Dual View"));
        }

        public void actionPerformed(ActionContext context) {
            FunctionComparisonPanel.this.setScrollingSyncState(this.isSelected());
        }
    }
}

