/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.cmd.function.AddFunctionTagCmd;
import ghidra.app.cmd.function.CreateFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagProvider;
import ghidra.app.plugin.core.function.tags.InMemoryFunctionTag;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import java.util.Set;

public class SourceTagsPanel
extends TagListPanel {
    public SourceTagsPanel(FunctionTagProvider provider, PluginTool tool, String title) {
        super(provider, tool, title);
        this.table.setDisabled(true);
    }

    public void addSelectedTags() {
        if (this.function == null) {
            return;
        }
        Set<FunctionTag> selectedTags = this.getSelectedTags();
        for (FunctionTag tag : selectedTags) {
            Object cmd;
            if (tag instanceof InMemoryFunctionTag) {
                cmd = new CreateFunctionTagCmd(tag.getName(), tag.getComment());
                this.tool.execute((Command)cmd, (DomainObject)this.program);
            }
            cmd = new AddFunctionTagCmd(tag.getName(), this.function.getEntryPoint());
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }

    @Override
    public void refresh(Function newFunction) {
        this.model.clear();
        this.function = newFunction;
        this.table.setFunction(this.function);
        this.model.reload();
    }

    @Override
    protected Set<FunctionTag> backgroundLoadTags() {
        return this.provider.backgroundLoadTags();
    }

    public boolean isSelectionEnabled() {
        Set<FunctionTag> selectedTags = this.getSelectedTags();
        Set<FunctionTag> assignedTags = this.getAssignedTags(this.function);
        return !assignedTags.containsAll(selectedTags);
    }
}

