/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.ActionContext;
import docking.ComponentProvider;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datawindow.DataRowObject;
import ghidra.app.plugin.core.datawindow.DataTableModel;
import ghidra.app.plugin.core.datawindow.DataWindowContext;
import ghidra.app.plugin.core.datawindow.DataWindowPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

class DataWindowProvider
extends ComponentProviderAdapter {
    public static final Icon ICON = new GIcon("icon.plugin.datawindow.provider");
    private DataWindowPlugin plugin;
    private GhidraThreadedTablePanel<DataRowObject> threadedTablePanel;
    private GhidraTableFilterPanel<DataRowObject> filterPanel;
    private JComponent mainPanel;
    private GhidraTable dataTable;
    private DataTableModel dataModel;

    DataWindowProvider(DataWindowPlugin plugin) {
        super(plugin.getTool(), "Data Window", plugin.getName());
        this.setTitle("Defined Data");
        this.plugin = plugin;
        this.mainPanel = this.createWorkPanel();
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.setIcon(ICON);
    }

    public void componentHidden() {
        this.dataModel.reload(null);
    }

    public void componentShown() {
        this.plugin.dataWindowShown();
        this.dataModel.reload(this.plugin.getProgram());
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new DataWindowContext(this, this.dataTable);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.plugin.getName());
    }

    void programOpened(Program program) {
        if (this.isVisible()) {
            this.dataModel.reload(program);
        }
    }

    void programClosed() {
        if (this.isVisible()) {
            this.dataModel.reload(null);
        }
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.threadedTablePanel.dispose();
        this.filterPanel.dispose();
    }

    private JComponent createWorkPanel() {
        this.dataModel = new DataTableModel(this.plugin);
        this.threadedTablePanel = new GhidraThreadedTablePanel<DataRowObject>(this.dataModel, 1000);
        this.dataTable = this.threadedTablePanel.getTable();
        this.dataTable.setName("DataTable");
        this.dataTable.setAutoLookupColumn(0);
        this.dataTable.setAutoResizeMode(2);
        this.dataTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.dataTable.setRowSelectionAllowed(true);
        this.dataTable.setSelectionMode(2);
        this.dataTable.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.dataModel.addTableModelListener(e -> {
            int rowCount = this.dataModel.getRowCount();
            int unfilteredCount = this.dataModel.getUnfilteredRowCount();
            StringBuilder buffy = new StringBuilder();
            buffy.append(rowCount).append(" items");
            if (rowCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(" )");
            }
            this.setSubTitle(buffy.toString());
        });
        this.dataTable.installNavigation((ServiceProvider)this.tool);
        JTableHeader dataHeader = this.dataTable.getTableHeader();
        dataHeader.setUpdateTableInRealTime(true);
        this.setDataTableRenderer();
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.dataTable), this.dataModel);
        this.dataTable.getModel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.threadedTablePanel), "Center");
        panel.add((Component)((Object)this.filterPanel), "South");
        return panel;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    ProgramSelection selectData() {
        return this.dataTable.getProgramSelection();
    }

    private void setDataTableRenderer() {
        this.dataTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.dataTable.getColumnModel().getColumn(3).setPreferredWidth(30);
    }

    void reload() {
        if (this.isVisible()) {
            this.dataModel.reload(this.plugin.getProgram());
        }
    }

    void dataAdded(Address loc) {
        if (this.isVisible()) {
            this.dataModel.dataAdded(loc);
        }
    }

    public GhidraTable getTable() {
        return this.dataTable;
    }
}

