/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.cmd.data.RenameDataFieldCmd;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

class RenameDataFieldDialog
extends DialogComponentProvider {
    private GhidraComboBox<?> recentChoices;
    private DataTypeComponent component;
    private DataPlugin plugin;
    private Program program;

    RenameDataFieldDialog(DataPlugin plugin) {
        super("Rename Data Field", true, false, true, false);
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Rename_Data_Field"));
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
    }

    public void setDataComponent(Program program, DataTypeComponent component, String name) {
        this.component = component;
        this.program = program;
        this.recentChoices.setText(name);
        this.recentChoices.selectAll();
    }

    protected void okCallback() {
        this.close();
        RenameDataFieldCmd cmd = new RenameDataFieldCmd(this.component, this.recentChoices.getText());
        this.plugin.getTool().execute((Command)cmd, (DomainObject)this.program);
        this.program = null;
    }

    protected void cancelCallback() {
        this.program = null;
        this.close();
    }

    private JPanel create() {
        this.recentChoices = new GhidraComboBox();
        this.recentChoices.setEditable(true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder("Data Field Name");
        topPanel.setBorder(border);
        mainPanel.add((Component)topPanel, "North");
        topPanel.add((Component)this.recentChoices, "North");
        this.setFocusComponent((Component)this.recentChoices);
        this.recentChoices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDataFieldDialog.this.okCallback();
            }
        });
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }
}

