/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;

public class ShowComponentPathAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Show Component Path";
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Show the category for the selected component's data type";
    private static String[] POPUP_PATH = new String[]{"Show Component Path"};
    private static String[] MENU_PATH = new String[]{"Show Component Path"};

    public ShowComponentPathAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, MENU_PATH, null);
        this.setDescription(DESCRIPTION);
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        Object message = " ";
        int index = this.model.getMinIndexSelected();
        DataTypeComponent dtc = this.model.getComponent(index);
        if (dtc != null) {
            DataType dt = dtc.getDataType();
            message = dt.getDisplayName() + " is in category \"" + dt.getCategoryPath().getPath() + "\".";
        }
        this.model.setStatus((String)message, false);
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isSingleComponentRowSelection());
    }
}

