/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class MoveDownAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.move.down");
    public static final String ACTION_NAME = "Move Components Down";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Move the selected components down";
    private static final String[] POPUP_PATH = new String[]{"Move Components Down"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(40, 512);

    public MoveDownAction(CompositeEditorProvider provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.moveDown();
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isMoveDownAllowed());
    }
}

