/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.blockmodel;

import docking.options.editor.StringWithChoicesEditor;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.BlockModelServiceListener;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.IsolatedEntrySubModel;
import ghidra.program.model.block.MultEntSubModel;
import ghidra.program.model.block.OverlapCodeSubModel;
import ghidra.program.model.block.PartitionCodeSubModel;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.NotFoundException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.TreeMap;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Provides the block model service", description="This plugin provides registration and distribution of basic-block and subroutine models via the block model service.", servicesProvided={BlockModelService.class})
public class BlockModelServicePlugin
extends ProgramPlugin
implements BlockModelService,
OptionsChangeListener {
    private static final String SUB_OPTION = "Subroutine Block Model";
    private TreeMap<String, BlockModelInfo> basicModelsByName = new TreeMap();
    private TreeMap<String, BlockModelInfo> subroutineModelsByName = new TreeMap();
    private BlockModelInfo activeBasicModel;
    private BlockModelInfo activeSubroutineModel;
    private ToolOptions options;
    private String selectedSubroutineModelName;
    private String preferedSubroutineModeName;
    private boolean modelUpdateInProgress = false;
    private WeakSet<BlockModelServiceListener> listenerList = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private StringWithChoicesEditor editor;

    public BlockModelServicePlugin(PluginTool tool) {
        super(tool);
        BlockModelInfo info = new BlockModelInfo("Simple Block", SimpleBlockModel.class);
        this.basicModelsByName.put("Simple Block", info);
        this.activeBasicModel = info;
        info = new BlockModelInfo("Multiple Entry", MultEntSubModel.class);
        this.subroutineModelsByName.put("Multiple Entry", info);
        this.activeSubroutineModel = info;
        info = new BlockModelInfo("Overlapped Code", OverlapCodeSubModel.class);
        this.subroutineModelsByName.put("Overlapped Code", info);
        info = new BlockModelInfo("Isolated Entry", IsolatedEntrySubModel.class);
        this.subroutineModelsByName.put("Isolated Entry", info);
        info = new BlockModelInfo("Overlapped Code", PartitionCodeSubModel.class);
        this.subroutineModelsByName.put("Partitioned Code", info);
        String[] availableModelNames = this.getAvailableModelNames(2);
        this.selectedSubroutineModelName = availableModelNames[0];
        this.options = tool.getOptions("Tool");
        this.options.registerOption(SUB_OPTION, OptionType.STRING_TYPE, (Object)this.selectedSubroutineModelName, null, "The default subroutine model used when creating call graphs.", () -> {
            this.editor = new StringWithChoicesEditor(availableModelNames);
            return this.editor;
        });
        this.setPreferedModel((Options)this.options);
        this.updateModelOptions();
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions newOptions, String optionName, Object oldValue, Object newValue) {
        if (!this.modelUpdateInProgress && SUB_OPTION.equals(optionName)) {
            this.setPreferedModel((Options)newOptions);
        }
    }

    private void setPreferedModel(Options options) {
        this.preferedSubroutineModeName = options.getString(SUB_OPTION, this.selectedSubroutineModelName);
        if (this.activeSubroutineModel == null || !this.activeSubroutineModel.modelName.equals(this.preferedSubroutineModeName)) {
            this.activeSubroutineModel = this.subroutineModelsByName.get(this.preferedSubroutineModeName);
        }
    }

    private void updateModelOptions() {
        String[] availableModelNames = this.getAvailableModelNames(2);
        try {
            if (this.subroutineModelsByName.containsKey(this.preferedSubroutineModeName)) {
                this.activeSubroutineModel = this.subroutineModelsByName.get(this.preferedSubroutineModeName);
            }
            if (this.activeSubroutineModel != null && this.subroutineModelsByName.containsKey(this.activeSubroutineModel.modelName)) {
                this.selectedSubroutineModelName = this.activeSubroutineModel.modelName;
            } else {
                this.activeSubroutineModel = this.subroutineModelsByName.get(this.selectedSubroutineModelName);
            }
        }
        catch (IllegalArgumentException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        this.modelUpdateInProgress = true;
        try {
            if (this.editor != null) {
                this.editor.setChoices(availableModelNames);
            }
            this.options.setString(SUB_OPTION, this.selectedSubroutineModelName);
        }
        finally {
            this.modelUpdateInProgress = false;
        }
    }

    @Override
    public void registerModel(Class<? extends CodeBlockModel> modelClass, String modelName) {
        if (SubroutineBlockModel.class.isAssignableFrom(modelClass)) {
            if (!this.subroutineModelsByName.containsKey(modelName)) {
                this.subroutineModelsByName.put(modelName, new BlockModelInfo(modelName, modelClass));
                this.updateModelOptions();
                this.fireModelAdded(modelName, 2);
            }
        } else if (!this.basicModelsByName.containsKey(modelName)) {
            this.basicModelsByName.put(modelName, new BlockModelInfo(modelName, modelClass));
            this.fireModelAdded(modelName, 1);
        }
    }

    @Override
    public void unregisterModel(Class<? extends CodeBlockModel> modelClass) {
        if (SubroutineBlockModel.class.isAssignableFrom(modelClass)) {
            BlockModelInfo info = this.findSubroutineModel(modelClass);
            if (info != null) {
                this.subroutineModelsByName.remove(info.modelName);
                this.updateModelOptions();
                this.fireModelRemoved(info.modelName, 2);
            }
        } else {
            BlockModelInfo info = this.findBasicModel(modelClass);
            if (info != null) {
                this.subroutineModelsByName.remove(info.modelName);
                this.updateModelOptions();
                this.fireModelRemoved(info.modelName, 1);
            }
        }
    }

    private BlockModelInfo findSubroutineModel(Class<? extends CodeBlockModel> modelClass) {
        for (BlockModelInfo info : this.subroutineModelsByName.values()) {
            if (info.modelClass != modelClass) continue;
            return info;
        }
        return null;
    }

    private BlockModelInfo findBasicModel(Class<? extends CodeBlockModel> modelClass) {
        for (BlockModelInfo info : this.basicModelsByName.values()) {
            if (info.modelClass != modelClass) continue;
            return info;
        }
        return null;
    }

    @Override
    public CodeBlockModel getActiveBlockModel() {
        if (this.currentProgram == null) {
            return null;
        }
        return this.getModelInstance(this.activeBasicModel.modelClass, this.currentProgram, false);
    }

    @Override
    public CodeBlockModel getActiveBlockModel(boolean includeExternals) {
        if (this.currentProgram == null) {
            return null;
        }
        return this.getModelInstance(this.activeBasicModel.modelClass, this.currentProgram, includeExternals);
    }

    @Override
    public CodeBlockModel getActiveBlockModel(Program program) {
        if (program == null) {
            return null;
        }
        return this.getModelInstance(this.activeBasicModel.modelClass, program, false);
    }

    @Override
    public CodeBlockModel getActiveBlockModel(Program program, boolean includeExternals) {
        if (program == null) {
            return null;
        }
        return this.getModelInstance(this.activeBasicModel.modelClass, program, includeExternals);
    }

    @Override
    public CodeBlockModel getActiveSubroutineModel() {
        if (this.currentProgram == null) {
            return null;
        }
        return this.getModelInstance(this.activeSubroutineModel.modelClass, this.currentProgram, false);
    }

    @Override
    public CodeBlockModel getActiveSubroutineModel(boolean includeExternals) {
        if (this.currentProgram == null) {
            return null;
        }
        return this.getModelInstance(this.activeSubroutineModel.modelClass, this.currentProgram, includeExternals);
    }

    @Override
    public CodeBlockModel getActiveSubroutineModel(Program program) {
        if (program == null) {
            return null;
        }
        return this.getModelInstance(this.activeSubroutineModel.modelClass, program, false);
    }

    @Override
    public CodeBlockModel getActiveSubroutineModel(Program program, boolean includeExternals) {
        if (program == null) {
            return null;
        }
        return this.getModelInstance(this.activeSubroutineModel.modelClass, program, includeExternals);
    }

    @Override
    public String getActiveBlockModelName() {
        return this.activeBasicModel.modelName;
    }

    @Override
    public String getActiveSubroutineModelName() {
        return this.activeSubroutineModel.modelName;
    }

    private CodeBlockModel getModelInstance(Class<? extends CodeBlockModel> modelClass, Program program, boolean includeExternals) {
        try {
            Constructor<? extends CodeBlockModel> c = modelClass.getConstructor(Program.class, Boolean.TYPE);
            return c.newInstance(program, includeExternals);
        }
        catch (Exception c) {
            try {
                Constructor<? extends CodeBlockModel> c2 = modelClass.getConstructor(Program.class);
                return c2.newInstance(program);
            }
            catch (Exception exception) {
                Msg.error((Object)this, (Object)("ERROR! Failed to instantiate model: " + modelClass.getName()));
                return null;
            }
        }
    }

    @Override
    public CodeBlockModel getNewModelByName(String modelName) throws NotFoundException {
        return this.getNewModelByName(modelName, this.currentProgram, false);
    }

    @Override
    public CodeBlockModel getNewModelByName(String modelName, boolean includeExtenernals) throws NotFoundException {
        return this.getNewModelByName(modelName, this.currentProgram, includeExtenernals);
    }

    @Override
    public CodeBlockModel getNewModelByName(String modelName, Program program) throws NotFoundException {
        return this.getNewModelByName(modelName, program, false);
    }

    @Override
    public CodeBlockModel getNewModelByName(String modelName, Program program, boolean includeExternals) throws NotFoundException {
        if (program == null) {
            return null;
        }
        BlockModelInfo info = this.basicModelsByName.get(modelName);
        if (info != null) {
            return this.getModelInstance(info.modelClass, program, includeExternals);
        }
        info = this.subroutineModelsByName.get(modelName);
        if (info != null) {
            return this.getModelInstance(info.modelClass, program, includeExternals);
        }
        throw new NotFoundException("Block model not found: " + modelName);
    }

    @Override
    public String[] getAvailableModelNames(int modelType) {
        TreeMap<String, BlockModelInfo> models = modelType == 1 ? this.basicModelsByName : this.subroutineModelsByName;
        String defaultModelName = modelType == 1 ? "Simple Block" : "Multiple Entry";
        ArrayList<String> list = new ArrayList<String>();
        for (String modelName : models.keySet()) {
            if (modelName.equals(defaultModelName)) {
                list.add(0, modelName);
                continue;
            }
            list.add(modelName);
        }
        String[] modelNames = new String[list.size()];
        list.toArray(modelNames);
        return modelNames;
    }

    @Override
    public void addListener(BlockModelServiceListener listener) {
        this.listenerList.add((Object)listener);
    }

    @Override
    public void removeListener(BlockModelServiceListener listener) {
        this.listenerList.remove((Object)listener);
    }

    private void fireModelAdded(String modelName, int modelType) {
        for (BlockModelServiceListener listener : this.listenerList) {
            listener.modelAdded(modelName, modelType);
        }
    }

    private void fireModelRemoved(String modelName, int modelType) {
        for (BlockModelServiceListener listener : this.listenerList) {
            listener.modelRemoved(modelName, modelType);
        }
    }

    private static class BlockModelInfo {
        String modelName;
        Class<? extends CodeBlockModel> modelClass;

        BlockModelInfo(String modelName, Class<? extends CodeBlockModel> modelClass) {
            this.modelName = modelName;
            this.modelClass = modelClass;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockModelInfo) {
                return this.modelName == ((BlockModelInfo)obj).modelName;
            }
            return false;
        }

        public int hashCode() {
            return this.modelName.hashCode();
        }
    }
}

