/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustBackref;
import ghidra.app.plugin.core.analysis.rust.demangler.RustGenericArgs;
import ghidra.app.plugin.core.analysis.rust.demangler.RustIdentifier;
import ghidra.app.plugin.core.analysis.rust.demangler.RustImplPath;
import ghidra.app.plugin.core.analysis.rust.demangler.RustNamespace;
import ghidra.app.plugin.core.analysis.rust.demangler.RustPathNested;
import ghidra.app.plugin.core.analysis.rust.demangler.RustString;
import ghidra.app.plugin.core.analysis.rust.demangler.RustType;
import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;
import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;

class RustPath
implements SymbolNode {
    SymbolNode child;

    public RustPath(SymbolNode child) {
        this.child = child;
    }

    public RustPath(String child) {
        this.child = new RustString(child);
    }

    public static RustPath parse(Symbol s) {
        int pos = s.pos - 1;
        if (s.nextChar() == 'B') {
            String backref = s.parseBackref();
            int i = Integer.parseInt(backref, 16);
            RustBackref b = new RustBackref(i, s);
            RustPath path = new RustPath(b);
            return path;
        }
        char c = s.popChar();
        if (c == 'C') {
            RustIdentifier identifier = RustIdentifier.parse(s, new RustNamespace("crate"));
            s.backrefAdd(pos, identifier);
            return new RustPath(identifier.toString());
        }
        if (c == 'M') {
            RustImplPath implPath = RustImplPath.parse(s);
            RustType type = RustType.parse(s);
            RustPath path = new RustPath("<" + implPath + "::" + type + ">");
            s.backrefAdd(pos, path);
            return path;
        }
        if (c == 'X') {
            RustImplPath.parse(s);
            RustType type = RustType.parse(s);
            RustPath parent = RustPath.parse(s);
            RustPath path = new RustPath("<" + type + " as " + parent + ">");
            s.backrefAdd(pos, path);
            return path;
        }
        if (c == 'Y') {
            RustType type = RustType.parse(s);
            RustPath parent = RustPath.parse(s);
            RustPath path = new RustPath("<" + type + " as " + parent + ">");
            s.backrefAdd(pos, path);
            return path;
        }
        if (c == 'N') {
            RustNamespace namespace = RustNamespace.parse(s);
            RustPath parent = RustPath.parse(s);
            RustIdentifier id = RustIdentifier.parse(s, namespace);
            RustPathNested nested = new RustPathNested(parent, id);
            RustPath path = new RustPath(nested.toString());
            s.backrefAdd(pos, path);
            return path;
        }
        if (c == 'I') {
            RustPath parent = RustPath.parse(s);
            RustGenericArgs args = RustGenericArgs.parse(s);
            if (args == null) {
                RustPath path = new RustPath(parent);
                s.backrefAdd(pos, path);
                return path;
            }
            RustPath path = new RustPath("" + parent + args);
            s.backrefAdd(pos, path);
            return path;
        }
        if (c == 'B') {
            s.backChar();
            String b = s.parseBackref();
            int i = Integer.parseInt(b, 16);
            RustBackref br = new RustBackref(i, s);
            return new RustPath(br);
        }
        return null;
    }

    public String toString() {
        return this.child.toString();
    }
}

