/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tree;

import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import resources.Icons;

class TreeChangePanel
extends JPanel {
    private JLabel treeNameLabel;
    private JLabel nameLabel;
    private JLabel structureLabel;
    private JPanel namePanel;
    private JPanel structurePanel;
    private JLabel nameIconLabel;
    private JLabel structureIconLabel;
    private static final Icon CHANGED_ICON = new GIcon("icon.plugin.merge.changed");
    private static final Icon NO_CHANGE_ICON = Icons.EMPTY_ICON;
    private static final Color CHANGED_COLOR = GThemeDefaults.Colors.FOREGROUND;
    private static final Color NO_CHANGE_COLOR = GThemeDefaults.Colors.Messages.HINT;

    TreeChangePanel(String title) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.create();
    }

    void setStates(String treeName, boolean nameChanged, boolean structureChanged) {
        this.treeNameLabel.setText(treeName);
        this.nameLabel.setText(nameChanged ? "Name Changed" : "Name Not Changed");
        this.nameLabel.setForeground(nameChanged ? CHANGED_COLOR : NO_CHANGE_COLOR);
        this.namePanel.remove(this.nameIconLabel);
        this.nameIconLabel = new GIconLabel(nameChanged ? CHANGED_ICON : NO_CHANGE_ICON);
        this.namePanel.add((Component)this.nameIconLabel, 0);
        this.structureLabel.setText(structureChanged ? "Structure Changed" : "Structure Not Changed");
        this.structureLabel.setForeground(structureChanged ? CHANGED_COLOR : NO_CHANGE_COLOR);
        this.structurePanel.remove(this.structureIconLabel);
        this.structureIconLabel = new GIconLabel(structureChanged ? CHANGED_ICON : NO_CHANGE_ICON);
        this.structurePanel.add((Component)this.structureIconLabel, 0);
    }

    private void create() {
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.treeNameLabel = new GDLabel("Tree Name");
        Font font = this.treeNameLabel.getFont();
        font = font.deriveFont(1);
        this.treeNameLabel.setFont(font);
        this.nameLabel = new GDLabel("Name Changed");
        this.nameIconLabel = new GIconLabel(CHANGED_ICON);
        this.structureLabel = new GDLabel("Structure Changed");
        this.structureIconLabel = new GIconLabel(CHANGED_ICON);
        this.namePanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        this.namePanel.add(this.nameIconLabel);
        this.namePanel.add(this.nameLabel);
        this.structurePanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        this.structurePanel.add(this.structureIconLabel);
        this.structurePanel.add(this.structureLabel);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(this.namePanel);
        labelPanel.add(this.structurePanel);
        panel.add((Component)this.treeNameLabel, "North");
        panel.add((Component)labelPanel, "Center");
        this.add(panel);
    }
}

