/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import javax.help.UnsupportedOperationException;

public class X86_64DisassembleCommand
extends DisassembleCommand {
    private final boolean size32Mode;

    public X86_64DisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean size32Mode) {
        super(startSet, restrictedSet, true);
        this.size32Mode = size32Mode;
    }

    public X86_64DisassembleCommand(Address start, AddressSetView restrictedSet, boolean size32Mode) {
        super(start, restrictedSet, true);
        this.size32Mode = size32Mode;
    }

    public String getName() {
        return "Disassemble " + (this.size32Mode ? "32" : "64") + "-bit x86";
    }

    @Override
    public void setSeedContext(DisassemblerContextImpl seedContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialContext(RegisterValue initialContextValue) {
        throw new UnsupportedOperationException();
    }

    public static AddressSet alignSet(int alignment, AddressSetView set) throws CancelledException {
        AddressSet result = new AddressSet();
        for (AddressRange range : set) {
            Address max;
            long maxOffset;
            Address min = range.getMinAddress();
            long minOfffset = min.getOffset();
            if (minOfffset != min.getOffset()) {
                min = min.getNewAddress(minOfffset);
            }
            if ((maxOffset = (max = range.getMaxAddress()).getOffset()) < minOfffset) continue;
            if (maxOffset != max.getOffset()) {
                max = max.getNewAddress(maxOffset);
            }
            result.addRange(min, max);
        }
        return result;
    }

    @Override
    public synchronized boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        ProgramContext context = program.getProgramContext();
        Register longModeReg = context.getRegister("longMode");
        if (longModeReg == null) {
            this.languageError = "Requires x86:LE:64:default";
            return false;
        }
        RegisterValue ctx = new RegisterValue(context.getBaseContextRegister()).assign(longModeReg, this.size32Mode ? BigInteger.ZERO : BigInteger.ONE);
        super.setInitialContext(ctx);
        try {
            if (this.startSet != null) {
                AddressSet alignedSet = X86_64DisassembleCommand.alignSet(1, this.startSet);
                if (alignedSet.isEmpty()) {
                    this.unalignedStart = true;
                    return false;
                }
                this.startSet = program.getListing().getUndefinedRanges((AddressSetView)alignedSet, true, monitor);
                if (this.startSet.isEmpty()) {
                    return true;
                }
            }
        }
        catch (CancelledException e) {
            return true;
        }
        return this.doDisassembly(monitor, program, 1);
    }
}

