/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;

public class CreateStringCmd
implements Command {
    private final Address addr;
    private final AbstractStringDataType stringDataType;
    private int length = -1;
    private DataUtilities.ClearDataMode clearMode;
    private String msg;

    private static AbstractStringDataType getStringDataType(boolean unicode, int length) {
        return unicode ? new UnicodeDataType() : (length > 0 ? new StringDataType() : new TerminatedStringDataType());
    }

    public CreateStringCmd(Address addr, AbstractStringDataType stringDataType, int length, DataUtilities.ClearDataMode clearMode) {
        this.addr = addr;
        this.stringDataType = stringDataType;
        this.length = length;
        this.clearMode = clearMode;
    }

    public CreateStringCmd(Address addr, int length, boolean unicode, DataUtilities.ClearDataMode clearMode) {
        this(addr, CreateStringCmd.getStringDataType(unicode, length), length, clearMode);
    }

    public CreateStringCmd(Address addr, int length, boolean unicode) {
        this(addr, CreateStringCmd.getStringDataType(unicode, length), length, DataUtilities.ClearDataMode.CLEAR_SINGLE_DATA);
    }

    public CreateStringCmd(Address addr) {
        this(addr, -1, false);
    }

    public CreateStringCmd(Address addr, int length) {
        this(addr, length, false);
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        try {
            DataUtilities.createData((Program)program, (Address)this.addr, (DataType)this.stringDataType, (int)this.length, (DataUtilities.ClearDataMode)this.clearMode);
        }
        catch (CodeUnitInsertionException e) {
            this.msg = e.getMessage();
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create String";
    }
}

